/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRuleGroupSummaryResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<DescribeRuleGroupSummaryResponse.Builder, DescribeRuleGroupSummaryResponse> {
    private static final SdkField<String> RULE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupName").getter(getter(DescribeRuleGroupSummaryResponse::ruleGroupName))
            .setter(setter(Builder::ruleGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeRuleGroupSummaryResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Summary> SUMMARY_FIELD = SdkField.<Summary> builder(MarshallingType.SDK_POJO)
            .memberName("Summary").getter(getter(DescribeRuleGroupSummaryResponse::summary)).setter(setter(Builder::summary))
            .constructor(Summary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_NAME_FIELD,
            DESCRIPTION_FIELD, SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ruleGroupName;

    private final String description;

    private final Summary summary;

    private DescribeRuleGroupSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.ruleGroupName = builder.ruleGroupName;
        this.description = builder.description;
        this.summary = builder.summary;
    }

    /**
     * <p>
     * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
     * </p>
     * 
     * @return The descriptive name of the rule group. You can't change the name of a rule group after you create it.
     */
    public final String ruleGroupName() {
        return ruleGroupName;
    }

    /**
     * <p>
     * A description of the rule group.
     * </p>
     * 
     * @return A description of the rule group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A complex type that contains rule information based on the rule group's configured summary settings. The content
     * varies depending on the fields that you specified to extract in your SummaryConfiguration. When you haven't
     * configured any summary settings, this returns an empty array. The response might include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Rule identifiers
     * </p>
     * </li>
     * <li>
     * <p>
     * Rule descriptions
     * </p>
     * </li>
     * <li>
     * <p>
     * Any metadata fields that you specified in your SummaryConfiguration
     * </p>
     * </li>
     * </ul>
     * 
     * @return A complex type that contains rule information based on the rule group's configured summary settings. The
     *         content varies depending on the fields that you specified to extract in your SummaryConfiguration. When
     *         you haven't configured any summary settings, this returns an empty array. The response might include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Rule identifiers
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Rule descriptions
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Any metadata fields that you specified in your SummaryConfiguration
     *         </p>
     *         </li>
     */
    public final Summary summary() {
        return summary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRuleGroupSummaryResponse)) {
            return false;
        }
        DescribeRuleGroupSummaryResponse other = (DescribeRuleGroupSummaryResponse) obj;
        return Objects.equals(ruleGroupName(), other.ruleGroupName()) && Objects.equals(description(), other.description())
                && Objects.equals(summary(), other.summary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRuleGroupSummaryResponse").add("RuleGroupName", ruleGroupName())
                .add("Description", description()).add("Summary", summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleGroupName":
            return Optional.ofNullable(clazz.cast(ruleGroupName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleGroupName", RULE_GROUP_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Summary", SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRuleGroupSummaryResponse, T> g) {
        return obj -> g.apply((DescribeRuleGroupSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRuleGroupSummaryResponse> {
        /**
         * <p>
         * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
         * </p>
         * 
         * @param ruleGroupName
         *        The descriptive name of the rule group. You can't change the name of a rule group after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupName(String ruleGroupName);

        /**
         * <p>
         * A description of the rule group.
         * </p>
         * 
         * @param description
         *        A description of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A complex type that contains rule information based on the rule group's configured summary settings. The
         * content varies depending on the fields that you specified to extract in your SummaryConfiguration. When you
         * haven't configured any summary settings, this returns an empty array. The response might include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Rule identifiers
         * </p>
         * </li>
         * <li>
         * <p>
         * Rule descriptions
         * </p>
         * </li>
         * <li>
         * <p>
         * Any metadata fields that you specified in your SummaryConfiguration
         * </p>
         * </li>
         * </ul>
         * 
         * @param summary
         *        A complex type that contains rule information based on the rule group's configured summary settings.
         *        The content varies depending on the fields that you specified to extract in your SummaryConfiguration.
         *        When you haven't configured any summary settings, this returns an empty array. The response might
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Rule identifiers
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Rule descriptions
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Any metadata fields that you specified in your SummaryConfiguration
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(Summary summary);

        /**
         * <p>
         * A complex type that contains rule information based on the rule group's configured summary settings. The
         * content varies depending on the fields that you specified to extract in your SummaryConfiguration. When you
         * haven't configured any summary settings, this returns an empty array. The response might include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Rule identifiers
         * </p>
         * </li>
         * <li>
         * <p>
         * Rule descriptions
         * </p>
         * </li>
         * <li>
         * <p>
         * Any metadata fields that you specified in your SummaryConfiguration
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link Summary.Builder} avoiding the need to
         * create one manually via {@link Summary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Summary.Builder#build()} is called immediately and its result is
         * passed to {@link #summary(Summary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link Summary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(Summary)
         */
        default Builder summary(Consumer<Summary.Builder> summary) {
            return summary(Summary.builder().applyMutation(summary).build());
        }
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private String ruleGroupName;

        private String description;

        private Summary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRuleGroupSummaryResponse model) {
            super(model);
            ruleGroupName(model.ruleGroupName);
            description(model.description);
            summary(model.summary);
        }

        public final String getRuleGroupName() {
            return ruleGroupName;
        }

        public final void setRuleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
        }

        @Override
        public final Builder ruleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Summary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(Summary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(Summary summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public DescribeRuleGroupSummaryResponse build() {
            return new DescribeRuleGroupSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
