/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProxyRuleResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<DescribeProxyRuleResponse.Builder, DescribeProxyRuleResponse> {
    private static final SdkField<ProxyRule> PROXY_RULE_FIELD = SdkField.<ProxyRule> builder(MarshallingType.SDK_POJO)
            .memberName("ProxyRule").getter(getter(DescribeProxyRuleResponse::proxyRule)).setter(setter(Builder::proxyRule))
            .constructor(ProxyRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRule").build()).build();

    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(DescribeProxyRuleResponse::updateToken))
            .setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_FIELD,
            UPDATE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ProxyRule proxyRule;

    private final String updateToken;

    private DescribeProxyRuleResponse(BuilderImpl builder) {
        super(builder);
        this.proxyRule = builder.proxyRule;
        this.updateToken = builder.updateToken;
    }

    /**
     * <p>
     * The configuration for the specified proxy rule.
     * </p>
     * 
     * @return The configuration for the specified proxy rule.
     */
    public final ProxyRule proxyRule() {
        return proxyRule;
    }

    /**
     * <p>
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy
     * rule. The token marks the state of the proxy rule resource at the time of the request.
     * </p>
     * <p>
     * To make changes to the proxy rule, you provide the token in your request. Network Firewall uses the token to
     * ensure that the proxy rule hasn't changed since you last retrieved it. If it has changed, the operation fails
     * with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy rule again to get a current copy
     * of it with a current token. Reapply your changes as needed, then try the operation again using the new token.
     * </p>
     * 
     * @return A token used for optimistic locking. Network Firewall returns a token to your requests that access the
     *         proxy rule. The token marks the state of the proxy rule resource at the time of the request. </p>
     *         <p>
     *         To make changes to the proxy rule, you provide the token in your request. Network Firewall uses the token
     *         to ensure that the proxy rule hasn't changed since you last retrieved it. If it has changed, the
     *         operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy rule
     *         again to get a current copy of it with a current token. Reapply your changes as needed, then try the
     *         operation again using the new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proxyRule());
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProxyRuleResponse)) {
            return false;
        }
        DescribeProxyRuleResponse other = (DescribeProxyRuleResponse) obj;
        return Objects.equals(proxyRule(), other.proxyRule()) && Objects.equals(updateToken(), other.updateToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProxyRuleResponse").add("ProxyRule", proxyRule()).add("UpdateToken", updateToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProxyRule":
            return Optional.ofNullable(clazz.cast(proxyRule()));
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProxyRule", PROXY_RULE_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeProxyRuleResponse, T> g) {
        return obj -> g.apply((DescribeProxyRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeProxyRuleResponse> {
        /**
         * <p>
         * The configuration for the specified proxy rule.
         * </p>
         * 
         * @param proxyRule
         *        The configuration for the specified proxy rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRule(ProxyRule proxyRule);

        /**
         * <p>
         * The configuration for the specified proxy rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProxyRule.Builder} avoiding the need to
         * create one manually via {@link ProxyRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProxyRule.Builder#build()} is called immediately and its result
         * is passed to {@link #proxyRule(ProxyRule)}.
         * 
         * @param proxyRule
         *        a consumer that will call methods on {@link ProxyRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proxyRule(ProxyRule)
         */
        default Builder proxyRule(Consumer<ProxyRule.Builder> proxyRule) {
            return proxyRule(ProxyRule.builder().applyMutation(proxyRule).build());
        }

        /**
         * <p>
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the proxy
         * rule. The token marks the state of the proxy rule resource at the time of the request.
         * </p>
         * <p>
         * To make changes to the proxy rule, you provide the token in your request. Network Firewall uses the token to
         * ensure that the proxy rule hasn't changed since you last retrieved it. If it has changed, the operation fails
         * with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy rule again to get a current
         * copy of it with a current token. Reapply your changes as needed, then try the operation again using the new
         * token.
         * </p>
         * 
         * @param updateToken
         *        A token used for optimistic locking. Network Firewall returns a token to your requests that access the
         *        proxy rule. The token marks the state of the proxy rule resource at the time of the request. </p>
         *        <p>
         *        To make changes to the proxy rule, you provide the token in your request. Network Firewall uses the
         *        token to ensure that the proxy rule hasn't changed since you last retrieved it. If it has changed, the
         *        operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the proxy rule
         *        again to get a current copy of it with a current token. Reapply your changes as needed, then try the
         *        operation again using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private ProxyRule proxyRule;

        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProxyRuleResponse model) {
            super(model);
            proxyRule(model.proxyRule);
            updateToken(model.updateToken);
        }

        public final ProxyRule.Builder getProxyRule() {
            return proxyRule != null ? proxyRule.toBuilder() : null;
        }

        public final void setProxyRule(ProxyRule.BuilderImpl proxyRule) {
            this.proxyRule = proxyRule != null ? proxyRule.build() : null;
        }

        @Override
        public final Builder proxyRule(ProxyRule proxyRule) {
            this.proxyRule = proxyRule;
            return this;
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public DescribeProxyRuleResponse build() {
            return new DescribeProxyRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
