/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFlowOperationRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<DescribeFlowOperationRequest.Builder, DescribeFlowOperationRequest> {
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallArn").getter(getter(DescribeFlowOperationRequest::firewallArn))
            .setter(setter(Builder::firewallArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(DescribeFlowOperationRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointAssociationArn").getter(getter(DescribeFlowOperationRequest::vpcEndpointAssociationArn))
            .setter(setter(Builder::vpcEndpointAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointAssociationArn").build())
            .build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId").getter(getter(DescribeFlowOperationRequest::vpcEndpointId))
            .setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()).build();

    private static final SdkField<String> FLOW_OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowOperationId").getter(getter(DescribeFlowOperationRequest::flowOperationId))
            .setter(setter(Builder::flowOperationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_ARN_FIELD,
            AVAILABILITY_ZONE_FIELD, VPC_ENDPOINT_ASSOCIATION_ARN_FIELD, VPC_ENDPOINT_ID_FIELD, FLOW_OPERATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String firewallArn;

    private final String availabilityZone;

    private final String vpcEndpointAssociationArn;

    private final String vpcEndpointId;

    private final String flowOperationId;

    private DescribeFlowOperationRequest(BuilderImpl builder) {
        super(builder);
        this.firewallArn = builder.firewallArn;
        this.availabilityZone = builder.availabilityZone;
        this.vpcEndpointAssociationArn = builder.vpcEndpointAssociationArn;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.flowOperationId = builder.flowOperationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the firewall.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the firewall.
     */
    public final String firewallArn() {
        return firewallArn;
    }

    /**
     * <p>
     * The ID of the Availability Zone where the firewall is located. For example, <code>us-east-2a</code>.
     * </p>
     * <p>
     * Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
     * </p>
     * 
     * @return The ID of the Availability Zone where the firewall is located. For example, <code>us-east-2a</code>.</p>
     *         <p>
     *         Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a VPC endpoint association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a VPC endpoint association.
     */
    public final String vpcEndpointAssociationArn() {
        return vpcEndpointAssociationArn;
    }

    /**
     * <p>
     * A unique identifier for the primary endpoint associated with a firewall.
     * </p>
     * 
     * @return A unique identifier for the primary endpoint associated with a firewall.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * A unique identifier for the flow operation. This ID is returned in the responses to start and list commands. You
     * provide to describe commands.
     * </p>
     * 
     * @return A unique identifier for the flow operation. This ID is returned in the responses to start and list
     *         commands. You provide to describe commands.
     */
    public final String flowOperationId() {
        return flowOperationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(flowOperationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowOperationRequest)) {
            return false;
        }
        DescribeFlowOperationRequest other = (DescribeFlowOperationRequest) obj;
        return Objects.equals(firewallArn(), other.firewallArn()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(vpcEndpointAssociationArn(), other.vpcEndpointAssociationArn())
                && Objects.equals(vpcEndpointId(), other.vpcEndpointId())
                && Objects.equals(flowOperationId(), other.flowOperationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFlowOperationRequest").add("FirewallArn", firewallArn())
                .add("AvailabilityZone", availabilityZone()).add("VpcEndpointAssociationArn", vpcEndpointAssociationArn())
                .add("VpcEndpointId", vpcEndpointId()).add("FlowOperationId", flowOperationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallArn":
            return Optional.ofNullable(clazz.cast(firewallArn()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "VpcEndpointAssociationArn":
            return Optional.ofNullable(clazz.cast(vpcEndpointAssociationArn()));
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "FlowOperationId":
            return Optional.ofNullable(clazz.cast(flowOperationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("VpcEndpointAssociationArn", VPC_ENDPOINT_ASSOCIATION_ARN_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("FlowOperationId", FLOW_OPERATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFlowOperationRequest, T> g) {
        return obj -> g.apply((DescribeFlowOperationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFlowOperationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the firewall.
         * </p>
         * 
         * @param firewallArn
         *        The Amazon Resource Name (ARN) of the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallArn(String firewallArn);

        /**
         * <p>
         * The ID of the Availability Zone where the firewall is located. For example, <code>us-east-2a</code>.
         * </p>
         * <p>
         * Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
         * </p>
         * 
         * @param availabilityZone
         *        The ID of the Availability Zone where the firewall is located. For example, <code>us-east-2a</code>
         *        .</p>
         *        <p>
         *        Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a VPC endpoint association.
         * </p>
         * 
         * @param vpcEndpointAssociationArn
         *        The Amazon Resource Name (ARN) of a VPC endpoint association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointAssociationArn(String vpcEndpointAssociationArn);

        /**
         * <p>
         * A unique identifier for the primary endpoint associated with a firewall.
         * </p>
         * 
         * @param vpcEndpointId
         *        A unique identifier for the primary endpoint associated with a firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * A unique identifier for the flow operation. This ID is returned in the responses to start and list commands.
         * You provide to describe commands.
         * </p>
         * 
         * @param flowOperationId
         *        A unique identifier for the flow operation. This ID is returned in the responses to start and list
         *        commands. You provide to describe commands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowOperationId(String flowOperationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String firewallArn;

        private String availabilityZone;

        private String vpcEndpointAssociationArn;

        private String vpcEndpointId;

        private String flowOperationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowOperationRequest model) {
            super(model);
            firewallArn(model.firewallArn);
            availabilityZone(model.availabilityZone);
            vpcEndpointAssociationArn(model.vpcEndpointAssociationArn);
            vpcEndpointId(model.vpcEndpointId);
            flowOperationId(model.flowOperationId);
        }

        public final String getFirewallArn() {
            return firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getVpcEndpointAssociationArn() {
            return vpcEndpointAssociationArn;
        }

        public final void setVpcEndpointAssociationArn(String vpcEndpointAssociationArn) {
            this.vpcEndpointAssociationArn = vpcEndpointAssociationArn;
        }

        @Override
        public final Builder vpcEndpointAssociationArn(String vpcEndpointAssociationArn) {
            this.vpcEndpointAssociationArn = vpcEndpointAssociationArn;
            return this;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getFlowOperationId() {
            return flowOperationId;
        }

        public final void setFlowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
        }

        @Override
        public final Builder flowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFlowOperationRequest build() {
            return new DescribeFlowOperationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
