/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTlsInspectionConfigurationResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<DeleteTlsInspectionConfigurationResponse.Builder, DeleteTlsInspectionConfigurationResponse> {
    private static final SdkField<TLSInspectionConfigurationResponse> TLS_INSPECTION_CONFIGURATION_RESPONSE_FIELD = SdkField
            .<TLSInspectionConfigurationResponse> builder(MarshallingType.SDK_POJO)
            .memberName("TLSInspectionConfigurationResponse")
            .getter(getter(DeleteTlsInspectionConfigurationResponse::tlsInspectionConfigurationResponse))
            .setter(setter(Builder::tlsInspectionConfigurationResponse))
            .constructor(TLSInspectionConfigurationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationResponse")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TLS_INSPECTION_CONFIGURATION_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TLSInspectionConfigurationResponse tlsInspectionConfigurationResponse;

    private DeleteTlsInspectionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.tlsInspectionConfigurationResponse = builder.tlsInspectionConfigurationResponse;
    }

    /**
     * <p>
     * The high-level properties of a TLS inspection configuration. This, along with the
     * <a>TLSInspectionConfiguration</a>, define the TLS inspection configuration. You can retrieve all objects for a
     * TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
     * </p>
     * 
     * @return The high-level properties of a TLS inspection configuration. This, along with the
     *         <a>TLSInspectionConfiguration</a>, define the TLS inspection configuration. You can retrieve all objects
     *         for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
     */
    public final TLSInspectionConfigurationResponse tlsInspectionConfigurationResponse() {
        return tlsInspectionConfigurationResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tlsInspectionConfigurationResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTlsInspectionConfigurationResponse)) {
            return false;
        }
        DeleteTlsInspectionConfigurationResponse other = (DeleteTlsInspectionConfigurationResponse) obj;
        return Objects.equals(tlsInspectionConfigurationResponse(), other.tlsInspectionConfigurationResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteTlsInspectionConfigurationResponse")
                .add("TLSInspectionConfigurationResponse", tlsInspectionConfigurationResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TLSInspectionConfigurationResponse":
            return Optional.ofNullable(clazz.cast(tlsInspectionConfigurationResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TLSInspectionConfigurationResponse", TLS_INSPECTION_CONFIGURATION_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteTlsInspectionConfigurationResponse, T> g) {
        return obj -> g.apply((DeleteTlsInspectionConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteTlsInspectionConfigurationResponse> {
        /**
         * <p>
         * The high-level properties of a TLS inspection configuration. This, along with the
         * <a>TLSInspectionConfiguration</a>, define the TLS inspection configuration. You can retrieve all objects for
         * a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
         * </p>
         * 
         * @param tlsInspectionConfigurationResponse
         *        The high-level properties of a TLS inspection configuration. This, along with the
         *        <a>TLSInspectionConfiguration</a>, define the TLS inspection configuration. You can retrieve all
         *        objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsInspectionConfigurationResponse(TLSInspectionConfigurationResponse tlsInspectionConfigurationResponse);

        /**
         * <p>
         * The high-level properties of a TLS inspection configuration. This, along with the
         * <a>TLSInspectionConfiguration</a>, define the TLS inspection configuration. You can retrieve all objects for
         * a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TLSInspectionConfigurationResponse.Builder} avoiding the need to create one manually via
         * {@link TLSInspectionConfigurationResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TLSInspectionConfigurationResponse.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #tlsInspectionConfigurationResponse(TLSInspectionConfigurationResponse)}.
         * 
         * @param tlsInspectionConfigurationResponse
         *        a consumer that will call methods on {@link TLSInspectionConfigurationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tlsInspectionConfigurationResponse(TLSInspectionConfigurationResponse)
         */
        default Builder tlsInspectionConfigurationResponse(
                Consumer<TLSInspectionConfigurationResponse.Builder> tlsInspectionConfigurationResponse) {
            return tlsInspectionConfigurationResponse(TLSInspectionConfigurationResponse.builder()
                    .applyMutation(tlsInspectionConfigurationResponse).build());
        }
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private TLSInspectionConfigurationResponse tlsInspectionConfigurationResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTlsInspectionConfigurationResponse model) {
            super(model);
            tlsInspectionConfigurationResponse(model.tlsInspectionConfigurationResponse);
        }

        public final TLSInspectionConfigurationResponse.Builder getTlsInspectionConfigurationResponse() {
            return tlsInspectionConfigurationResponse != null ? tlsInspectionConfigurationResponse.toBuilder() : null;
        }

        public final void setTlsInspectionConfigurationResponse(
                TLSInspectionConfigurationResponse.BuilderImpl tlsInspectionConfigurationResponse) {
            this.tlsInspectionConfigurationResponse = tlsInspectionConfigurationResponse != null ? tlsInspectionConfigurationResponse
                    .build() : null;
        }

        @Override
        public final Builder tlsInspectionConfigurationResponse(
                TLSInspectionConfigurationResponse tlsInspectionConfigurationResponse) {
            this.tlsInspectionConfigurationResponse = tlsInspectionConfigurationResponse;
            return this;
        }

        @Override
        public DeleteTlsInspectionConfigurationResponse build() {
            return new DeleteTlsInspectionConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
