/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcEndpointAssociationResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<CreateVpcEndpointAssociationResponse.Builder, CreateVpcEndpointAssociationResponse> {
    private static final SdkField<VpcEndpointAssociation> VPC_ENDPOINT_ASSOCIATION_FIELD = SdkField
            .<VpcEndpointAssociation> builder(MarshallingType.SDK_POJO).memberName("VpcEndpointAssociation")
            .getter(getter(CreateVpcEndpointAssociationResponse::vpcEndpointAssociation))
            .setter(setter(Builder::vpcEndpointAssociation)).constructor(VpcEndpointAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointAssociation").build())
            .build();

    private static final SdkField<VpcEndpointAssociationStatus> VPC_ENDPOINT_ASSOCIATION_STATUS_FIELD = SdkField
            .<VpcEndpointAssociationStatus> builder(MarshallingType.SDK_POJO)
            .memberName("VpcEndpointAssociationStatus")
            .getter(getter(CreateVpcEndpointAssociationResponse::vpcEndpointAssociationStatus))
            .setter(setter(Builder::vpcEndpointAssociationStatus))
            .constructor(VpcEndpointAssociationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointAssociationStatus")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VPC_ENDPOINT_ASSOCIATION_FIELD, VPC_ENDPOINT_ASSOCIATION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VpcEndpointAssociation vpcEndpointAssociation;

    private final VpcEndpointAssociationStatus vpcEndpointAssociationStatus;

    private CreateVpcEndpointAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEndpointAssociation = builder.vpcEndpointAssociation;
        this.vpcEndpointAssociationStatus = builder.vpcEndpointAssociationStatus;
    }

    /**
     * <p>
     * The configuration settings for the VPC endpoint association. These settings include the firewall and the VPC and
     * subnet to use for the firewall endpoint.
     * </p>
     * 
     * @return The configuration settings for the VPC endpoint association. These settings include the firewall and the
     *         VPC and subnet to use for the firewall endpoint.
     */
    public final VpcEndpointAssociation vpcEndpointAssociation() {
        return vpcEndpointAssociation;
    }

    /**
     * <p>
     * Detailed information about the current status of a <a>VpcEndpointAssociation</a>. You can retrieve this by
     * calling <a>DescribeVpcEndpointAssociation</a> and providing the VPC endpoint association ARN.
     * </p>
     * 
     * @return Detailed information about the current status of a <a>VpcEndpointAssociation</a>. You can retrieve this
     *         by calling <a>DescribeVpcEndpointAssociation</a> and providing the VPC endpoint association ARN.
     */
    public final VpcEndpointAssociationStatus vpcEndpointAssociationStatus() {
        return vpcEndpointAssociationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointAssociationStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointAssociationResponse)) {
            return false;
        }
        CreateVpcEndpointAssociationResponse other = (CreateVpcEndpointAssociationResponse) obj;
        return Objects.equals(vpcEndpointAssociation(), other.vpcEndpointAssociation())
                && Objects.equals(vpcEndpointAssociationStatus(), other.vpcEndpointAssociationStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpcEndpointAssociationResponse").add("VpcEndpointAssociation", vpcEndpointAssociation())
                .add("VpcEndpointAssociationStatus", vpcEndpointAssociationStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointAssociation":
            return Optional.ofNullable(clazz.cast(vpcEndpointAssociation()));
        case "VpcEndpointAssociationStatus":
            return Optional.ofNullable(clazz.cast(vpcEndpointAssociationStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcEndpointAssociation", VPC_ENDPOINT_ASSOCIATION_FIELD);
        map.put("VpcEndpointAssociationStatus", VPC_ENDPOINT_ASSOCIATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointAssociationResponse, T> g) {
        return obj -> g.apply((CreateVpcEndpointAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateVpcEndpointAssociationResponse> {
        /**
         * <p>
         * The configuration settings for the VPC endpoint association. These settings include the firewall and the VPC
         * and subnet to use for the firewall endpoint.
         * </p>
         * 
         * @param vpcEndpointAssociation
         *        The configuration settings for the VPC endpoint association. These settings include the firewall and
         *        the VPC and subnet to use for the firewall endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointAssociation(VpcEndpointAssociation vpcEndpointAssociation);

        /**
         * <p>
         * The configuration settings for the VPC endpoint association. These settings include the firewall and the VPC
         * and subnet to use for the firewall endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcEndpointAssociation.Builder} avoiding
         * the need to create one manually via {@link VpcEndpointAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcEndpointAssociation.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcEndpointAssociation(VpcEndpointAssociation)}.
         * 
         * @param vpcEndpointAssociation
         *        a consumer that will call methods on {@link VpcEndpointAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpointAssociation(VpcEndpointAssociation)
         */
        default Builder vpcEndpointAssociation(Consumer<VpcEndpointAssociation.Builder> vpcEndpointAssociation) {
            return vpcEndpointAssociation(VpcEndpointAssociation.builder().applyMutation(vpcEndpointAssociation).build());
        }

        /**
         * <p>
         * Detailed information about the current status of a <a>VpcEndpointAssociation</a>. You can retrieve this by
         * calling <a>DescribeVpcEndpointAssociation</a> and providing the VPC endpoint association ARN.
         * </p>
         * 
         * @param vpcEndpointAssociationStatus
         *        Detailed information about the current status of a <a>VpcEndpointAssociation</a>. You can retrieve
         *        this by calling <a>DescribeVpcEndpointAssociation</a> and providing the VPC endpoint association ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointAssociationStatus(VpcEndpointAssociationStatus vpcEndpointAssociationStatus);

        /**
         * <p>
         * Detailed information about the current status of a <a>VpcEndpointAssociation</a>. You can retrieve this by
         * calling <a>DescribeVpcEndpointAssociation</a> and providing the VPC endpoint association ARN.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcEndpointAssociationStatus.Builder}
         * avoiding the need to create one manually via {@link VpcEndpointAssociationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcEndpointAssociationStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcEndpointAssociationStatus(VpcEndpointAssociationStatus)}.
         * 
         * @param vpcEndpointAssociationStatus
         *        a consumer that will call methods on {@link VpcEndpointAssociationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpointAssociationStatus(VpcEndpointAssociationStatus)
         */
        default Builder vpcEndpointAssociationStatus(Consumer<VpcEndpointAssociationStatus.Builder> vpcEndpointAssociationStatus) {
            return vpcEndpointAssociationStatus(VpcEndpointAssociationStatus.builder()
                    .applyMutation(vpcEndpointAssociationStatus).build());
        }
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private VpcEndpointAssociation vpcEndpointAssociation;

        private VpcEndpointAssociationStatus vpcEndpointAssociationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointAssociationResponse model) {
            super(model);
            vpcEndpointAssociation(model.vpcEndpointAssociation);
            vpcEndpointAssociationStatus(model.vpcEndpointAssociationStatus);
        }

        public final VpcEndpointAssociation.Builder getVpcEndpointAssociation() {
            return vpcEndpointAssociation != null ? vpcEndpointAssociation.toBuilder() : null;
        }

        public final void setVpcEndpointAssociation(VpcEndpointAssociation.BuilderImpl vpcEndpointAssociation) {
            this.vpcEndpointAssociation = vpcEndpointAssociation != null ? vpcEndpointAssociation.build() : null;
        }

        @Override
        public final Builder vpcEndpointAssociation(VpcEndpointAssociation vpcEndpointAssociation) {
            this.vpcEndpointAssociation = vpcEndpointAssociation;
            return this;
        }

        public final VpcEndpointAssociationStatus.Builder getVpcEndpointAssociationStatus() {
            return vpcEndpointAssociationStatus != null ? vpcEndpointAssociationStatus.toBuilder() : null;
        }

        public final void setVpcEndpointAssociationStatus(VpcEndpointAssociationStatus.BuilderImpl vpcEndpointAssociationStatus) {
            this.vpcEndpointAssociationStatus = vpcEndpointAssociationStatus != null ? vpcEndpointAssociationStatus.build()
                    : null;
        }

        @Override
        public final Builder vpcEndpointAssociationStatus(VpcEndpointAssociationStatus vpcEndpointAssociationStatus) {
            this.vpcEndpointAssociationStatus = vpcEndpointAssociationStatus;
            return this;
        }

        @Override
        public CreateVpcEndpointAssociationResponse build() {
            return new CreateVpcEndpointAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
