/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProxyRulesRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<CreateProxyRulesRequest.Builder, CreateProxyRulesRequest> {
    private static final SdkField<String> PROXY_RULE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyRuleGroupArn").getter(getter(CreateProxyRulesRequest::proxyRuleGroupArn))
            .setter(setter(Builder::proxyRuleGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupArn").build()).build();

    private static final SdkField<String> PROXY_RULE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyRuleGroupName").getter(getter(CreateProxyRulesRequest::proxyRuleGroupName))
            .setter(setter(Builder::proxyRuleGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroupName").build())
            .build();

    private static final SdkField<CreateProxyRulesByRequestPhase> RULES_FIELD = SdkField
            .<CreateProxyRulesByRequestPhase> builder(MarshallingType.SDK_POJO).memberName("Rules")
            .getter(getter(CreateProxyRulesRequest::rules)).setter(setter(Builder::rules))
            .constructor(CreateProxyRulesByRequestPhase::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_GROUP_ARN_FIELD,
            PROXY_RULE_GROUP_NAME_FIELD, RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String proxyRuleGroupArn;

    private final String proxyRuleGroupName;

    private final CreateProxyRulesByRequestPhase rules;

    private CreateProxyRulesRequest(BuilderImpl builder) {
        super(builder);
        this.proxyRuleGroupArn = builder.proxyRuleGroupArn;
        this.proxyRuleGroupName = builder.proxyRuleGroupName;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a proxy rule group.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a proxy rule group.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String proxyRuleGroupArn() {
        return proxyRuleGroupArn;
    }

    /**
     * <p>
     * The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you create
     * it.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you
     *         create it.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String proxyRuleGroupName() {
        return proxyRuleGroupName;
    }

    /**
     * <p>
     * Individual rules that define match conditions and actions for application-layer traffic. Rules specify what to
     * inspect (domains, headers, methods) and what action to take (allow, deny, alert).
     * </p>
     * 
     * @return Individual rules that define match conditions and actions for application-layer traffic. Rules specify
     *         what to inspect (domains, headers, methods) and what action to take (allow, deny, alert).
     */
    public final CreateProxyRulesByRequestPhase rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proxyRuleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(proxyRuleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(rules());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProxyRulesRequest)) {
            return false;
        }
        CreateProxyRulesRequest other = (CreateProxyRulesRequest) obj;
        return Objects.equals(proxyRuleGroupArn(), other.proxyRuleGroupArn())
                && Objects.equals(proxyRuleGroupName(), other.proxyRuleGroupName()) && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProxyRulesRequest").add("ProxyRuleGroupArn", proxyRuleGroupArn())
                .add("ProxyRuleGroupName", proxyRuleGroupName()).add("Rules", rules()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProxyRuleGroupArn":
            return Optional.ofNullable(clazz.cast(proxyRuleGroupArn()));
        case "ProxyRuleGroupName":
            return Optional.ofNullable(clazz.cast(proxyRuleGroupName()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProxyRuleGroupArn", PROXY_RULE_GROUP_ARN_FIELD);
        map.put("ProxyRuleGroupName", PROXY_RULE_GROUP_NAME_FIELD);
        map.put("Rules", RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProxyRulesRequest, T> g) {
        return obj -> g.apply((CreateProxyRulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProxyRulesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a proxy rule group.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param proxyRuleGroupArn
         *        The Amazon Resource Name (ARN) of a proxy rule group.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRuleGroupArn(String proxyRuleGroupArn);

        /**
         * <p>
         * The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after you
         * create it.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param proxyRuleGroupName
         *        The descriptive name of the proxy rule group. You can't change the name of a proxy rule group after
         *        you create it.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRuleGroupName(String proxyRuleGroupName);

        /**
         * <p>
         * Individual rules that define match conditions and actions for application-layer traffic. Rules specify what
         * to inspect (domains, headers, methods) and what action to take (allow, deny, alert).
         * </p>
         * 
         * @param rules
         *        Individual rules that define match conditions and actions for application-layer traffic. Rules specify
         *        what to inspect (domains, headers, methods) and what action to take (allow, deny, alert).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(CreateProxyRulesByRequestPhase rules);

        /**
         * <p>
         * Individual rules that define match conditions and actions for application-layer traffic. Rules specify what
         * to inspect (domains, headers, methods) and what action to take (allow, deny, alert).
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateProxyRulesByRequestPhase.Builder}
         * avoiding the need to create one manually via {@link CreateProxyRulesByRequestPhase#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateProxyRulesByRequestPhase.Builder#build()} is called
         * immediately and its result is passed to {@link #rules(CreateProxyRulesByRequestPhase)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link CreateProxyRulesByRequestPhase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(CreateProxyRulesByRequestPhase)
         */
        default Builder rules(Consumer<CreateProxyRulesByRequestPhase.Builder> rules) {
            return rules(CreateProxyRulesByRequestPhase.builder().applyMutation(rules).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String proxyRuleGroupArn;

        private String proxyRuleGroupName;

        private CreateProxyRulesByRequestPhase rules;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProxyRulesRequest model) {
            super(model);
            proxyRuleGroupArn(model.proxyRuleGroupArn);
            proxyRuleGroupName(model.proxyRuleGroupName);
            rules(model.rules);
        }

        public final String getProxyRuleGroupArn() {
            return proxyRuleGroupArn;
        }

        public final void setProxyRuleGroupArn(String proxyRuleGroupArn) {
            this.proxyRuleGroupArn = proxyRuleGroupArn;
        }

        @Override
        public final Builder proxyRuleGroupArn(String proxyRuleGroupArn) {
            this.proxyRuleGroupArn = proxyRuleGroupArn;
            return this;
        }

        public final String getProxyRuleGroupName() {
            return proxyRuleGroupName;
        }

        public final void setProxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
        }

        @Override
        public final Builder proxyRuleGroupName(String proxyRuleGroupName) {
            this.proxyRuleGroupName = proxyRuleGroupName;
            return this;
        }

        public final CreateProxyRulesByRequestPhase.Builder getRules() {
            return rules != null ? rules.toBuilder() : null;
        }

        public final void setRules(CreateProxyRulesByRequestPhase.BuilderImpl rules) {
            this.rules = rules != null ? rules.build() : null;
        }

        @Override
        public final Builder rules(CreateProxyRulesByRequestPhase rules) {
            this.rules = rules;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProxyRulesRequest build() {
            return new CreateProxyRulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
