/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Individual rules that define match conditions and actions for application-layer traffic. Rules specify what to
 * inspect (domains, headers, methods) and what action to take (allow, deny, alert).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProxyRule implements SdkPojo, Serializable, ToCopyableBuilder<CreateProxyRule.Builder, CreateProxyRule> {
    private static final SdkField<String> PROXY_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyRuleName").getter(getter(CreateProxyRule::proxyRuleName)).setter(setter(Builder::proxyRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateProxyRule::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(CreateProxyRule::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<List<ProxyRuleCondition>> CONDITIONS_FIELD = SdkField
            .<List<ProxyRuleCondition>> builder(MarshallingType.LIST)
            .memberName("Conditions")
            .getter(getter(CreateProxyRule::conditions))
            .setter(setter(Builder::conditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProxyRuleCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProxyRuleCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> INSERT_POSITION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InsertPosition").getter(getter(CreateProxyRule::insertPosition)).setter(setter(Builder::insertPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsertPosition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_NAME_FIELD,
            DESCRIPTION_FIELD, ACTION_FIELD, CONDITIONS_FIELD, INSERT_POSITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String proxyRuleName;

    private final String description;

    private final String action;

    private final List<ProxyRuleCondition> conditions;

    private final Integer insertPosition;

    private CreateProxyRule(BuilderImpl builder) {
        this.proxyRuleName = builder.proxyRuleName;
        this.description = builder.description;
        this.action = builder.action;
        this.conditions = builder.conditions;
        this.insertPosition = builder.insertPosition;
    }

    /**
     * <p>
     * The descriptive name of the proxy rule. You can't change the name of a proxy rule after you create it.
     * </p>
     * 
     * @return The descriptive name of the proxy rule. You can't change the name of a proxy rule after you create it.
     */
    public final String proxyRuleName() {
        return proxyRuleName;
    }

    /**
     * <p>
     * A description of the proxy rule.
     * </p>
     * 
     * @return A description of the proxy rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Action to take.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ProxyRulePhaseAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return Action to take.
     * @see ProxyRulePhaseAction
     */
    public final ProxyRulePhaseAction action() {
        return ProxyRulePhaseAction.fromValue(action);
    }

    /**
     * <p>
     * Action to take.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ProxyRulePhaseAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return Action to take.
     * @see ProxyRulePhaseAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * For responses, this returns true if the service returned a value for the Conditions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConditions() {
        return conditions != null && !(conditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Match criteria that specify what traffic attributes to examine. Conditions include operators (StringEquals,
     * StringLike) and values to match against.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConditions} method.
     * </p>
     * 
     * @return Match criteria that specify what traffic attributes to examine. Conditions include operators
     *         (StringEquals, StringLike) and values to match against.
     */
    public final List<ProxyRuleCondition> conditions() {
        return conditions;
    }

    /**
     * <p>
     * Where to insert a proxy rule in a proxy rule group.
     * </p>
     * 
     * @return Where to insert a proxy rule in a proxy rule group.
     */
    public final Integer insertPosition() {
        return insertPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(proxyRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasConditions() ? conditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(insertPosition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProxyRule)) {
            return false;
        }
        CreateProxyRule other = (CreateProxyRule) obj;
        return Objects.equals(proxyRuleName(), other.proxyRuleName()) && Objects.equals(description(), other.description())
                && Objects.equals(actionAsString(), other.actionAsString()) && hasConditions() == other.hasConditions()
                && Objects.equals(conditions(), other.conditions()) && Objects.equals(insertPosition(), other.insertPosition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProxyRule").add("ProxyRuleName", proxyRuleName()).add("Description", description())
                .add("Action", actionAsString()).add("Conditions", hasConditions() ? conditions() : null)
                .add("InsertPosition", insertPosition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProxyRuleName":
            return Optional.ofNullable(clazz.cast(proxyRuleName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Conditions":
            return Optional.ofNullable(clazz.cast(conditions()));
        case "InsertPosition":
            return Optional.ofNullable(clazz.cast(insertPosition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProxyRuleName", PROXY_RULE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("Conditions", CONDITIONS_FIELD);
        map.put("InsertPosition", INSERT_POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProxyRule, T> g) {
        return obj -> g.apply((CreateProxyRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateProxyRule> {
        /**
         * <p>
         * The descriptive name of the proxy rule. You can't change the name of a proxy rule after you create it.
         * </p>
         * 
         * @param proxyRuleName
         *        The descriptive name of the proxy rule. You can't change the name of a proxy rule after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyRuleName(String proxyRuleName);

        /**
         * <p>
         * A description of the proxy rule.
         * </p>
         * 
         * @param description
         *        A description of the proxy rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Action to take.
         * </p>
         * 
         * @param action
         *        Action to take.
         * @see ProxyRulePhaseAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyRulePhaseAction
         */
        Builder action(String action);

        /**
         * <p>
         * Action to take.
         * </p>
         * 
         * @param action
         *        Action to take.
         * @see ProxyRulePhaseAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyRulePhaseAction
         */
        Builder action(ProxyRulePhaseAction action);

        /**
         * <p>
         * Match criteria that specify what traffic attributes to examine. Conditions include operators (StringEquals,
         * StringLike) and values to match against.
         * </p>
         * 
         * @param conditions
         *        Match criteria that specify what traffic attributes to examine. Conditions include operators
         *        (StringEquals, StringLike) and values to match against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Collection<ProxyRuleCondition> conditions);

        /**
         * <p>
         * Match criteria that specify what traffic attributes to examine. Conditions include operators (StringEquals,
         * StringLike) and values to match against.
         * </p>
         * 
         * @param conditions
         *        Match criteria that specify what traffic attributes to examine. Conditions include operators
         *        (StringEquals, StringLike) and values to match against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(ProxyRuleCondition... conditions);

        /**
         * <p>
         * Match criteria that specify what traffic attributes to examine. Conditions include operators (StringEquals,
         * StringLike) and values to match against.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #conditions(List<ProxyRuleCondition>)}.
         * 
         * @param conditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.ProxyRuleCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditions(java.util.Collection<ProxyRuleCondition>)
         */
        Builder conditions(Consumer<ProxyRuleCondition.Builder>... conditions);

        /**
         * <p>
         * Where to insert a proxy rule in a proxy rule group.
         * </p>
         * 
         * @param insertPosition
         *        Where to insert a proxy rule in a proxy rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insertPosition(Integer insertPosition);
    }

    static final class BuilderImpl implements Builder {
        private String proxyRuleName;

        private String description;

        private String action;

        private List<ProxyRuleCondition> conditions = DefaultSdkAutoConstructList.getInstance();

        private Integer insertPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProxyRule model) {
            proxyRuleName(model.proxyRuleName);
            description(model.description);
            action(model.action);
            conditions(model.conditions);
            insertPosition(model.insertPosition);
        }

        public final String getProxyRuleName() {
            return proxyRuleName;
        }

        public final void setProxyRuleName(String proxyRuleName) {
            this.proxyRuleName = proxyRuleName;
        }

        @Override
        public final Builder proxyRuleName(String proxyRuleName) {
            this.proxyRuleName = proxyRuleName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ProxyRulePhaseAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final List<ProxyRuleCondition.Builder> getConditions() {
            List<ProxyRuleCondition.Builder> result = ProxyRuleConditionListCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<ProxyRuleCondition.BuilderImpl> conditions) {
            this.conditions = ProxyRuleConditionListCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<ProxyRuleCondition> conditions) {
            this.conditions = ProxyRuleConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(ProxyRuleCondition... conditions) {
            conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<ProxyRuleCondition.Builder>... conditions) {
            conditions(Stream.of(conditions).map(c -> ProxyRuleCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getInsertPosition() {
            return insertPosition;
        }

        public final void setInsertPosition(Integer insertPosition) {
            this.insertPosition = insertPosition;
        }

        @Override
        public final Builder insertPosition(Integer insertPosition) {
            this.insertPosition = insertPosition;
            return this;
        }

        @Override
        public CreateProxyRule build() {
            return new CreateProxyRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
