/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProxyConfigurationRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<CreateProxyConfigurationRequest.Builder, CreateProxyConfigurationRequest> {
    private static final SdkField<String> PROXY_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyConfigurationName").getter(getter(CreateProxyConfigurationRequest::proxyConfigurationName))
            .setter(setter(Builder::proxyConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateProxyConfigurationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> RULE_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RuleGroupNames")
            .getter(getter(CreateProxyConfigurationRequest::ruleGroupNames))
            .setter(setter(Builder::ruleGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RULE_GROUP_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RuleGroupArns")
            .getter(getter(CreateProxyConfigurationRequest::ruleGroupArns))
            .setter(setter(Builder::ruleGroupArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProxyConfigDefaultRulePhaseActionsRequest> DEFAULT_RULE_PHASE_ACTIONS_FIELD = SdkField
            .<ProxyConfigDefaultRulePhaseActionsRequest> builder(MarshallingType.SDK_POJO).memberName("DefaultRulePhaseActions")
            .getter(getter(CreateProxyConfigurationRequest::defaultRulePhaseActions))
            .setter(setter(Builder::defaultRulePhaseActions)).constructor(ProxyConfigDefaultRulePhaseActionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRulePhaseActions").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateProxyConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROXY_CONFIGURATION_NAME_FIELD, DESCRIPTION_FIELD, RULE_GROUP_NAMES_FIELD, RULE_GROUP_ARNS_FIELD,
            DEFAULT_RULE_PHASE_ACTIONS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String proxyConfigurationName;

    private final String description;

    private final List<String> ruleGroupNames;

    private final List<String> ruleGroupArns;

    private final ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions;

    private final List<Tag> tags;

    private CreateProxyConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.proxyConfigurationName = builder.proxyConfigurationName;
        this.description = builder.description;
        this.ruleGroupNames = builder.ruleGroupNames;
        this.ruleGroupArns = builder.ruleGroupArns;
        this.defaultRulePhaseActions = builder.defaultRulePhaseActions;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after you
     * create it.
     * </p>
     * 
     * @return The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after
     *         you create it.
     */
    public final String proxyConfigurationName() {
        return proxyConfigurationName;
    }

    /**
     * <p>
     * A description of the proxy configuration.
     * </p>
     * 
     * @return A description of the proxy configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleGroupNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuleGroupNames() {
        return ruleGroupNames != null && !(ruleGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The proxy rule group name(s) to attach to the proxy configuration.
     * </p>
     * <p>
     * You must specify the ARNs or the names, and you can specify both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleGroupNames} method.
     * </p>
     * 
     * @return The proxy rule group name(s) to attach to the proxy configuration.</p>
     *         <p>
     *         You must specify the ARNs or the names, and you can specify both.
     */
    public final List<String> ruleGroupNames() {
        return ruleGroupNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleGroupArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuleGroupArns() {
        return ruleGroupArns != null && !(ruleGroupArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The proxy rule group arn(s) to attach to the proxy configuration.
     * </p>
     * <p>
     * You must specify the ARNs or the names, and you can specify both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleGroupArns} method.
     * </p>
     * 
     * @return The proxy rule group arn(s) to attach to the proxy configuration.</p>
     *         <p>
     *         You must specify the ARNs or the names, and you can specify both.
     */
    public final List<String> ruleGroupArns() {
        return ruleGroupArns;
    }

    /**
     * <p>
     * Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where the rule
     * match is applied.
     * </p>
     * 
     * @return Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where
     *         the rule match is applied.
     */
    public final ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions() {
        return defaultRulePhaseActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key:value pairs to associate with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key:value pairs to associate with the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proxyConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleGroupNames() ? ruleGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleGroupArns() ? ruleGroupArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultRulePhaseActions());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProxyConfigurationRequest)) {
            return false;
        }
        CreateProxyConfigurationRequest other = (CreateProxyConfigurationRequest) obj;
        return Objects.equals(proxyConfigurationName(), other.proxyConfigurationName())
                && Objects.equals(description(), other.description()) && hasRuleGroupNames() == other.hasRuleGroupNames()
                && Objects.equals(ruleGroupNames(), other.ruleGroupNames()) && hasRuleGroupArns() == other.hasRuleGroupArns()
                && Objects.equals(ruleGroupArns(), other.ruleGroupArns())
                && Objects.equals(defaultRulePhaseActions(), other.defaultRulePhaseActions()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProxyConfigurationRequest").add("ProxyConfigurationName", proxyConfigurationName())
                .add("Description", description()).add("RuleGroupNames", hasRuleGroupNames() ? ruleGroupNames() : null)
                .add("RuleGroupArns", hasRuleGroupArns() ? ruleGroupArns() : null)
                .add("DefaultRulePhaseActions", defaultRulePhaseActions()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProxyConfigurationName":
            return Optional.ofNullable(clazz.cast(proxyConfigurationName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RuleGroupNames":
            return Optional.ofNullable(clazz.cast(ruleGroupNames()));
        case "RuleGroupArns":
            return Optional.ofNullable(clazz.cast(ruleGroupArns()));
        case "DefaultRulePhaseActions":
            return Optional.ofNullable(clazz.cast(defaultRulePhaseActions()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProxyConfigurationName", PROXY_CONFIGURATION_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RuleGroupNames", RULE_GROUP_NAMES_FIELD);
        map.put("RuleGroupArns", RULE_GROUP_ARNS_FIELD);
        map.put("DefaultRulePhaseActions", DEFAULT_RULE_PHASE_ACTIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProxyConfigurationRequest, T> g) {
        return obj -> g.apply((CreateProxyConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateProxyConfigurationRequest> {
        /**
         * <p>
         * The descriptive name of the proxy configuration. You can't change the name of a proxy configuration after you
         * create it.
         * </p>
         * 
         * @param proxyConfigurationName
         *        The descriptive name of the proxy configuration. You can't change the name of a proxy configuration
         *        after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyConfigurationName(String proxyConfigurationName);

        /**
         * <p>
         * A description of the proxy configuration.
         * </p>
         * 
         * @param description
         *        A description of the proxy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The proxy rule group name(s) to attach to the proxy configuration.
         * </p>
         * <p>
         * You must specify the ARNs or the names, and you can specify both.
         * </p>
         * 
         * @param ruleGroupNames
         *        The proxy rule group name(s) to attach to the proxy configuration.</p>
         *        <p>
         *        You must specify the ARNs or the names, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupNames(Collection<String> ruleGroupNames);

        /**
         * <p>
         * The proxy rule group name(s) to attach to the proxy configuration.
         * </p>
         * <p>
         * You must specify the ARNs or the names, and you can specify both.
         * </p>
         * 
         * @param ruleGroupNames
         *        The proxy rule group name(s) to attach to the proxy configuration.</p>
         *        <p>
         *        You must specify the ARNs or the names, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupNames(String... ruleGroupNames);

        /**
         * <p>
         * The proxy rule group arn(s) to attach to the proxy configuration.
         * </p>
         * <p>
         * You must specify the ARNs or the names, and you can specify both.
         * </p>
         * 
         * @param ruleGroupArns
         *        The proxy rule group arn(s) to attach to the proxy configuration.</p>
         *        <p>
         *        You must specify the ARNs or the names, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupArns(Collection<String> ruleGroupArns);

        /**
         * <p>
         * The proxy rule group arn(s) to attach to the proxy configuration.
         * </p>
         * <p>
         * You must specify the ARNs or the names, and you can specify both.
         * </p>
         * 
         * @param ruleGroupArns
         *        The proxy rule group arn(s) to attach to the proxy configuration.</p>
         *        <p>
         *        You must specify the ARNs or the names, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupArns(String... ruleGroupArns);

        /**
         * <p>
         * Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where the
         * rule match is applied.
         * </p>
         * 
         * @param defaultRulePhaseActions
         *        Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic
         *        where the rule match is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions);

        /**
         * <p>
         * Evaluation points in the traffic flow where rules are applied. There are three phases in a traffic where the
         * rule match is applied.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProxyConfigDefaultRulePhaseActionsRequest.Builder} avoiding the need to create one manually via
         * {@link ProxyConfigDefaultRulePhaseActionsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProxyConfigDefaultRulePhaseActionsRequest.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest)}.
         * 
         * @param defaultRulePhaseActions
         *        a consumer that will call methods on {@link ProxyConfigDefaultRulePhaseActionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest)
         */
        default Builder defaultRulePhaseActions(
                Consumer<ProxyConfigDefaultRulePhaseActionsRequest.Builder> defaultRulePhaseActions) {
            return defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest.builder()
                    .applyMutation(defaultRulePhaseActions).build());
        }

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkfirewall.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String proxyConfigurationName;

        private String description;

        private List<String> ruleGroupNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> ruleGroupArns = DefaultSdkAutoConstructList.getInstance();

        private ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProxyConfigurationRequest model) {
            super(model);
            proxyConfigurationName(model.proxyConfigurationName);
            description(model.description);
            ruleGroupNames(model.ruleGroupNames);
            ruleGroupArns(model.ruleGroupArns);
            defaultRulePhaseActions(model.defaultRulePhaseActions);
            tags(model.tags);
        }

        public final String getProxyConfigurationName() {
            return proxyConfigurationName;
        }

        public final void setProxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
        }

        @Override
        public final Builder proxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getRuleGroupNames() {
            if (ruleGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return ruleGroupNames;
        }

        public final void setRuleGroupNames(Collection<String> ruleGroupNames) {
            this.ruleGroupNames = ResourceNameListCopier.copy(ruleGroupNames);
        }

        @Override
        public final Builder ruleGroupNames(Collection<String> ruleGroupNames) {
            this.ruleGroupNames = ResourceNameListCopier.copy(ruleGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroupNames(String... ruleGroupNames) {
            ruleGroupNames(Arrays.asList(ruleGroupNames));
            return this;
        }

        public final Collection<String> getRuleGroupArns() {
            if (ruleGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return ruleGroupArns;
        }

        public final void setRuleGroupArns(Collection<String> ruleGroupArns) {
            this.ruleGroupArns = ResourceArnListCopier.copy(ruleGroupArns);
        }

        @Override
        public final Builder ruleGroupArns(Collection<String> ruleGroupArns) {
            this.ruleGroupArns = ResourceArnListCopier.copy(ruleGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroupArns(String... ruleGroupArns) {
            ruleGroupArns(Arrays.asList(ruleGroupArns));
            return this;
        }

        public final ProxyConfigDefaultRulePhaseActionsRequest.Builder getDefaultRulePhaseActions() {
            return defaultRulePhaseActions != null ? defaultRulePhaseActions.toBuilder() : null;
        }

        public final void setDefaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest.BuilderImpl defaultRulePhaseActions) {
            this.defaultRulePhaseActions = defaultRulePhaseActions != null ? defaultRulePhaseActions.build() : null;
        }

        @Override
        public final Builder defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions) {
            this.defaultRulePhaseActions = defaultRulePhaseActions;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProxyConfigurationRequest build() {
            return new CreateProxyConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
