/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the actions to take on the SSL/TLS connection if the certificate presented by the server in the connection
 * has a revoked or unknown status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckCertificateRevocationStatusActions implements SdkPojo, Serializable,
        ToCopyableBuilder<CheckCertificateRevocationStatusActions.Builder, CheckCertificateRevocationStatusActions> {
    private static final SdkField<String> REVOKED_STATUS_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevokedStatusAction")
            .getter(getter(CheckCertificateRevocationStatusActions::revokedStatusActionAsString))
            .setter(setter(Builder::revokedStatusAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevokedStatusAction").build())
            .build();

    private static final SdkField<String> UNKNOWN_STATUS_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnknownStatusAction")
            .getter(getter(CheckCertificateRevocationStatusActions::unknownStatusActionAsString))
            .setter(setter(Builder::unknownStatusAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnknownStatusAction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVOKED_STATUS_ACTION_FIELD,
            UNKNOWN_STATUS_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String revokedStatusAction;

    private final String unknownStatusAction;

    private CheckCertificateRevocationStatusActions(BuilderImpl builder) {
        this.revokedStatusAction = builder.revokedStatusAction;
        this.unknownStatusAction = builder.unknownStatusAction;
    }

    /**
     * <p>
     * Configures how Network Firewall processes traffic when it determines that the certificate presented by the server
     * in the SSL/TLS connection has a revoked status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for
     * inspection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the connection
     * and drops subsequent packets for that connection. <code>REJECT</code> is available only for TCP traffic.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #revokedStatusAction} will return {@link RevocationCheckAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #revokedStatusActionAsString}.
     * </p>
     * 
     * @return Configures how Network Firewall processes traffic when it determines that the certificate presented by
     *         the server in the SSL/TLS connection has a revoked status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for
     *         inspection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the
     *         connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for
     *         TCP traffic.
     *         </p>
     *         </li>
     * @see RevocationCheckAction
     */
    public final RevocationCheckAction revokedStatusAction() {
        return RevocationCheckAction.fromValue(revokedStatusAction);
    }

    /**
     * <p>
     * Configures how Network Firewall processes traffic when it determines that the certificate presented by the server
     * in the SSL/TLS connection has a revoked status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for
     * inspection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the connection
     * and drops subsequent packets for that connection. <code>REJECT</code> is available only for TCP traffic.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #revokedStatusAction} will return {@link RevocationCheckAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #revokedStatusActionAsString}.
     * </p>
     * 
     * @return Configures how Network Firewall processes traffic when it determines that the certificate presented by
     *         the server in the SSL/TLS connection has a revoked status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for
     *         inspection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the
     *         connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for
     *         TCP traffic.
     *         </p>
     *         </li>
     * @see RevocationCheckAction
     */
    public final String revokedStatusActionAsString() {
        return revokedStatusAction;
    }

    /**
     * <p>
     * Configures how Network Firewall processes traffic when it determines that the certificate presented by the server
     * in the SSL/TLS connection has an unknown status, or a status that cannot be determined for any other reason,
     * including when the service is unable to connect to the OCSP and CRL endpoints for the certificate.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for
     * inspection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the connection
     * and drops subsequent packets for that connection. <code>REJECT</code> is available only for TCP traffic.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #unknownStatusAction} will return {@link RevocationCheckAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #unknownStatusActionAsString}.
     * </p>
     * 
     * @return Configures how Network Firewall processes traffic when it determines that the certificate presented by
     *         the server in the SSL/TLS connection has an unknown status, or a status that cannot be determined for any
     *         other reason, including when the service is unable to connect to the OCSP and CRL endpoints for the
     *         certificate.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for
     *         inspection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the
     *         connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for
     *         TCP traffic.
     *         </p>
     *         </li>
     * @see RevocationCheckAction
     */
    public final RevocationCheckAction unknownStatusAction() {
        return RevocationCheckAction.fromValue(unknownStatusAction);
    }

    /**
     * <p>
     * Configures how Network Firewall processes traffic when it determines that the certificate presented by the server
     * in the SSL/TLS connection has an unknown status, or a status that cannot be determined for any other reason,
     * including when the service is unable to connect to the OCSP and CRL endpoints for the certificate.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for
     * inspection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the connection
     * and drops subsequent packets for that connection. <code>REJECT</code> is available only for TCP traffic.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #unknownStatusAction} will return {@link RevocationCheckAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #unknownStatusActionAsString}.
     * </p>
     * 
     * @return Configures how Network Firewall processes traffic when it determines that the certificate presented by
     *         the server in the SSL/TLS connection has an unknown status, or a status that cannot be determined for any
     *         other reason, including when the service is unable to connect to the OCSP and CRL endpoints for the
     *         certificate.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for
     *         inspection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the
     *         connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for
     *         TCP traffic.
     *         </p>
     *         </li>
     * @see RevocationCheckAction
     */
    public final String unknownStatusActionAsString() {
        return unknownStatusAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(revokedStatusActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(unknownStatusActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckCertificateRevocationStatusActions)) {
            return false;
        }
        CheckCertificateRevocationStatusActions other = (CheckCertificateRevocationStatusActions) obj;
        return Objects.equals(revokedStatusActionAsString(), other.revokedStatusActionAsString())
                && Objects.equals(unknownStatusActionAsString(), other.unknownStatusActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckCertificateRevocationStatusActions")
                .add("RevokedStatusAction", revokedStatusActionAsString())
                .add("UnknownStatusAction", unknownStatusActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RevokedStatusAction":
            return Optional.ofNullable(clazz.cast(revokedStatusActionAsString()));
        case "UnknownStatusAction":
            return Optional.ofNullable(clazz.cast(unknownStatusActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RevokedStatusAction", REVOKED_STATUS_ACTION_FIELD);
        map.put("UnknownStatusAction", UNKNOWN_STATUS_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckCertificateRevocationStatusActions, T> g) {
        return obj -> g.apply((CheckCertificateRevocationStatusActions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CheckCertificateRevocationStatusActions> {
        /**
         * <p>
         * Configures how Network Firewall processes traffic when it determines that the certificate presented by the
         * server in the SSL/TLS connection has a revoked status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for
         * inspection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the
         * connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for TCP
         * traffic.
         * </p>
         * </li>
         * </ul>
         * 
         * @param revokedStatusAction
         *        Configures how Network Firewall processes traffic when it determines that the certificate presented by
         *        the server in the SSL/TLS connection has a revoked status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for
         *        inspection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the
         *        connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for
         *        TCP traffic.
         *        </p>
         *        </li>
         * @see RevocationCheckAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevocationCheckAction
         */
        Builder revokedStatusAction(String revokedStatusAction);

        /**
         * <p>
         * Configures how Network Firewall processes traffic when it determines that the certificate presented by the
         * server in the SSL/TLS connection has a revoked status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for
         * inspection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the
         * connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for TCP
         * traffic.
         * </p>
         * </li>
         * </ul>
         * 
         * @param revokedStatusAction
         *        Configures how Network Firewall processes traffic when it determines that the certificate presented by
         *        the server in the SSL/TLS connection has a revoked status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for
         *        inspection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the
         *        connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for
         *        TCP traffic.
         *        </p>
         *        </li>
         * @see RevocationCheckAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevocationCheckAction
         */
        Builder revokedStatusAction(RevocationCheckAction revokedStatusAction);

        /**
         * <p>
         * Configures how Network Firewall processes traffic when it determines that the certificate presented by the
         * server in the SSL/TLS connection has an unknown status, or a status that cannot be determined for any other
         * reason, including when the service is unable to connect to the OCSP and CRL endpoints for the certificate.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for
         * inspection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the
         * connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for TCP
         * traffic.
         * </p>
         * </li>
         * </ul>
         * 
         * @param unknownStatusAction
         *        Configures how Network Firewall processes traffic when it determines that the certificate presented by
         *        the server in the SSL/TLS connection has an unknown status, or a status that cannot be determined for
         *        any other reason, including when the service is unable to connect to the OCSP and CRL endpoints for
         *        the certificate.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for
         *        inspection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the
         *        connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for
         *        TCP traffic.
         *        </p>
         *        </li>
         * @see RevocationCheckAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevocationCheckAction
         */
        Builder unknownStatusAction(String unknownStatusAction);

        /**
         * <p>
         * Configures how Network Firewall processes traffic when it determines that the certificate presented by the
         * server in the SSL/TLS connection has an unknown status, or a status that cannot be determined for any other
         * reason, including when the service is unable to connect to the OCSP and CRL endpoints for the certificate.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for
         * inspection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the
         * connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for TCP
         * traffic.
         * </p>
         * </li>
         * </ul>
         * 
         * @param unknownStatusAction
         *        Configures how Network Firewall processes traffic when it determines that the certificate presented by
         *        the server in the SSL/TLS connection has an unknown status, or a status that cannot be determined for
         *        any other reason, including when the service is unable to connect to the OCSP and CRL endpoints for
         *        the certificate.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>PASS</b> - Allow the connection to continue, and pass subsequent packets to the stateful engine for
         *        inspection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DROP</b> - Network Firewall closes the connection and drops subsequent packets for that connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>REJECT</b> - Network Firewall sends a TCP reject packet back to your client. The service closes the
         *        connection and drops subsequent packets for that connection. <code>REJECT</code> is available only for
         *        TCP traffic.
         *        </p>
         *        </li>
         * @see RevocationCheckAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevocationCheckAction
         */
        Builder unknownStatusAction(RevocationCheckAction unknownStatusAction);
    }

    static final class BuilderImpl implements Builder {
        private String revokedStatusAction;

        private String unknownStatusAction;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckCertificateRevocationStatusActions model) {
            revokedStatusAction(model.revokedStatusAction);
            unknownStatusAction(model.unknownStatusAction);
        }

        public final String getRevokedStatusAction() {
            return revokedStatusAction;
        }

        public final void setRevokedStatusAction(String revokedStatusAction) {
            this.revokedStatusAction = revokedStatusAction;
        }

        @Override
        public final Builder revokedStatusAction(String revokedStatusAction) {
            this.revokedStatusAction = revokedStatusAction;
            return this;
        }

        @Override
        public final Builder revokedStatusAction(RevocationCheckAction revokedStatusAction) {
            this.revokedStatusAction(revokedStatusAction == null ? null : revokedStatusAction.toString());
            return this;
        }

        public final String getUnknownStatusAction() {
            return unknownStatusAction;
        }

        public final void setUnknownStatusAction(String unknownStatusAction) {
            this.unknownStatusAction = unknownStatusAction;
        }

        @Override
        public final Builder unknownStatusAction(String unknownStatusAction) {
            this.unknownStatusAction = unknownStatusAction;
            return this;
        }

        @Override
        public final Builder unknownStatusAction(RevocationCheckAction unknownStatusAction) {
            this.unknownStatusAction(unknownStatusAction == null ? null : unknownStatusAction.toString());
            return this;
        }

        @Override
        public CheckCertificateRevocationStatusActions build() {
            return new CheckCertificateRevocationStatusActions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
