/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarizes the CIDR blocks used by the IP set references in a firewall. Network Firewall calculates the number of
 * CIDRs by taking an aggregated count of all CIDRs used by the IP sets you are referencing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CIDRSummary implements SdkPojo, Serializable, ToCopyableBuilder<CIDRSummary.Builder, CIDRSummary> {
    private static final SdkField<Integer> AVAILABLE_CIDR_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailableCIDRCount").getter(getter(CIDRSummary::availableCIDRCount))
            .setter(setter(Builder::availableCIDRCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableCIDRCount").build())
            .build();

    private static final SdkField<Integer> UTILIZED_CIDR_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UtilizedCIDRCount").getter(getter(CIDRSummary::utilizedCIDRCount))
            .setter(setter(Builder::utilizedCIDRCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtilizedCIDRCount").build()).build();

    private static final SdkField<Map<String, IPSetMetadata>> IP_SET_REFERENCES_FIELD = SdkField
            .<Map<String, IPSetMetadata>> builder(MarshallingType.MAP)
            .memberName("IPSetReferences")
            .getter(getter(CIDRSummary::ipSetReferences))
            .setter(setter(Builder::ipSetReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSetReferences").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<IPSetMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(IPSetMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABLE_CIDR_COUNT_FIELD,
            UTILIZED_CIDR_COUNT_FIELD, IP_SET_REFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer availableCIDRCount;

    private final Integer utilizedCIDRCount;

    private final Map<String, IPSetMetadata> ipSetReferences;

    private CIDRSummary(BuilderImpl builder) {
        this.availableCIDRCount = builder.availableCIDRCount;
        this.utilizedCIDRCount = builder.utilizedCIDRCount;
        this.ipSetReferences = builder.ipSetReferences;
    }

    /**
     * <p>
     * The number of CIDR blocks available for use by the IP set references in a firewall.
     * </p>
     * 
     * @return The number of CIDR blocks available for use by the IP set references in a firewall.
     */
    public final Integer availableCIDRCount() {
        return availableCIDRCount;
    }

    /**
     * <p>
     * The number of CIDR blocks used by the IP set references in a firewall.
     * </p>
     * 
     * @return The number of CIDR blocks used by the IP set references in a firewall.
     */
    public final Integer utilizedCIDRCount() {
        return utilizedCIDRCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the IPSetReferences property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpSetReferences() {
        return ipSetReferences != null && !(ipSetReferences instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of the IP set references used by a firewall.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpSetReferences} method.
     * </p>
     * 
     * @return The list of the IP set references used by a firewall.
     */
    public final Map<String, IPSetMetadata> ipSetReferences() {
        return ipSetReferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availableCIDRCount());
        hashCode = 31 * hashCode + Objects.hashCode(utilizedCIDRCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpSetReferences() ? ipSetReferences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CIDRSummary)) {
            return false;
        }
        CIDRSummary other = (CIDRSummary) obj;
        return Objects.equals(availableCIDRCount(), other.availableCIDRCount())
                && Objects.equals(utilizedCIDRCount(), other.utilizedCIDRCount())
                && hasIpSetReferences() == other.hasIpSetReferences()
                && Objects.equals(ipSetReferences(), other.ipSetReferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CIDRSummary").add("AvailableCIDRCount", availableCIDRCount())
                .add("UtilizedCIDRCount", utilizedCIDRCount())
                .add("IPSetReferences", hasIpSetReferences() ? ipSetReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailableCIDRCount":
            return Optional.ofNullable(clazz.cast(availableCIDRCount()));
        case "UtilizedCIDRCount":
            return Optional.ofNullable(clazz.cast(utilizedCIDRCount()));
        case "IPSetReferences":
            return Optional.ofNullable(clazz.cast(ipSetReferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AvailableCIDRCount", AVAILABLE_CIDR_COUNT_FIELD);
        map.put("UtilizedCIDRCount", UTILIZED_CIDR_COUNT_FIELD);
        map.put("IPSetReferences", IP_SET_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CIDRSummary, T> g) {
        return obj -> g.apply((CIDRSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CIDRSummary> {
        /**
         * <p>
         * The number of CIDR blocks available for use by the IP set references in a firewall.
         * </p>
         * 
         * @param availableCIDRCount
         *        The number of CIDR blocks available for use by the IP set references in a firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableCIDRCount(Integer availableCIDRCount);

        /**
         * <p>
         * The number of CIDR blocks used by the IP set references in a firewall.
         * </p>
         * 
         * @param utilizedCIDRCount
         *        The number of CIDR blocks used by the IP set references in a firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utilizedCIDRCount(Integer utilizedCIDRCount);

        /**
         * <p>
         * The list of the IP set references used by a firewall.
         * </p>
         * 
         * @param ipSetReferences
         *        The list of the IP set references used by a firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSetReferences(Map<String, IPSetMetadata> ipSetReferences);
    }

    static final class BuilderImpl implements Builder {
        private Integer availableCIDRCount;

        private Integer utilizedCIDRCount;

        private Map<String, IPSetMetadata> ipSetReferences = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CIDRSummary model) {
            availableCIDRCount(model.availableCIDRCount);
            utilizedCIDRCount(model.utilizedCIDRCount);
            ipSetReferences(model.ipSetReferences);
        }

        public final Integer getAvailableCIDRCount() {
            return availableCIDRCount;
        }

        public final void setAvailableCIDRCount(Integer availableCIDRCount) {
            this.availableCIDRCount = availableCIDRCount;
        }

        @Override
        public final Builder availableCIDRCount(Integer availableCIDRCount) {
            this.availableCIDRCount = availableCIDRCount;
            return this;
        }

        public final Integer getUtilizedCIDRCount() {
            return utilizedCIDRCount;
        }

        public final void setUtilizedCIDRCount(Integer utilizedCIDRCount) {
            this.utilizedCIDRCount = utilizedCIDRCount;
        }

        @Override
        public final Builder utilizedCIDRCount(Integer utilizedCIDRCount) {
            this.utilizedCIDRCount = utilizedCIDRCount;
            return this;
        }

        public final Map<String, IPSetMetadata.Builder> getIpSetReferences() {
            Map<String, IPSetMetadata.Builder> result = IPSetMetadataMapCopier.copyToBuilder(this.ipSetReferences);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setIpSetReferences(Map<String, IPSetMetadata.BuilderImpl> ipSetReferences) {
            this.ipSetReferences = IPSetMetadataMapCopier.copyFromBuilder(ipSetReferences);
        }

        @Override
        public final Builder ipSetReferences(Map<String, IPSetMetadata> ipSetReferences) {
            this.ipSetReferences = IPSetMetadataMapCopier.copy(ipSetReferences);
            return this;
        }

        @Override
        public CIDRSummary build() {
            return new CIDRSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
