/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRule;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRuleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProxyRulesByRequestPhase
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProxyRulesByRequestPhase> {
    private static final SdkField<List<ProxyRule>> PRE_DNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PreDNS").getter(ProxyRulesByRequestPhase.getter(ProxyRulesByRequestPhase::preDNS)).setter(ProxyRulesByRequestPhase.setter(Builder::preDNS)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreDNS").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProxyRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProxyRule>> PRE_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PreREQUEST").getter(ProxyRulesByRequestPhase.getter(ProxyRulesByRequestPhase::preREQUEST)).setter(ProxyRulesByRequestPhase.setter(Builder::preREQUEST)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreREQUEST").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProxyRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProxyRule>> POST_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PostRESPONSE").getter(ProxyRulesByRequestPhase.getter(ProxyRulesByRequestPhase::postRESPONSE)).setter(ProxyRulesByRequestPhase.setter(Builder::postRESPONSE)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostRESPONSE").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProxyRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRE_DNS_FIELD, PRE_REQUEST_FIELD, POST_RESPONSE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProxyRulesByRequestPhase.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ProxyRule> preDNS;
    private final List<ProxyRule> preREQUEST;
    private final List<ProxyRule> postRESPONSE;

    private ProxyRulesByRequestPhase(BuilderImpl builder) {
        this.preDNS = builder.preDNS;
        this.preREQUEST = builder.preREQUEST;
        this.postRESPONSE = builder.postRESPONSE;
    }

    public final boolean hasPreDNS() {
        return this.preDNS != null && !(this.preDNS instanceof SdkAutoConstructList);
    }

    public final List<ProxyRule> preDNS() {
        return this.preDNS;
    }

    public final boolean hasPreREQUEST() {
        return this.preREQUEST != null && !(this.preREQUEST instanceof SdkAutoConstructList);
    }

    public final List<ProxyRule> preREQUEST() {
        return this.preREQUEST;
    }

    public final boolean hasPostRESPONSE() {
        return this.postRESPONSE != null && !(this.postRESPONSE instanceof SdkAutoConstructList);
    }

    public final List<ProxyRule> postRESPONSE() {
        return this.postRESPONSE;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPreDNS() ? this.preDNS() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPreREQUEST() ? this.preREQUEST() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPostRESPONSE() ? this.postRESPONSE() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxyRulesByRequestPhase)) {
            return false;
        }
        ProxyRulesByRequestPhase other = (ProxyRulesByRequestPhase)obj;
        return this.hasPreDNS() == other.hasPreDNS() && Objects.equals(this.preDNS(), other.preDNS()) && this.hasPreREQUEST() == other.hasPreREQUEST() && Objects.equals(this.preREQUEST(), other.preREQUEST()) && this.hasPostRESPONSE() == other.hasPostRESPONSE() && Objects.equals(this.postRESPONSE(), other.postRESPONSE());
    }

    public final String toString() {
        return ToString.builder((String)"ProxyRulesByRequestPhase").add("PreDNS", this.hasPreDNS() ? this.preDNS() : null).add("PreREQUEST", this.hasPreREQUEST() ? this.preREQUEST() : null).add("PostRESPONSE", this.hasPostRESPONSE() ? this.postRESPONSE() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PreDNS": {
                return Optional.ofNullable(clazz.cast(this.preDNS()));
            }
            case "PreREQUEST": {
                return Optional.ofNullable(clazz.cast(this.preREQUEST()));
            }
            case "PostRESPONSE": {
                return Optional.ofNullable(clazz.cast(this.postRESPONSE()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ProxyRule>>> map = new HashMap<String, SdkField<List<ProxyRule>>>();
        map.put("PreDNS", PRE_DNS_FIELD);
        map.put("PreREQUEST", PRE_REQUEST_FIELD);
        map.put("PostRESPONSE", POST_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProxyRulesByRequestPhase, T> g) {
        return obj -> g.apply((ProxyRulesByRequestPhase)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ProxyRule> preDNS = DefaultSdkAutoConstructList.getInstance();
        private List<ProxyRule> preREQUEST = DefaultSdkAutoConstructList.getInstance();
        private List<ProxyRule> postRESPONSE = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProxyRulesByRequestPhase model) {
            this.preDNS(model.preDNS);
            this.preREQUEST(model.preREQUEST);
            this.postRESPONSE(model.postRESPONSE);
        }

        public final List<ProxyRule.Builder> getPreDNS() {
            List<ProxyRule.Builder> result = ProxyRuleListCopier.copyToBuilder(this.preDNS);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPreDNS(Collection<ProxyRule.BuilderImpl> preDNS) {
            this.preDNS = ProxyRuleListCopier.copyFromBuilder(preDNS);
        }

        @Override
        public final Builder preDNS(Collection<ProxyRule> preDNS) {
            this.preDNS = ProxyRuleListCopier.copy(preDNS);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preDNS(ProxyRule ... preDNS) {
            this.preDNS(Arrays.asList(preDNS));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preDNS(Consumer<ProxyRule.Builder> ... preDNS) {
            this.preDNS(Stream.of(preDNS).map(c -> (ProxyRule)((ProxyRule.Builder)ProxyRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProxyRule.Builder> getPreREQUEST() {
            List<ProxyRule.Builder> result = ProxyRuleListCopier.copyToBuilder(this.preREQUEST);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPreREQUEST(Collection<ProxyRule.BuilderImpl> preREQUEST) {
            this.preREQUEST = ProxyRuleListCopier.copyFromBuilder(preREQUEST);
        }

        @Override
        public final Builder preREQUEST(Collection<ProxyRule> preREQUEST) {
            this.preREQUEST = ProxyRuleListCopier.copy(preREQUEST);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preREQUEST(ProxyRule ... preREQUEST) {
            this.preREQUEST(Arrays.asList(preREQUEST));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preREQUEST(Consumer<ProxyRule.Builder> ... preREQUEST) {
            this.preREQUEST(Stream.of(preREQUEST).map(c -> (ProxyRule)((ProxyRule.Builder)ProxyRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProxyRule.Builder> getPostRESPONSE() {
            List<ProxyRule.Builder> result = ProxyRuleListCopier.copyToBuilder(this.postRESPONSE);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPostRESPONSE(Collection<ProxyRule.BuilderImpl> postRESPONSE) {
            this.postRESPONSE = ProxyRuleListCopier.copyFromBuilder(postRESPONSE);
        }

        @Override
        public final Builder postRESPONSE(Collection<ProxyRule> postRESPONSE) {
            this.postRESPONSE = ProxyRuleListCopier.copy(postRESPONSE);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postRESPONSE(ProxyRule ... postRESPONSE) {
            this.postRESPONSE(Arrays.asList(postRESPONSE));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postRESPONSE(Consumer<ProxyRule.Builder> ... postRESPONSE) {
            this.postRESPONSE(Stream.of(postRESPONSE).map(c -> (ProxyRule)((ProxyRule.Builder)ProxyRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ProxyRulesByRequestPhase build() {
            return new ProxyRulesByRequestPhase(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProxyRulesByRequestPhase> {
        public Builder preDNS(Collection<ProxyRule> var1);

        public Builder preDNS(ProxyRule ... var1);

        public Builder preDNS(Consumer<ProxyRule.Builder> ... var1);

        public Builder preREQUEST(Collection<ProxyRule> var1);

        public Builder preREQUEST(ProxyRule ... var1);

        public Builder preREQUEST(Consumer<ProxyRule.Builder> ... var1);

        public Builder postRESPONSE(Collection<ProxyRule> var1);

        public Builder postRESPONSE(ProxyRule ... var1);

        public Builder postRESPONSE(Consumer<ProxyRule.Builder> ... var1);
    }
}

