/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.CertificatesCopier;
import software.amazon.awssdk.services.networkfirewall.model.EncryptionConfiguration;
import software.amazon.awssdk.services.networkfirewall.model.ResourceStatus;
import software.amazon.awssdk.services.networkfirewall.model.Tag;
import software.amazon.awssdk.services.networkfirewall.model.TagListCopier;
import software.amazon.awssdk.services.networkfirewall.model.TlsCertificateData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TLSInspectionConfigurationResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TLSInspectionConfigurationResponse> {
    private static final SdkField<String> TLS_INSPECTION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TLSInspectionConfigurationArn").getter(TLSInspectionConfigurationResponse.getter(TLSInspectionConfigurationResponse::tlsInspectionConfigurationArn)).setter(TLSInspectionConfigurationResponse.setter(Builder::tlsInspectionConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationArn").build()}).build();
    private static final SdkField<String> TLS_INSPECTION_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TLSInspectionConfigurationName").getter(TLSInspectionConfigurationResponse.getter(TLSInspectionConfigurationResponse::tlsInspectionConfigurationName)).setter(TLSInspectionConfigurationResponse.setter(Builder::tlsInspectionConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationName").build()}).build();
    private static final SdkField<String> TLS_INSPECTION_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TLSInspectionConfigurationId").getter(TLSInspectionConfigurationResponse.getter(TLSInspectionConfigurationResponse::tlsInspectionConfigurationId)).setter(TLSInspectionConfigurationResponse.setter(Builder::tlsInspectionConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationId").build()}).build();
    private static final SdkField<String> TLS_INSPECTION_CONFIGURATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TLSInspectionConfigurationStatus").getter(TLSInspectionConfigurationResponse.getter(TLSInspectionConfigurationResponse::tlsInspectionConfigurationStatusAsString)).setter(TLSInspectionConfigurationResponse.setter(Builder::tlsInspectionConfigurationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationStatus").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(TLSInspectionConfigurationResponse.getter(TLSInspectionConfigurationResponse::description)).setter(TLSInspectionConfigurationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(TLSInspectionConfigurationResponse.getter(TLSInspectionConfigurationResponse::tags)).setter(TLSInspectionConfigurationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(TLSInspectionConfigurationResponse.getter(TLSInspectionConfigurationResponse::lastModifiedTime)).setter(TLSInspectionConfigurationResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfAssociations").getter(TLSInspectionConfigurationResponse.getter(TLSInspectionConfigurationResponse::numberOfAssociations)).setter(TLSInspectionConfigurationResponse.setter(Builder::numberOfAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAssociations").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(TLSInspectionConfigurationResponse.getter(TLSInspectionConfigurationResponse::encryptionConfiguration)).setter(TLSInspectionConfigurationResponse.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final SdkField<List<TlsCertificateData>> CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Certificates").getter(TLSInspectionConfigurationResponse.getter(TLSInspectionConfigurationResponse::certificates)).setter(TLSInspectionConfigurationResponse.setter(Builder::certificates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TlsCertificateData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TlsCertificateData> CERTIFICATE_AUTHORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CertificateAuthority").getter(TLSInspectionConfigurationResponse.getter(TLSInspectionConfigurationResponse::certificateAuthority)).setter(TLSInspectionConfigurationResponse.setter(Builder::certificateAuthority)).constructor(TlsCertificateData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthority").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TLS_INSPECTION_CONFIGURATION_ARN_FIELD, TLS_INSPECTION_CONFIGURATION_NAME_FIELD, TLS_INSPECTION_CONFIGURATION_ID_FIELD, TLS_INSPECTION_CONFIGURATION_STATUS_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, LAST_MODIFIED_TIME_FIELD, NUMBER_OF_ASSOCIATIONS_FIELD, ENCRYPTION_CONFIGURATION_FIELD, CERTIFICATES_FIELD, CERTIFICATE_AUTHORITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TLSInspectionConfigurationResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tlsInspectionConfigurationArn;
    private final String tlsInspectionConfigurationName;
    private final String tlsInspectionConfigurationId;
    private final String tlsInspectionConfigurationStatus;
    private final String description;
    private final List<Tag> tags;
    private final Instant lastModifiedTime;
    private final Integer numberOfAssociations;
    private final EncryptionConfiguration encryptionConfiguration;
    private final List<TlsCertificateData> certificates;
    private final TlsCertificateData certificateAuthority;

    private TLSInspectionConfigurationResponse(BuilderImpl builder) {
        this.tlsInspectionConfigurationArn = builder.tlsInspectionConfigurationArn;
        this.tlsInspectionConfigurationName = builder.tlsInspectionConfigurationName;
        this.tlsInspectionConfigurationId = builder.tlsInspectionConfigurationId;
        this.tlsInspectionConfigurationStatus = builder.tlsInspectionConfigurationStatus;
        this.description = builder.description;
        this.tags = builder.tags;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.numberOfAssociations = builder.numberOfAssociations;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.certificates = builder.certificates;
        this.certificateAuthority = builder.certificateAuthority;
    }

    public final String tlsInspectionConfigurationArn() {
        return this.tlsInspectionConfigurationArn;
    }

    public final String tlsInspectionConfigurationName() {
        return this.tlsInspectionConfigurationName;
    }

    public final String tlsInspectionConfigurationId() {
        return this.tlsInspectionConfigurationId;
    }

    public final ResourceStatus tlsInspectionConfigurationStatus() {
        return ResourceStatus.fromValue(this.tlsInspectionConfigurationStatus);
    }

    public final String tlsInspectionConfigurationStatusAsString() {
        return this.tlsInspectionConfigurationStatus;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Integer numberOfAssociations() {
        return this.numberOfAssociations;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final boolean hasCertificates() {
        return this.certificates != null && !(this.certificates instanceof SdkAutoConstructList);
    }

    public final List<TlsCertificateData> certificates() {
        return this.certificates;
    }

    public final TlsCertificateData certificateAuthority() {
        return this.certificateAuthority;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsInspectionConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsInspectionConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsInspectionConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsInspectionConfigurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificates() ? this.certificates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthority());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TLSInspectionConfigurationResponse)) {
            return false;
        }
        TLSInspectionConfigurationResponse other = (TLSInspectionConfigurationResponse)obj;
        return Objects.equals(this.tlsInspectionConfigurationArn(), other.tlsInspectionConfigurationArn()) && Objects.equals(this.tlsInspectionConfigurationName(), other.tlsInspectionConfigurationName()) && Objects.equals(this.tlsInspectionConfigurationId(), other.tlsInspectionConfigurationId()) && Objects.equals(this.tlsInspectionConfigurationStatusAsString(), other.tlsInspectionConfigurationStatusAsString()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.numberOfAssociations(), other.numberOfAssociations()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && this.hasCertificates() == other.hasCertificates() && Objects.equals(this.certificates(), other.certificates()) && Objects.equals(this.certificateAuthority(), other.certificateAuthority());
    }

    public final String toString() {
        return ToString.builder((String)"TLSInspectionConfigurationResponse").add("TLSInspectionConfigurationArn", (Object)this.tlsInspectionConfigurationArn()).add("TLSInspectionConfigurationName", (Object)this.tlsInspectionConfigurationName()).add("TLSInspectionConfigurationId", (Object)this.tlsInspectionConfigurationId()).add("TLSInspectionConfigurationStatus", (Object)this.tlsInspectionConfigurationStatusAsString()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("NumberOfAssociations", (Object)this.numberOfAssociations()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("Certificates", this.hasCertificates() ? this.certificates() : null).add("CertificateAuthority", (Object)this.certificateAuthority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TLSInspectionConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.tlsInspectionConfigurationArn()));
            }
            case "TLSInspectionConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.tlsInspectionConfigurationName()));
            }
            case "TLSInspectionConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.tlsInspectionConfigurationId()));
            }
            case "TLSInspectionConfigurationStatus": {
                return Optional.ofNullable(clazz.cast(this.tlsInspectionConfigurationStatusAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "NumberOfAssociations": {
                return Optional.ofNullable(clazz.cast(this.numberOfAssociations()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "Certificates": {
                return Optional.ofNullable(clazz.cast(this.certificates()));
            }
            case "CertificateAuthority": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthority()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TLSInspectionConfigurationArn", TLS_INSPECTION_CONFIGURATION_ARN_FIELD);
        map.put("TLSInspectionConfigurationName", TLS_INSPECTION_CONFIGURATION_NAME_FIELD);
        map.put("TLSInspectionConfigurationId", TLS_INSPECTION_CONFIGURATION_ID_FIELD);
        map.put("TLSInspectionConfigurationStatus", TLS_INSPECTION_CONFIGURATION_STATUS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("NumberOfAssociations", NUMBER_OF_ASSOCIATIONS_FIELD);
        map.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("Certificates", CERTIFICATES_FIELD);
        map.put("CertificateAuthority", CERTIFICATE_AUTHORITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TLSInspectionConfigurationResponse, T> g) {
        return obj -> g.apply((TLSInspectionConfigurationResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tlsInspectionConfigurationArn;
        private String tlsInspectionConfigurationName;
        private String tlsInspectionConfigurationId;
        private String tlsInspectionConfigurationStatus;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant lastModifiedTime;
        private Integer numberOfAssociations;
        private EncryptionConfiguration encryptionConfiguration;
        private List<TlsCertificateData> certificates = DefaultSdkAutoConstructList.getInstance();
        private TlsCertificateData certificateAuthority;

        private BuilderImpl() {
        }

        private BuilderImpl(TLSInspectionConfigurationResponse model) {
            this.tlsInspectionConfigurationArn(model.tlsInspectionConfigurationArn);
            this.tlsInspectionConfigurationName(model.tlsInspectionConfigurationName);
            this.tlsInspectionConfigurationId(model.tlsInspectionConfigurationId);
            this.tlsInspectionConfigurationStatus(model.tlsInspectionConfigurationStatus);
            this.description(model.description);
            this.tags(model.tags);
            this.lastModifiedTime(model.lastModifiedTime);
            this.numberOfAssociations(model.numberOfAssociations);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.certificates(model.certificates);
            this.certificateAuthority(model.certificateAuthority);
        }

        public final String getTlsInspectionConfigurationArn() {
            return this.tlsInspectionConfigurationArn;
        }

        public final void setTlsInspectionConfigurationArn(String tlsInspectionConfigurationArn) {
            this.tlsInspectionConfigurationArn = tlsInspectionConfigurationArn;
        }

        @Override
        public final Builder tlsInspectionConfigurationArn(String tlsInspectionConfigurationArn) {
            this.tlsInspectionConfigurationArn = tlsInspectionConfigurationArn;
            return this;
        }

        public final String getTlsInspectionConfigurationName() {
            return this.tlsInspectionConfigurationName;
        }

        public final void setTlsInspectionConfigurationName(String tlsInspectionConfigurationName) {
            this.tlsInspectionConfigurationName = tlsInspectionConfigurationName;
        }

        @Override
        public final Builder tlsInspectionConfigurationName(String tlsInspectionConfigurationName) {
            this.tlsInspectionConfigurationName = tlsInspectionConfigurationName;
            return this;
        }

        public final String getTlsInspectionConfigurationId() {
            return this.tlsInspectionConfigurationId;
        }

        public final void setTlsInspectionConfigurationId(String tlsInspectionConfigurationId) {
            this.tlsInspectionConfigurationId = tlsInspectionConfigurationId;
        }

        @Override
        public final Builder tlsInspectionConfigurationId(String tlsInspectionConfigurationId) {
            this.tlsInspectionConfigurationId = tlsInspectionConfigurationId;
            return this;
        }

        public final String getTlsInspectionConfigurationStatus() {
            return this.tlsInspectionConfigurationStatus;
        }

        public final void setTlsInspectionConfigurationStatus(String tlsInspectionConfigurationStatus) {
            this.tlsInspectionConfigurationStatus = tlsInspectionConfigurationStatus;
        }

        @Override
        public final Builder tlsInspectionConfigurationStatus(String tlsInspectionConfigurationStatus) {
            this.tlsInspectionConfigurationStatus = tlsInspectionConfigurationStatus;
            return this;
        }

        @Override
        public final Builder tlsInspectionConfigurationStatus(ResourceStatus tlsInspectionConfigurationStatus) {
            this.tlsInspectionConfigurationStatus(tlsInspectionConfigurationStatus == null ? null : tlsInspectionConfigurationStatus.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Integer getNumberOfAssociations() {
            return this.numberOfAssociations;
        }

        public final void setNumberOfAssociations(Integer numberOfAssociations) {
            this.numberOfAssociations = numberOfAssociations;
        }

        @Override
        public final Builder numberOfAssociations(Integer numberOfAssociations) {
            this.numberOfAssociations = numberOfAssociations;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final List<TlsCertificateData.Builder> getCertificates() {
            List<TlsCertificateData.Builder> result = CertificatesCopier.copyToBuilder(this.certificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificates(Collection<TlsCertificateData.BuilderImpl> certificates) {
            this.certificates = CertificatesCopier.copyFromBuilder(certificates);
        }

        @Override
        public final Builder certificates(Collection<TlsCertificateData> certificates) {
            this.certificates = CertificatesCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(TlsCertificateData ... certificates) {
            this.certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Consumer<TlsCertificateData.Builder> ... certificates) {
            this.certificates(Stream.of(certificates).map(c -> (TlsCertificateData)((TlsCertificateData.Builder)TlsCertificateData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TlsCertificateData.Builder getCertificateAuthority() {
            return this.certificateAuthority != null ? this.certificateAuthority.toBuilder() : null;
        }

        public final void setCertificateAuthority(TlsCertificateData.BuilderImpl certificateAuthority) {
            this.certificateAuthority = certificateAuthority != null ? certificateAuthority.build() : null;
        }

        @Override
        public final Builder certificateAuthority(TlsCertificateData certificateAuthority) {
            this.certificateAuthority = certificateAuthority;
            return this;
        }

        public TLSInspectionConfigurationResponse build() {
            return new TLSInspectionConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TLSInspectionConfigurationResponse> {
        public Builder tlsInspectionConfigurationArn(String var1);

        public Builder tlsInspectionConfigurationName(String var1);

        public Builder tlsInspectionConfigurationId(String var1);

        public Builder tlsInspectionConfigurationStatus(String var1);

        public Builder tlsInspectionConfigurationStatus(ResourceStatus var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder numberOfAssociations(Integer var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder certificates(Collection<TlsCertificateData> var1);

        public Builder certificates(TlsCertificateData ... var1);

        public Builder certificates(Consumer<TlsCertificateData.Builder> ... var1);

        public Builder certificateAuthority(TlsCertificateData var1);

        default public Builder certificateAuthority(Consumer<TlsCertificateData.Builder> certificateAuthority) {
            return this.certificateAuthority((TlsCertificateData)((TlsCertificateData.Builder)TlsCertificateData.builder().applyMutation(certificateAuthority)).build());
        }
    }
}

