/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.FlowOperationType;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFlowOperationsRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, ListFlowOperationsRequest> {
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallArn").getter(ListFlowOperationsRequest.getter(ListFlowOperationsRequest::firewallArn)).setter(ListFlowOperationsRequest.setter(Builder::firewallArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(ListFlowOperationsRequest.getter(ListFlowOperationsRequest::availabilityZone)).setter(ListFlowOperationsRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointAssociationArn").getter(ListFlowOperationsRequest.getter(ListFlowOperationsRequest::vpcEndpointAssociationArn)).setter(ListFlowOperationsRequest.setter(Builder::vpcEndpointAssociationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointAssociationArn").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointId").getter(ListFlowOperationsRequest.getter(ListFlowOperationsRequest::vpcEndpointId)).setter(ListFlowOperationsRequest.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()}).build();
    private static final SdkField<String> FLOW_OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowOperationType").getter(ListFlowOperationsRequest.getter(ListFlowOperationsRequest::flowOperationTypeAsString)).setter(ListFlowOperationsRequest.setter(Builder::flowOperationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationType").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFlowOperationsRequest.getter(ListFlowOperationsRequest::nextToken)).setter(ListFlowOperationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListFlowOperationsRequest.getter(ListFlowOperationsRequest::maxResults)).setter(ListFlowOperationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_ARN_FIELD, AVAILABILITY_ZONE_FIELD, VPC_ENDPOINT_ASSOCIATION_ARN_FIELD, VPC_ENDPOINT_ID_FIELD, FLOW_OPERATION_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFlowOperationsRequest.memberNameToFieldInitializer();
    private final String firewallArn;
    private final String availabilityZone;
    private final String vpcEndpointAssociationArn;
    private final String vpcEndpointId;
    private final String flowOperationType;
    private final String nextToken;
    private final Integer maxResults;

    private ListFlowOperationsRequest(BuilderImpl builder) {
        super(builder);
        this.firewallArn = builder.firewallArn;
        this.availabilityZone = builder.availabilityZone;
        this.vpcEndpointAssociationArn = builder.vpcEndpointAssociationArn;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.flowOperationType = builder.flowOperationType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String firewallArn() {
        return this.firewallArn;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String vpcEndpointAssociationArn() {
        return this.vpcEndpointAssociationArn;
    }

    public final String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public final FlowOperationType flowOperationType() {
        return FlowOperationType.fromValue(this.flowOperationType);
    }

    public final String flowOperationTypeAsString() {
        return this.flowOperationType;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowOperationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFlowOperationsRequest)) {
            return false;
        }
        ListFlowOperationsRequest other = (ListFlowOperationsRequest)((Object)obj);
        return Objects.equals(this.firewallArn(), other.firewallArn()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.vpcEndpointAssociationArn(), other.vpcEndpointAssociationArn()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.flowOperationTypeAsString(), other.flowOperationTypeAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListFlowOperationsRequest").add("FirewallArn", (Object)this.firewallArn()).add("AvailabilityZone", (Object)this.availabilityZone()).add("VpcEndpointAssociationArn", (Object)this.vpcEndpointAssociationArn()).add("VpcEndpointId", (Object)this.vpcEndpointId()).add("FlowOperationType", (Object)this.flowOperationTypeAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallArn": {
                return Optional.ofNullable(clazz.cast(this.firewallArn()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "VpcEndpointAssociationArn": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointAssociationArn()));
            }
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "FlowOperationType": {
                return Optional.ofNullable(clazz.cast(this.flowOperationTypeAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("VpcEndpointAssociationArn", VPC_ENDPOINT_ASSOCIATION_ARN_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("FlowOperationType", FLOW_OPERATION_TYPE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFlowOperationsRequest, T> g) {
        return obj -> g.apply((ListFlowOperationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String firewallArn;
        private String availabilityZone;
        private String vpcEndpointAssociationArn;
        private String vpcEndpointId;
        private String flowOperationType;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFlowOperationsRequest model) {
            super(model);
            this.firewallArn(model.firewallArn);
            this.availabilityZone(model.availabilityZone);
            this.vpcEndpointAssociationArn(model.vpcEndpointAssociationArn);
            this.vpcEndpointId(model.vpcEndpointId);
            this.flowOperationType(model.flowOperationType);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getFirewallArn() {
            return this.firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getVpcEndpointAssociationArn() {
            return this.vpcEndpointAssociationArn;
        }

        public final void setVpcEndpointAssociationArn(String vpcEndpointAssociationArn) {
            this.vpcEndpointAssociationArn = vpcEndpointAssociationArn;
        }

        @Override
        public final Builder vpcEndpointAssociationArn(String vpcEndpointAssociationArn) {
            this.vpcEndpointAssociationArn = vpcEndpointAssociationArn;
            return this;
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getFlowOperationType() {
            return this.flowOperationType;
        }

        public final void setFlowOperationType(String flowOperationType) {
            this.flowOperationType = flowOperationType;
        }

        @Override
        public final Builder flowOperationType(String flowOperationType) {
            this.flowOperationType = flowOperationType;
            return this;
        }

        @Override
        public final Builder flowOperationType(FlowOperationType flowOperationType) {
            this.flowOperationType(flowOperationType == null ? null : flowOperationType.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFlowOperationsRequest build() {
            return new ListFlowOperationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFlowOperationsRequest> {
        public Builder firewallArn(String var1);

        public Builder availabilityZone(String var1);

        public Builder vpcEndpointAssociationArn(String var1);

        public Builder vpcEndpointId(String var1);

        public Builder flowOperationType(String var1);

        public Builder flowOperationType(FlowOperationType var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

