/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.MatchAttributes;
import software.amazon.awssdk.services.networkfirewall.model.StatelessActionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleDefinition> {
    private static final SdkField<MatchAttributes> MATCH_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MatchAttributes").getter(RuleDefinition.getter(RuleDefinition::matchAttributes)).setter(RuleDefinition.setter(Builder::matchAttributes)).constructor(MatchAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchAttributes").build()}).build();
    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(RuleDefinition.getter(RuleDefinition::actions)).setter(RuleDefinition.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_ATTRIBUTES_FIELD, ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MatchAttributes", MATCH_ATTRIBUTES_FIELD);
            this.put("Actions", ACTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final MatchAttributes matchAttributes;
    private final List<String> actions;

    private RuleDefinition(BuilderImpl builder) {
        this.matchAttributes = builder.matchAttributes;
        this.actions = builder.actions;
    }

    public final MatchAttributes matchAttributes() {
        return this.matchAttributes;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<String> actions() {
        return this.actions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.matchAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleDefinition)) {
            return false;
        }
        RuleDefinition other = (RuleDefinition)obj;
        return Objects.equals(this.matchAttributes(), other.matchAttributes()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions());
    }

    public final String toString() {
        return ToString.builder((String)"RuleDefinition").add("MatchAttributes", (Object)this.matchAttributes()).add("Actions", this.hasActions() ? this.actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MatchAttributes": {
                return Optional.ofNullable(clazz.cast(this.matchAttributes()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RuleDefinition, T> g) {
        return obj -> g.apply((RuleDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MatchAttributes matchAttributes;
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleDefinition model) {
            this.matchAttributes(model.matchAttributes);
            this.actions(model.actions);
        }

        public final MatchAttributes.Builder getMatchAttributes() {
            return this.matchAttributes != null ? this.matchAttributes.toBuilder() : null;
        }

        public final void setMatchAttributes(MatchAttributes.BuilderImpl matchAttributes) {
            this.matchAttributes = matchAttributes != null ? matchAttributes.build() : null;
        }

        @Override
        public final Builder matchAttributes(MatchAttributes matchAttributes) {
            this.matchAttributes = matchAttributes;
            return this;
        }

        public final Collection<String> getActions() {
            if (this.actions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = StatelessActionsCopier.copy(actions);
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = StatelessActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public RuleDefinition build() {
            return new RuleDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleDefinition> {
        public Builder matchAttributes(MatchAttributes var1);

        default public Builder matchAttributes(Consumer<MatchAttributes.Builder> matchAttributes) {
            return this.matchAttributes((MatchAttributes)((MatchAttributes.Builder)MatchAttributes.builder().applyMutation(matchAttributes)).build());
        }

        public Builder actions(Collection<String> var1);

        public Builder actions(String ... var1);
    }
}

