/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallAsyncClient;
import software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.TLSInspectionConfigurationMetadata;

public class ListTLSInspectionConfigurationsPublisher
implements SdkPublisher<ListTlsInspectionConfigurationsResponse> {
    private final NetworkFirewallAsyncClient client;
    private final ListTlsInspectionConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTLSInspectionConfigurationsPublisher(NetworkFirewallAsyncClient client, ListTlsInspectionConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTLSInspectionConfigurationsPublisher(NetworkFirewallAsyncClient client, ListTlsInspectionConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTlsInspectionConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTlsInspectionConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TLSInspectionConfigurationMetadata> tlsInspectionConfigurations() {
        Function<ListTlsInspectionConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tlsInspectionConfigurations() != null) {
                return response.tlsInspectionConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTlsInspectionConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTlsInspectionConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListTlsInspectionConfigurationsResponse> {
        private ListTlsInspectionConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListTlsInspectionConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTlsInspectionConfigurationsResponse> nextPage(ListTlsInspectionConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListTLSInspectionConfigurationsPublisher.this.client.listTLSInspectionConfigurations(ListTLSInspectionConfigurationsPublisher.this.firstRequest);
            }
            return ListTLSInspectionConfigurationsPublisher.this.client.listTLSInspectionConfigurations((ListTlsInspectionConfigurationsRequest)((Object)ListTLSInspectionConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

