/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.networkfirewall.DefaultNetworkFirewallAsyncClient;
import software.amazon.awssdk.services.networkfirewall.DefaultNetworkFirewallBaseClientBuilder;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallAsyncClient;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallAsyncClientBuilder;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallServiceClientConfiguration;
import software.amazon.awssdk.services.networkfirewall.endpoints.NetworkFirewallEndpointProvider;

@SdkInternalApi
final class DefaultNetworkFirewallAsyncClientBuilder
extends DefaultNetworkFirewallBaseClientBuilder<NetworkFirewallAsyncClientBuilder, NetworkFirewallAsyncClient>
implements NetworkFirewallAsyncClientBuilder {
    DefaultNetworkFirewallAsyncClientBuilder() {
    }

    @Override
    public DefaultNetworkFirewallAsyncClientBuilder endpointProvider(NetworkFirewallEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final NetworkFirewallAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultNetworkFirewallAsyncClientBuilder.validateClientOptions(clientConfiguration);
        NetworkFirewallServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultNetworkFirewallAsyncClient client = new DefaultNetworkFirewallAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private NetworkFirewallServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return NetworkFirewallServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

