/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum StatefulRuleProtocol {
    IP("IP"),
    TCP("TCP"),
    UDP("UDP"),
    ICMP("ICMP"),
    HTTP("HTTP"),
    FTP("FTP"),
    TLS("TLS"),
    SMB("SMB"),
    DNS("DNS"),
    DCERPC("DCERPC"),
    SSH("SSH"),
    SMTP("SMTP"),
    IMAP("IMAP"),
    MSN("MSN"),
    KRB5("KRB5"),
    IKEV2("IKEV2"),
    TFTP("TFTP"),
    NTP("NTP"),
    DHCP("DHCP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StatefulRuleProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StatefulRuleProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StatefulRuleProtocol.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StatefulRuleProtocol> knownValues() {
        return Stream.of(StatefulRuleProtocol.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

