/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.SubnetMapping;
import software.amazon.awssdk.services.networkfirewall.model.SubnetMappingsCopier;
import software.amazon.awssdk.services.networkfirewall.model.Tag;
import software.amazon.awssdk.services.networkfirewall.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Firewall
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Firewall> {
    private static final SdkField<String> FIREWALL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallName").getter(Firewall.getter(Firewall::firewallName)).setter(Firewall.setter(Builder::firewallName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallName").build()}).build();
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallArn").getter(Firewall.getter(Firewall::firewallArn)).setter(Firewall.setter(Builder::firewallArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()}).build();
    private static final SdkField<String> FIREWALL_POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallPolicyArn").getter(Firewall.getter(Firewall::firewallPolicyArn)).setter(Firewall.setter(Builder::firewallPolicyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyArn").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(Firewall.getter(Firewall::vpcId)).setter(Firewall.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<SubnetMapping>> SUBNET_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetMappings").getter(Firewall.getter(Firewall::subnetMappings)).setter(Firewall.setter(Builder::subnetMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubnetMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DELETE_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteProtection").getter(Firewall.getter(Firewall::deleteProtection)).setter(Firewall.setter(Builder::deleteProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteProtection").build()}).build();
    private static final SdkField<Boolean> SUBNET_CHANGE_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SubnetChangeProtection").getter(Firewall.getter(Firewall::subnetChangeProtection)).setter(Firewall.setter(Builder::subnetChangeProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetChangeProtection").build()}).build();
    private static final SdkField<Boolean> FIREWALL_POLICY_CHANGE_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FirewallPolicyChangeProtection").getter(Firewall.getter(Firewall::firewallPolicyChangeProtection)).setter(Firewall.setter(Builder::firewallPolicyChangeProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyChangeProtection").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Firewall.getter(Firewall::description)).setter(Firewall.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> FIREWALL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallId").getter(Firewall.getter(Firewall::firewallId)).setter(Firewall.setter(Builder::firewallId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Firewall.getter(Firewall::tags)).setter(Firewall.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_NAME_FIELD, FIREWALL_ARN_FIELD, FIREWALL_POLICY_ARN_FIELD, VPC_ID_FIELD, SUBNET_MAPPINGS_FIELD, DELETE_PROTECTION_FIELD, SUBNET_CHANGE_PROTECTION_FIELD, FIREWALL_POLICY_CHANGE_PROTECTION_FIELD, DESCRIPTION_FIELD, FIREWALL_ID_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String firewallName;
    private final String firewallArn;
    private final String firewallPolicyArn;
    private final String vpcId;
    private final List<SubnetMapping> subnetMappings;
    private final Boolean deleteProtection;
    private final Boolean subnetChangeProtection;
    private final Boolean firewallPolicyChangeProtection;
    private final String description;
    private final String firewallId;
    private final List<Tag> tags;

    private Firewall(BuilderImpl builder) {
        this.firewallName = builder.firewallName;
        this.firewallArn = builder.firewallArn;
        this.firewallPolicyArn = builder.firewallPolicyArn;
        this.vpcId = builder.vpcId;
        this.subnetMappings = builder.subnetMappings;
        this.deleteProtection = builder.deleteProtection;
        this.subnetChangeProtection = builder.subnetChangeProtection;
        this.firewallPolicyChangeProtection = builder.firewallPolicyChangeProtection;
        this.description = builder.description;
        this.firewallId = builder.firewallId;
        this.tags = builder.tags;
    }

    public final String firewallName() {
        return this.firewallName;
    }

    public final String firewallArn() {
        return this.firewallArn;
    }

    public final String firewallPolicyArn() {
        return this.firewallPolicyArn;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasSubnetMappings() {
        return this.subnetMappings != null && !(this.subnetMappings instanceof SdkAutoConstructList);
    }

    public final List<SubnetMapping> subnetMappings() {
        return this.subnetMappings;
    }

    public final Boolean deleteProtection() {
        return this.deleteProtection;
    }

    public final Boolean subnetChangeProtection() {
        return this.subnetChangeProtection;
    }

    public final Boolean firewallPolicyChangeProtection() {
        return this.firewallPolicyChangeProtection;
    }

    public final String description() {
        return this.description;
    }

    public final String firewallId() {
        return this.firewallId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallName());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetMappings() ? this.subnetMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetChangeProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallPolicyChangeProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Firewall)) {
            return false;
        }
        Firewall other = (Firewall)obj;
        return Objects.equals(this.firewallName(), other.firewallName()) && Objects.equals(this.firewallArn(), other.firewallArn()) && Objects.equals(this.firewallPolicyArn(), other.firewallPolicyArn()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasSubnetMappings() == other.hasSubnetMappings() && Objects.equals(this.subnetMappings(), other.subnetMappings()) && Objects.equals(this.deleteProtection(), other.deleteProtection()) && Objects.equals(this.subnetChangeProtection(), other.subnetChangeProtection()) && Objects.equals(this.firewallPolicyChangeProtection(), other.firewallPolicyChangeProtection()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.firewallId(), other.firewallId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Firewall").add("FirewallName", (Object)this.firewallName()).add("FirewallArn", (Object)this.firewallArn()).add("FirewallPolicyArn", (Object)this.firewallPolicyArn()).add("VpcId", (Object)this.vpcId()).add("SubnetMappings", this.hasSubnetMappings() ? this.subnetMappings() : null).add("DeleteProtection", (Object)this.deleteProtection()).add("SubnetChangeProtection", (Object)this.subnetChangeProtection()).add("FirewallPolicyChangeProtection", (Object)this.firewallPolicyChangeProtection()).add("Description", (Object)this.description()).add("FirewallId", (Object)this.firewallId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallName": {
                return Optional.ofNullable(clazz.cast(this.firewallName()));
            }
            case "FirewallArn": {
                return Optional.ofNullable(clazz.cast(this.firewallArn()));
            }
            case "FirewallPolicyArn": {
                return Optional.ofNullable(clazz.cast(this.firewallPolicyArn()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetMappings": {
                return Optional.ofNullable(clazz.cast(this.subnetMappings()));
            }
            case "DeleteProtection": {
                return Optional.ofNullable(clazz.cast(this.deleteProtection()));
            }
            case "SubnetChangeProtection": {
                return Optional.ofNullable(clazz.cast(this.subnetChangeProtection()));
            }
            case "FirewallPolicyChangeProtection": {
                return Optional.ofNullable(clazz.cast(this.firewallPolicyChangeProtection()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "FirewallId": {
                return Optional.ofNullable(clazz.cast(this.firewallId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Firewall, T> g) {
        return obj -> g.apply((Firewall)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String firewallName;
        private String firewallArn;
        private String firewallPolicyArn;
        private String vpcId;
        private List<SubnetMapping> subnetMappings = DefaultSdkAutoConstructList.getInstance();
        private Boolean deleteProtection;
        private Boolean subnetChangeProtection;
        private Boolean firewallPolicyChangeProtection;
        private String description;
        private String firewallId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Firewall model) {
            this.firewallName(model.firewallName);
            this.firewallArn(model.firewallArn);
            this.firewallPolicyArn(model.firewallPolicyArn);
            this.vpcId(model.vpcId);
            this.subnetMappings(model.subnetMappings);
            this.deleteProtection(model.deleteProtection);
            this.subnetChangeProtection(model.subnetChangeProtection);
            this.firewallPolicyChangeProtection(model.firewallPolicyChangeProtection);
            this.description(model.description);
            this.firewallId(model.firewallId);
            this.tags(model.tags);
        }

        public final String getFirewallName() {
            return this.firewallName;
        }

        @Override
        public final Builder firewallName(String firewallName) {
            this.firewallName = firewallName;
            return this;
        }

        public final void setFirewallName(String firewallName) {
            this.firewallName = firewallName;
        }

        public final String getFirewallArn() {
            return this.firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        public final String getFirewallPolicyArn() {
            return this.firewallPolicyArn;
        }

        @Override
        public final Builder firewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
            return this;
        }

        public final void setFirewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<SubnetMapping.Builder> getSubnetMappings() {
            if (this.subnetMappings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetMappings != null ? (Collection)this.subnetMappings.stream().map(SubnetMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subnetMappings(Collection<SubnetMapping> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copy(subnetMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetMappings(SubnetMapping ... subnetMappings) {
            this.subnetMappings(Arrays.asList(subnetMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetMappings(Consumer<SubnetMapping.Builder> ... subnetMappings) {
            this.subnetMappings(Stream.of(subnetMappings).map(c -> (SubnetMapping)((SubnetMapping.Builder)SubnetMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubnetMappings(Collection<SubnetMapping.BuilderImpl> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copyFromBuilder(subnetMappings);
        }

        public final Boolean getDeleteProtection() {
            return this.deleteProtection;
        }

        @Override
        public final Builder deleteProtection(Boolean deleteProtection) {
            this.deleteProtection = deleteProtection;
            return this;
        }

        public final void setDeleteProtection(Boolean deleteProtection) {
            this.deleteProtection = deleteProtection;
        }

        public final Boolean getSubnetChangeProtection() {
            return this.subnetChangeProtection;
        }

        @Override
        public final Builder subnetChangeProtection(Boolean subnetChangeProtection) {
            this.subnetChangeProtection = subnetChangeProtection;
            return this;
        }

        public final void setSubnetChangeProtection(Boolean subnetChangeProtection) {
            this.subnetChangeProtection = subnetChangeProtection;
        }

        public final Boolean getFirewallPolicyChangeProtection() {
            return this.firewallPolicyChangeProtection;
        }

        @Override
        public final Builder firewallPolicyChangeProtection(Boolean firewallPolicyChangeProtection) {
            this.firewallPolicyChangeProtection = firewallPolicyChangeProtection;
            return this;
        }

        public final void setFirewallPolicyChangeProtection(Boolean firewallPolicyChangeProtection) {
            this.firewallPolicyChangeProtection = firewallPolicyChangeProtection;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getFirewallId() {
            return this.firewallId;
        }

        @Override
        public final Builder firewallId(String firewallId) {
            this.firewallId = firewallId;
            return this;
        }

        public final void setFirewallId(String firewallId) {
            this.firewallId = firewallId;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public Firewall build() {
            return new Firewall(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Firewall> {
        public Builder firewallName(String var1);

        public Builder firewallArn(String var1);

        public Builder firewallPolicyArn(String var1);

        public Builder vpcId(String var1);

        public Builder subnetMappings(Collection<SubnetMapping> var1);

        public Builder subnetMappings(SubnetMapping ... var1);

        public Builder subnetMappings(Consumer<SubnetMapping.Builder> ... var1);

        public Builder deleteProtection(Boolean var1);

        public Builder subnetChangeProtection(Boolean var1);

        public Builder firewallPolicyChangeProtection(Boolean var1);

        public Builder description(String var1);

        public Builder firewallId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

