/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PerObjectStatus implements SdkPojo, Serializable, ToCopyableBuilder<PerObjectStatus.Builder, PerObjectStatus> {
    private static final SdkField<String> SYNC_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SyncStatus").getter(getter(PerObjectStatus::syncStatusAsString)).setter(setter(Builder::syncStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String syncStatus;

    private PerObjectStatus(BuilderImpl builder) {
        this.syncStatus = builder.syncStatus;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncStatus} will
     * return {@link PerObjectSyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #syncStatusAsString}.
     * </p>
     * 
     * @return
     * @see PerObjectSyncStatus
     */
    public final PerObjectSyncStatus syncStatus() {
        return PerObjectSyncStatus.fromValue(syncStatus);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncStatus} will
     * return {@link PerObjectSyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #syncStatusAsString}.
     * </p>
     * 
     * @return
     * @see PerObjectSyncStatus
     */
    public final String syncStatusAsString() {
        return syncStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(syncStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerObjectStatus)) {
            return false;
        }
        PerObjectStatus other = (PerObjectStatus) obj;
        return Objects.equals(syncStatusAsString(), other.syncStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PerObjectStatus").add("SyncStatus", syncStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SyncStatus":
            return Optional.ofNullable(clazz.cast(syncStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PerObjectStatus, T> g) {
        return obj -> g.apply((PerObjectStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PerObjectStatus> {
        /**
         * <p/>
         * 
         * @param syncStatus
         * @see PerObjectSyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PerObjectSyncStatus
         */
        Builder syncStatus(String syncStatus);

        /**
         * <p/>
         * 
         * @param syncStatus
         * @see PerObjectSyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PerObjectSyncStatus
         */
        Builder syncStatus(PerObjectSyncStatus syncStatus);
    }

    static final class BuilderImpl implements Builder {
        private String syncStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PerObjectStatus model) {
            syncStatus(model.syncStatus);
        }

        public final String getSyncStatus() {
            return syncStatus;
        }

        @Override
        public final Builder syncStatus(String syncStatus) {
            this.syncStatus = syncStatus;
            return this;
        }

        @Override
        public final Builder syncStatus(PerObjectSyncStatus syncStatus) {
            this.syncStatus(syncStatus == null ? null : syncStatus.toString());
            return this;
        }

        public final void setSyncStatus(String syncStatus) {
            this.syncStatus = syncStatus;
        }

        @Override
        public PerObjectStatus build() {
            return new PerObjectStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
