/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRuleGroupsResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<ListRuleGroupsResponse.Builder, ListRuleGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRuleGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<RuleGroupMetadata>> RULE_GROUPS_FIELD = SdkField
            .<List<RuleGroupMetadata>> builder(MarshallingType.LIST)
            .memberName("RuleGroups")
            .getter(getter(ListRuleGroupsResponse::ruleGroups))
            .setter(setter(Builder::ruleGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleGroupMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleGroupMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RULE_GROUPS_FIELD));

    private final String nextToken;

    private final List<RuleGroupMetadata> ruleGroups;

    private ListRuleGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.ruleGroups = builder.ruleGroups;
    }

    /**
     * <p>
     * When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are
     * still available for retrieval exceeds the maximum you requested, Network Firewall returns a
     * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from
     * the prior request in your next request.
     * </p>
     * 
     * @return When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that
     *         are still available for retrieval exceeds the maximum you requested, Network Firewall returns a
     *         <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
     *         returned from the prior request in your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the RuleGroups property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRuleGroups() {
        return ruleGroups != null && !(ruleGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rule group metadata objects that you've defined. Depending on your setting for max results and the number of
     * rule groups, this might not be the full list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRuleGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The rule group metadata objects that you've defined. Depending on your setting for max results and the
     *         number of rule groups, this might not be the full list.
     */
    public final List<RuleGroupMetadata> ruleGroups() {
        return ruleGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleGroups() ? ruleGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRuleGroupsResponse)) {
            return false;
        }
        ListRuleGroupsResponse other = (ListRuleGroupsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasRuleGroups() == other.hasRuleGroups()
                && Objects.equals(ruleGroups(), other.ruleGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRuleGroupsResponse").add("NextToken", nextToken())
                .add("RuleGroups", hasRuleGroups() ? ruleGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RuleGroups":
            return Optional.ofNullable(clazz.cast(ruleGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRuleGroupsResponse, T> g) {
        return obj -> g.apply((ListRuleGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRuleGroupsResponse> {
        /**
         * <p>
         * When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are
         * still available for retrieval exceeds the maximum you requested, Network Firewall returns a
         * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned
         * from the prior request in your next request.
         * </p>
         * 
         * @param nextToken
         *        When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects
         *        that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a
         *        <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
         *        returned from the prior request in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The rule group metadata objects that you've defined. Depending on your setting for max results and the number
         * of rule groups, this might not be the full list.
         * </p>
         * 
         * @param ruleGroups
         *        The rule group metadata objects that you've defined. Depending on your setting for max results and the
         *        number of rule groups, this might not be the full list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroups(Collection<RuleGroupMetadata> ruleGroups);

        /**
         * <p>
         * The rule group metadata objects that you've defined. Depending on your setting for max results and the number
         * of rule groups, this might not be the full list.
         * </p>
         * 
         * @param ruleGroups
         *        The rule group metadata objects that you've defined. Depending on your setting for max results and the
         *        number of rule groups, this might not be the full list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroups(RuleGroupMetadata... ruleGroups);

        /**
         * <p>
         * The rule group metadata objects that you've defined. Depending on your setting for max results and the number
         * of rule groups, this might not be the full list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RuleGroupMetadata>.Builder} avoiding the
         * need to create one manually via {@link List<RuleGroupMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RuleGroupMetadata>.Builder#build()} is called immediately
         * and its result is passed to {@link #ruleGroups(List<RuleGroupMetadata>)}.
         * 
         * @param ruleGroups
         *        a consumer that will call methods on {@link List<RuleGroupMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleGroups(List<RuleGroupMetadata>)
         */
        Builder ruleGroups(Consumer<RuleGroupMetadata.Builder>... ruleGroups);
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RuleGroupMetadata> ruleGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRuleGroupsResponse model) {
            super(model);
            nextToken(model.nextToken);
            ruleGroups(model.ruleGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<RuleGroupMetadata.Builder> getRuleGroups() {
            if (ruleGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return ruleGroups != null ? ruleGroups.stream().map(RuleGroupMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ruleGroups(Collection<RuleGroupMetadata> ruleGroups) {
            this.ruleGroups = RuleGroupsCopier.copy(ruleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(RuleGroupMetadata... ruleGroups) {
            ruleGroups(Arrays.asList(ruleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(Consumer<RuleGroupMetadata.Builder>... ruleGroups) {
            ruleGroups(Stream.of(ruleGroups).map(c -> RuleGroupMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRuleGroups(Collection<RuleGroupMetadata.BuilderImpl> ruleGroups) {
            this.ruleGroups = RuleGroupsCopier.copyFromBuilder(ruleGroups);
        }

        @Override
        public ListRuleGroupsResponse build() {
            return new ListRuleGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
