/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The firewall policy defines the behavior of a firewall using a collection of stateless and stateful rule groups and
 * other settings. You can use one firewall policy for multiple firewalls.
 * </p>
 * <p>
 * This, along with <a>FirewallPolicyResponse</a>, define the policy. You can retrieve all objects for a firewall policy
 * by calling <a>DescribeFirewallPolicy</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallPolicy implements SdkPojo, Serializable, ToCopyableBuilder<FirewallPolicy.Builder, FirewallPolicy> {
    private static final SdkField<List<StatelessRuleGroupReference>> STATELESS_RULE_GROUP_REFERENCES_FIELD = SdkField
            .<List<StatelessRuleGroupReference>> builder(MarshallingType.LIST)
            .memberName("StatelessRuleGroupReferences")
            .getter(getter(FirewallPolicy::statelessRuleGroupReferences))
            .setter(setter(Builder::statelessRuleGroupReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessRuleGroupReferences")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StatelessRuleGroupReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(StatelessRuleGroupReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATELESS_DEFAULT_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StatelessDefaultActions")
            .getter(getter(FirewallPolicy::statelessDefaultActions))
            .setter(setter(Builder::statelessDefaultActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessDefaultActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATELESS_FRAGMENT_DEFAULT_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StatelessFragmentDefaultActions")
            .getter(getter(FirewallPolicy::statelessFragmentDefaultActions))
            .setter(setter(Builder::statelessFragmentDefaultActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessFragmentDefaultActions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CustomAction>> STATELESS_CUSTOM_ACTIONS_FIELD = SdkField
            .<List<CustomAction>> builder(MarshallingType.LIST)
            .memberName("StatelessCustomActions")
            .getter(getter(FirewallPolicy::statelessCustomActions))
            .setter(setter(Builder::statelessCustomActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessCustomActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StatefulRuleGroupReference>> STATEFUL_RULE_GROUP_REFERENCES_FIELD = SdkField
            .<List<StatefulRuleGroupReference>> builder(MarshallingType.LIST)
            .memberName("StatefulRuleGroupReferences")
            .getter(getter(FirewallPolicy::statefulRuleGroupReferences))
            .setter(setter(Builder::statefulRuleGroupReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulRuleGroupReferences")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StatefulRuleGroupReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(StatefulRuleGroupReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STATELESS_RULE_GROUP_REFERENCES_FIELD, STATELESS_DEFAULT_ACTIONS_FIELD, STATELESS_FRAGMENT_DEFAULT_ACTIONS_FIELD,
            STATELESS_CUSTOM_ACTIONS_FIELD, STATEFUL_RULE_GROUP_REFERENCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<StatelessRuleGroupReference> statelessRuleGroupReferences;

    private final List<String> statelessDefaultActions;

    private final List<String> statelessFragmentDefaultActions;

    private final List<CustomAction> statelessCustomActions;

    private final List<StatefulRuleGroupReference> statefulRuleGroupReferences;

    private FirewallPolicy(BuilderImpl builder) {
        this.statelessRuleGroupReferences = builder.statelessRuleGroupReferences;
        this.statelessDefaultActions = builder.statelessDefaultActions;
        this.statelessFragmentDefaultActions = builder.statelessFragmentDefaultActions;
        this.statelessCustomActions = builder.statelessCustomActions;
        this.statefulRuleGroupReferences = builder.statefulRuleGroupReferences;
    }

    /**
     * Returns true if the StatelessRuleGroupReferences property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasStatelessRuleGroupReferences() {
        return statelessRuleGroupReferences != null && !(statelessRuleGroupReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * References to the stateless rule groups that are used in the policy. These define the matching criteria in
     * stateless rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatelessRuleGroupReferences()} to see if a value was sent in this field.
     * </p>
     * 
     * @return References to the stateless rule groups that are used in the policy. These define the matching criteria
     *         in stateless rules.
     */
    public final List<StatelessRuleGroupReference> statelessRuleGroupReferences() {
        return statelessRuleGroupReferences;
    }

    /**
     * Returns true if the StatelessDefaultActions property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasStatelessDefaultActions() {
        return statelessDefaultActions != null && !(statelessDefaultActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to take on a packet if it doesn't match any of the stateless rules in the policy. If you want
     * non-matching packets to be forwarded for stateful inspection, specify <code>aws:forward_to_sfe</code>.
     * </p>
     * <p>
     * You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
     * <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with your
     * standard section choice.
     * </p>
     * <p>
     * For example, you could specify <code>["aws:pass"]</code> or you could specify
     * <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action
     * descriptions under <a>CustomAction</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatelessDefaultActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions to take on a packet if it doesn't match any of the stateless rules in the policy. If you want
     *         non-matching packets to be forwarded for stateful inspection, specify <code>aws:forward_to_sfe</code>.
     *         </p>
     *         <p>
     *         You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
     *         <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with
     *         your standard section choice.
     *         </p>
     *         <p>
     *         For example, you could specify <code>["aws:pass"]</code> or you could specify
     *         <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action
     *         descriptions under <a>CustomAction</a>.
     */
    public final List<String> statelessDefaultActions() {
        return statelessDefaultActions;
    }

    /**
     * Returns true if the StatelessFragmentDefaultActions property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasStatelessFragmentDefaultActions() {
        return statelessFragmentDefaultActions != null && !(statelessFragmentDefaultActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to take on a fragmented packet if it doesn't match any of the stateless rules in the policy. If you
     * want non-matching fragmented packets to be forwarded for stateful inspection, specify
     * <code>aws:forward_to_sfe</code>.
     * </p>
     * <p>
     * You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
     * <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with your
     * standard section choice.
     * </p>
     * <p>
     * For example, you could specify <code>["aws:pass"]</code> or you could specify
     * <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action
     * descriptions under <a>CustomAction</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatelessFragmentDefaultActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions to take on a fragmented packet if it doesn't match any of the stateless rules in the policy.
     *         If you want non-matching fragmented packets to be forwarded for stateful inspection, specify
     *         <code>aws:forward_to_sfe</code>. </p>
     *         <p>
     *         You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
     *         <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with
     *         your standard section choice.
     *         </p>
     *         <p>
     *         For example, you could specify <code>["aws:pass"]</code> or you could specify
     *         <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action
     *         descriptions under <a>CustomAction</a>.
     */
    public final List<String> statelessFragmentDefaultActions() {
        return statelessFragmentDefaultActions;
    }

    /**
     * Returns true if the StatelessCustomActions property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasStatelessCustomActions() {
        return statelessCustomActions != null && !(statelessCustomActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The custom action definitions that are available for use in the firewall policy's
     * <code>StatelessDefaultActions</code> setting. You name each custom action that you define, and then you can use
     * it by name in your default actions specifications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatelessCustomActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The custom action definitions that are available for use in the firewall policy's
     *         <code>StatelessDefaultActions</code> setting. You name each custom action that you define, and then you
     *         can use it by name in your default actions specifications.
     */
    public final List<CustomAction> statelessCustomActions() {
        return statelessCustomActions;
    }

    /**
     * Returns true if the StatefulRuleGroupReferences property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasStatefulRuleGroupReferences() {
        return statefulRuleGroupReferences != null && !(statefulRuleGroupReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * References to the stateless rule groups that are used in the policy. These define the inspection criteria in
     * stateful rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStatefulRuleGroupReferences()} to see if a value was sent in this field.
     * </p>
     * 
     * @return References to the stateless rule groups that are used in the policy. These define the inspection criteria
     *         in stateful rules.
     */
    public final List<StatefulRuleGroupReference> statefulRuleGroupReferences() {
        return statefulRuleGroupReferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStatelessRuleGroupReferences() ? statelessRuleGroupReferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatelessDefaultActions() ? statelessDefaultActions() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasStatelessFragmentDefaultActions() ? statelessFragmentDefaultActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatelessCustomActions() ? statelessCustomActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatefulRuleGroupReferences() ? statefulRuleGroupReferences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallPolicy)) {
            return false;
        }
        FirewallPolicy other = (FirewallPolicy) obj;
        return hasStatelessRuleGroupReferences() == other.hasStatelessRuleGroupReferences()
                && Objects.equals(statelessRuleGroupReferences(), other.statelessRuleGroupReferences())
                && hasStatelessDefaultActions() == other.hasStatelessDefaultActions()
                && Objects.equals(statelessDefaultActions(), other.statelessDefaultActions())
                && hasStatelessFragmentDefaultActions() == other.hasStatelessFragmentDefaultActions()
                && Objects.equals(statelessFragmentDefaultActions(), other.statelessFragmentDefaultActions())
                && hasStatelessCustomActions() == other.hasStatelessCustomActions()
                && Objects.equals(statelessCustomActions(), other.statelessCustomActions())
                && hasStatefulRuleGroupReferences() == other.hasStatefulRuleGroupReferences()
                && Objects.equals(statefulRuleGroupReferences(), other.statefulRuleGroupReferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("FirewallPolicy")
                .add("StatelessRuleGroupReferences", hasStatelessRuleGroupReferences() ? statelessRuleGroupReferences() : null)
                .add("StatelessDefaultActions", hasStatelessDefaultActions() ? statelessDefaultActions() : null)
                .add("StatelessFragmentDefaultActions",
                        hasStatelessFragmentDefaultActions() ? statelessFragmentDefaultActions() : null)
                .add("StatelessCustomActions", hasStatelessCustomActions() ? statelessCustomActions() : null)
                .add("StatefulRuleGroupReferences", hasStatefulRuleGroupReferences() ? statefulRuleGroupReferences() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatelessRuleGroupReferences":
            return Optional.ofNullable(clazz.cast(statelessRuleGroupReferences()));
        case "StatelessDefaultActions":
            return Optional.ofNullable(clazz.cast(statelessDefaultActions()));
        case "StatelessFragmentDefaultActions":
            return Optional.ofNullable(clazz.cast(statelessFragmentDefaultActions()));
        case "StatelessCustomActions":
            return Optional.ofNullable(clazz.cast(statelessCustomActions()));
        case "StatefulRuleGroupReferences":
            return Optional.ofNullable(clazz.cast(statefulRuleGroupReferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallPolicy, T> g) {
        return obj -> g.apply((FirewallPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallPolicy> {
        /**
         * <p>
         * References to the stateless rule groups that are used in the policy. These define the matching criteria in
         * stateless rules.
         * </p>
         * 
         * @param statelessRuleGroupReferences
         *        References to the stateless rule groups that are used in the policy. These define the matching
         *        criteria in stateless rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessRuleGroupReferences(Collection<StatelessRuleGroupReference> statelessRuleGroupReferences);

        /**
         * <p>
         * References to the stateless rule groups that are used in the policy. These define the matching criteria in
         * stateless rules.
         * </p>
         * 
         * @param statelessRuleGroupReferences
         *        References to the stateless rule groups that are used in the policy. These define the matching
         *        criteria in stateless rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessRuleGroupReferences(StatelessRuleGroupReference... statelessRuleGroupReferences);

        /**
         * <p>
         * References to the stateless rule groups that are used in the policy. These define the matching criteria in
         * stateless rules.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StatelessRuleGroupReference>.Builder}
         * avoiding the need to create one manually via {@link List<StatelessRuleGroupReference>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StatelessRuleGroupReference>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #statelessRuleGroupReferences(List<StatelessRuleGroupReference>)}.
         * 
         * @param statelessRuleGroupReferences
         *        a consumer that will call methods on {@link List<StatelessRuleGroupReference>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statelessRuleGroupReferences(List<StatelessRuleGroupReference>)
         */
        Builder statelessRuleGroupReferences(Consumer<StatelessRuleGroupReference.Builder>... statelessRuleGroupReferences);

        /**
         * <p>
         * The actions to take on a packet if it doesn't match any of the stateless rules in the policy. If you want
         * non-matching packets to be forwarded for stateful inspection, specify <code>aws:forward_to_sfe</code>.
         * </p>
         * <p>
         * You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
         * <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with your
         * standard section choice.
         * </p>
         * <p>
         * For example, you could specify <code>["aws:pass"]</code> or you could specify
         * <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action
         * descriptions under <a>CustomAction</a>.
         * </p>
         * 
         * @param statelessDefaultActions
         *        The actions to take on a packet if it doesn't match any of the stateless rules in the policy. If you
         *        want non-matching packets to be forwarded for stateful inspection, specify
         *        <code>aws:forward_to_sfe</code>. </p>
         *        <p>
         *        You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
         *        <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with
         *        your standard section choice.
         *        </p>
         *        <p>
         *        For example, you could specify <code>["aws:pass"]</code> or you could specify
         *        <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom
         *        action descriptions under <a>CustomAction</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessDefaultActions(Collection<String> statelessDefaultActions);

        /**
         * <p>
         * The actions to take on a packet if it doesn't match any of the stateless rules in the policy. If you want
         * non-matching packets to be forwarded for stateful inspection, specify <code>aws:forward_to_sfe</code>.
         * </p>
         * <p>
         * You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
         * <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with your
         * standard section choice.
         * </p>
         * <p>
         * For example, you could specify <code>["aws:pass"]</code> or you could specify
         * <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action
         * descriptions under <a>CustomAction</a>.
         * </p>
         * 
         * @param statelessDefaultActions
         *        The actions to take on a packet if it doesn't match any of the stateless rules in the policy. If you
         *        want non-matching packets to be forwarded for stateful inspection, specify
         *        <code>aws:forward_to_sfe</code>. </p>
         *        <p>
         *        You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
         *        <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with
         *        your standard section choice.
         *        </p>
         *        <p>
         *        For example, you could specify <code>["aws:pass"]</code> or you could specify
         *        <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom
         *        action descriptions under <a>CustomAction</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessDefaultActions(String... statelessDefaultActions);

        /**
         * <p>
         * The actions to take on a fragmented packet if it doesn't match any of the stateless rules in the policy. If
         * you want non-matching fragmented packets to be forwarded for stateful inspection, specify
         * <code>aws:forward_to_sfe</code>.
         * </p>
         * <p>
         * You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
         * <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with your
         * standard section choice.
         * </p>
         * <p>
         * For example, you could specify <code>["aws:pass"]</code> or you could specify
         * <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action
         * descriptions under <a>CustomAction</a>.
         * </p>
         * 
         * @param statelessFragmentDefaultActions
         *        The actions to take on a fragmented packet if it doesn't match any of the stateless rules in the
         *        policy. If you want non-matching fragmented packets to be forwarded for stateful inspection, specify
         *        <code>aws:forward_to_sfe</code>. </p>
         *        <p>
         *        You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
         *        <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with
         *        your standard section choice.
         *        </p>
         *        <p>
         *        For example, you could specify <code>["aws:pass"]</code> or you could specify
         *        <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom
         *        action descriptions under <a>CustomAction</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessFragmentDefaultActions(Collection<String> statelessFragmentDefaultActions);

        /**
         * <p>
         * The actions to take on a fragmented packet if it doesn't match any of the stateless rules in the policy. If
         * you want non-matching fragmented packets to be forwarded for stateful inspection, specify
         * <code>aws:forward_to_sfe</code>.
         * </p>
         * <p>
         * You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
         * <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with your
         * standard section choice.
         * </p>
         * <p>
         * For example, you could specify <code>["aws:pass"]</code> or you could specify
         * <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action
         * descriptions under <a>CustomAction</a>.
         * </p>
         * 
         * @param statelessFragmentDefaultActions
         *        The actions to take on a fragmented packet if it doesn't match any of the stateless rules in the
         *        policy. If you want non-matching fragmented packets to be forwarded for stateful inspection, specify
         *        <code>aws:forward_to_sfe</code>. </p>
         *        <p>
         *        You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
         *        <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with
         *        your standard section choice.
         *        </p>
         *        <p>
         *        For example, you could specify <code>["aws:pass"]</code> or you could specify
         *        <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom
         *        action descriptions under <a>CustomAction</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessFragmentDefaultActions(String... statelessFragmentDefaultActions);

        /**
         * <p>
         * The custom action definitions that are available for use in the firewall policy's
         * <code>StatelessDefaultActions</code> setting. You name each custom action that you define, and then you can
         * use it by name in your default actions specifications.
         * </p>
         * 
         * @param statelessCustomActions
         *        The custom action definitions that are available for use in the firewall policy's
         *        <code>StatelessDefaultActions</code> setting. You name each custom action that you define, and then
         *        you can use it by name in your default actions specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessCustomActions(Collection<CustomAction> statelessCustomActions);

        /**
         * <p>
         * The custom action definitions that are available for use in the firewall policy's
         * <code>StatelessDefaultActions</code> setting. You name each custom action that you define, and then you can
         * use it by name in your default actions specifications.
         * </p>
         * 
         * @param statelessCustomActions
         *        The custom action definitions that are available for use in the firewall policy's
         *        <code>StatelessDefaultActions</code> setting. You name each custom action that you define, and then
         *        you can use it by name in your default actions specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessCustomActions(CustomAction... statelessCustomActions);

        /**
         * <p>
         * The custom action definitions that are available for use in the firewall policy's
         * <code>StatelessDefaultActions</code> setting. You name each custom action that you define, and then you can
         * use it by name in your default actions specifications.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CustomAction>.Builder} avoiding the need to
         * create one manually via {@link List<CustomAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomAction>.Builder#build()} is called immediately and its
         * result is passed to {@link #statelessCustomActions(List<CustomAction>)}.
         * 
         * @param statelessCustomActions
         *        a consumer that will call methods on {@link List<CustomAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statelessCustomActions(List<CustomAction>)
         */
        Builder statelessCustomActions(Consumer<CustomAction.Builder>... statelessCustomActions);

        /**
         * <p>
         * References to the stateless rule groups that are used in the policy. These define the inspection criteria in
         * stateful rules.
         * </p>
         * 
         * @param statefulRuleGroupReferences
         *        References to the stateless rule groups that are used in the policy. These define the inspection
         *        criteria in stateful rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statefulRuleGroupReferences(Collection<StatefulRuleGroupReference> statefulRuleGroupReferences);

        /**
         * <p>
         * References to the stateless rule groups that are used in the policy. These define the inspection criteria in
         * stateful rules.
         * </p>
         * 
         * @param statefulRuleGroupReferences
         *        References to the stateless rule groups that are used in the policy. These define the inspection
         *        criteria in stateful rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statefulRuleGroupReferences(StatefulRuleGroupReference... statefulRuleGroupReferences);

        /**
         * <p>
         * References to the stateless rule groups that are used in the policy. These define the inspection criteria in
         * stateful rules.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StatefulRuleGroupReference>.Builder}
         * avoiding the need to create one manually via {@link List<StatefulRuleGroupReference>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StatefulRuleGroupReference>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #statefulRuleGroupReferences(List<StatefulRuleGroupReference>)}.
         * 
         * @param statefulRuleGroupReferences
         *        a consumer that will call methods on {@link List<StatefulRuleGroupReference>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statefulRuleGroupReferences(List<StatefulRuleGroupReference>)
         */
        Builder statefulRuleGroupReferences(Consumer<StatefulRuleGroupReference.Builder>... statefulRuleGroupReferences);
    }

    static final class BuilderImpl implements Builder {
        private List<StatelessRuleGroupReference> statelessRuleGroupReferences = DefaultSdkAutoConstructList.getInstance();

        private List<String> statelessDefaultActions = DefaultSdkAutoConstructList.getInstance();

        private List<String> statelessFragmentDefaultActions = DefaultSdkAutoConstructList.getInstance();

        private List<CustomAction> statelessCustomActions = DefaultSdkAutoConstructList.getInstance();

        private List<StatefulRuleGroupReference> statefulRuleGroupReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallPolicy model) {
            statelessRuleGroupReferences(model.statelessRuleGroupReferences);
            statelessDefaultActions(model.statelessDefaultActions);
            statelessFragmentDefaultActions(model.statelessFragmentDefaultActions);
            statelessCustomActions(model.statelessCustomActions);
            statefulRuleGroupReferences(model.statefulRuleGroupReferences);
        }

        public final Collection<StatelessRuleGroupReference.Builder> getStatelessRuleGroupReferences() {
            if (statelessRuleGroupReferences instanceof SdkAutoConstructList) {
                return null;
            }
            return statelessRuleGroupReferences != null ? statelessRuleGroupReferences.stream()
                    .map(StatelessRuleGroupReference::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statelessRuleGroupReferences(Collection<StatelessRuleGroupReference> statelessRuleGroupReferences) {
            this.statelessRuleGroupReferences = StatelessRuleGroupReferencesCopier.copy(statelessRuleGroupReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessRuleGroupReferences(StatelessRuleGroupReference... statelessRuleGroupReferences) {
            statelessRuleGroupReferences(Arrays.asList(statelessRuleGroupReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessRuleGroupReferences(
                Consumer<StatelessRuleGroupReference.Builder>... statelessRuleGroupReferences) {
            statelessRuleGroupReferences(Stream.of(statelessRuleGroupReferences)
                    .map(c -> StatelessRuleGroupReference.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStatelessRuleGroupReferences(
                Collection<StatelessRuleGroupReference.BuilderImpl> statelessRuleGroupReferences) {
            this.statelessRuleGroupReferences = StatelessRuleGroupReferencesCopier.copyFromBuilder(statelessRuleGroupReferences);
        }

        public final Collection<String> getStatelessDefaultActions() {
            if (statelessDefaultActions instanceof SdkAutoConstructList) {
                return null;
            }
            return statelessDefaultActions;
        }

        @Override
        public final Builder statelessDefaultActions(Collection<String> statelessDefaultActions) {
            this.statelessDefaultActions = StatelessActionsCopier.copy(statelessDefaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessDefaultActions(String... statelessDefaultActions) {
            statelessDefaultActions(Arrays.asList(statelessDefaultActions));
            return this;
        }

        public final void setStatelessDefaultActions(Collection<String> statelessDefaultActions) {
            this.statelessDefaultActions = StatelessActionsCopier.copy(statelessDefaultActions);
        }

        public final Collection<String> getStatelessFragmentDefaultActions() {
            if (statelessFragmentDefaultActions instanceof SdkAutoConstructList) {
                return null;
            }
            return statelessFragmentDefaultActions;
        }

        @Override
        public final Builder statelessFragmentDefaultActions(Collection<String> statelessFragmentDefaultActions) {
            this.statelessFragmentDefaultActions = StatelessActionsCopier.copy(statelessFragmentDefaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessFragmentDefaultActions(String... statelessFragmentDefaultActions) {
            statelessFragmentDefaultActions(Arrays.asList(statelessFragmentDefaultActions));
            return this;
        }

        public final void setStatelessFragmentDefaultActions(Collection<String> statelessFragmentDefaultActions) {
            this.statelessFragmentDefaultActions = StatelessActionsCopier.copy(statelessFragmentDefaultActions);
        }

        public final Collection<CustomAction.Builder> getStatelessCustomActions() {
            if (statelessCustomActions instanceof SdkAutoConstructList) {
                return null;
            }
            return statelessCustomActions != null ? statelessCustomActions.stream().map(CustomAction::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statelessCustomActions(Collection<CustomAction> statelessCustomActions) {
            this.statelessCustomActions = CustomActionsCopier.copy(statelessCustomActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessCustomActions(CustomAction... statelessCustomActions) {
            statelessCustomActions(Arrays.asList(statelessCustomActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessCustomActions(Consumer<CustomAction.Builder>... statelessCustomActions) {
            statelessCustomActions(Stream.of(statelessCustomActions).map(c -> CustomAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStatelessCustomActions(Collection<CustomAction.BuilderImpl> statelessCustomActions) {
            this.statelessCustomActions = CustomActionsCopier.copyFromBuilder(statelessCustomActions);
        }

        public final Collection<StatefulRuleGroupReference.Builder> getStatefulRuleGroupReferences() {
            if (statefulRuleGroupReferences instanceof SdkAutoConstructList) {
                return null;
            }
            return statefulRuleGroupReferences != null ? statefulRuleGroupReferences.stream()
                    .map(StatefulRuleGroupReference::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statefulRuleGroupReferences(Collection<StatefulRuleGroupReference> statefulRuleGroupReferences) {
            this.statefulRuleGroupReferences = StatefulRuleGroupReferencesCopier.copy(statefulRuleGroupReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulRuleGroupReferences(StatefulRuleGroupReference... statefulRuleGroupReferences) {
            statefulRuleGroupReferences(Arrays.asList(statefulRuleGroupReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulRuleGroupReferences(
                Consumer<StatefulRuleGroupReference.Builder>... statefulRuleGroupReferences) {
            statefulRuleGroupReferences(Stream.of(statefulRuleGroupReferences)
                    .map(c -> StatefulRuleGroupReference.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStatefulRuleGroupReferences(
                Collection<StatefulRuleGroupReference.BuilderImpl> statefulRuleGroupReferences) {
            this.statefulRuleGroupReferences = StatefulRuleGroupReferencesCopier.copyFromBuilder(statefulRuleGroupReferences);
        }

        @Override
        public FirewallPolicy build() {
            return new FirewallPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
