/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration and status for a single subnet that you've specified for use by the AWS Network Firewall firewall.
 * This is part of the <a>FirewallStatus</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Attachment implements SdkPojo, Serializable, ToCopyableBuilder<Attachment.Builder, Attachment> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(Attachment::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(Attachment::endpointId)).setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Attachment::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD,
            ENDPOINT_ID_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String subnetId;

    private final String endpointId;

    private final String status;

    private Attachment(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.endpointId = builder.endpointId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique identifier of the subnet that you've specified to be used for a firewall endpoint.
     * </p>
     * 
     * @return The unique identifier of the subnet that you've specified to be used for a firewall endpoint.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The identifier of the firewall endpoint that Network Firewall has instantiated in the subnet. You use this to
     * identify the firewall endpoint in the VPC route tables, when you redirect the VPC traffic through the endpoint.
     * </p>
     * 
     * @return The identifier of the firewall endpoint that Network Firewall has instantiated in the subnet. You use
     *         this to identify the firewall endpoint in the VPC route tables, when you redirect the VPC traffic through
     *         the endpoint.
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * <p>
     * The current status of the firewall endpoint in the subnet. This value reflects both the instantiation of the
     * endpoint in the VPC subnet and the sync states that are reported in the <code>Config</code> settings. When this
     * value is <code>READY</code>, the endpoint is available and configured properly to handle network traffic. When
     * the endpoint isn't available for traffic, this value will reflect its state, for example <code>CREATING</code>,
     * <code>DELETING</code>, or <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the firewall endpoint in the subnet. This value reflects both the instantiation of
     *         the endpoint in the VPC subnet and the sync states that are reported in the <code>Config</code> settings.
     *         When this value is <code>READY</code>, the endpoint is available and configured properly to handle
     *         network traffic. When the endpoint isn't available for traffic, this value will reflect its state, for
     *         example <code>CREATING</code>, <code>DELETING</code>, or <code>FAILED</code>.
     * @see AttachmentStatus
     */
    public final AttachmentStatus status() {
        return AttachmentStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the firewall endpoint in the subnet. This value reflects both the instantiation of the
     * endpoint in the VPC subnet and the sync states that are reported in the <code>Config</code> settings. When this
     * value is <code>READY</code>, the endpoint is available and configured properly to handle network traffic. When
     * the endpoint isn't available for traffic, this value will reflect its state, for example <code>CREATING</code>,
     * <code>DELETING</code>, or <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the firewall endpoint in the subnet. This value reflects both the instantiation of
     *         the endpoint in the VPC subnet and the sync states that are reported in the <code>Config</code> settings.
     *         When this value is <code>READY</code>, the endpoint is available and configured properly to handle
     *         network traffic. When the endpoint isn't available for traffic, this value will reflect its state, for
     *         example <code>CREATING</code>, <code>DELETING</code>, or <code>FAILED</code>.
     * @see AttachmentStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment) obj;
        return Objects.equals(subnetId(), other.subnetId()) && Objects.equals(endpointId(), other.endpointId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Attachment").add("SubnetId", subnetId()).add("EndpointId", endpointId())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Attachment, T> g) {
        return obj -> g.apply((Attachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Attachment> {
        /**
         * <p>
         * The unique identifier of the subnet that you've specified to be used for a firewall endpoint.
         * </p>
         * 
         * @param subnetId
         *        The unique identifier of the subnet that you've specified to be used for a firewall endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The identifier of the firewall endpoint that Network Firewall has instantiated in the subnet. You use this to
         * identify the firewall endpoint in the VPC route tables, when you redirect the VPC traffic through the
         * endpoint.
         * </p>
         * 
         * @param endpointId
         *        The identifier of the firewall endpoint that Network Firewall has instantiated in the subnet. You use
         *        this to identify the firewall endpoint in the VPC route tables, when you redirect the VPC traffic
         *        through the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * The current status of the firewall endpoint in the subnet. This value reflects both the instantiation of the
         * endpoint in the VPC subnet and the sync states that are reported in the <code>Config</code> settings. When
         * this value is <code>READY</code>, the endpoint is available and configured properly to handle network
         * traffic. When the endpoint isn't available for traffic, this value will reflect its state, for example
         * <code>CREATING</code>, <code>DELETING</code>, or <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The current status of the firewall endpoint in the subnet. This value reflects both the instantiation
         *        of the endpoint in the VPC subnet and the sync states that are reported in the <code>Config</code>
         *        settings. When this value is <code>READY</code>, the endpoint is available and configured properly to
         *        handle network traffic. When the endpoint isn't available for traffic, this value will reflect its
         *        state, for example <code>CREATING</code>, <code>DELETING</code>, or <code>FAILED</code>.
         * @see AttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the firewall endpoint in the subnet. This value reflects both the instantiation of the
         * endpoint in the VPC subnet and the sync states that are reported in the <code>Config</code> settings. When
         * this value is <code>READY</code>, the endpoint is available and configured properly to handle network
         * traffic. When the endpoint isn't available for traffic, this value will reflect its state, for example
         * <code>CREATING</code>, <code>DELETING</code>, or <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The current status of the firewall endpoint in the subnet. This value reflects both the instantiation
         *        of the endpoint in the VPC subnet and the sync states that are reported in the <code>Config</code>
         *        settings. When this value is <code>READY</code>, the endpoint is available and configured properly to
         *        handle network traffic. When the endpoint isn't available for traffic, this value will reflect its
         *        state, for example <code>CREATING</code>, <code>DELETING</code>, or <code>FAILED</code>.
         * @see AttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentStatus
         */
        Builder status(AttachmentStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String subnetId;

        private String endpointId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Attachment model) {
            subnetId(model.subnetId);
            endpointId(model.endpointId);
            status(model.status);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getEndpointId() {
            return endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AttachmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Attachment build() {
            return new Attachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
