/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import software.amazon.awssdk.http.nio.netty.internal.FutureCancelledException;
import software.amazon.awssdk.http.nio.netty.internal.RequestContext;

@SdkInternalApi
public class FutureCancelHandler
extends SimpleChannelInboundHandler {
    protected void channelRead0(ChannelHandlerContext ctx, Object o) throws Exception {
        ReferenceCountUtil.retain((Object)o);
        ctx.fireChannelRead(o);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        if (this.cancelled(ctx, e)) {
            RequestContext requestContext = (RequestContext)ctx.channel().attr(ChannelAttributeKey.REQUEST_CONTEXT_KEY).get();
            requestContext.handler().onError(e);
            ctx.fireExceptionCaught((Throwable)new IOException("Request cancelled"));
            ctx.close();
            requestContext.channelPool().release(ctx.channel());
        } else {
            ctx.fireExceptionCaught(e);
        }
    }

    private boolean cancelled(ChannelHandlerContext ctx, Throwable t) {
        if (!(t instanceof FutureCancelledException)) {
            return false;
        }
        FutureCancelledException e = (FutureCancelledException)t;
        return e.getExecutionId() == ((Long)ctx.channel().attr(ChannelAttributeKey.EXECUTION_ID_KEY).get()).longValue();
    }
}

