/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.QuerySummary;
import software.amazon.awssdk.services.neptunegraph.model.QuerySummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueriesResponse
extends NeptuneGraphResponse
implements ToCopyableBuilder<Builder, ListQueriesResponse> {
    private static final SdkField<List<QuerySummary>> QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("queries").getter(ListQueriesResponse.getter(ListQueriesResponse::queries)).setter(ListQueriesResponse.setter(Builder::queries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QuerySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListQueriesResponse.memberNameToFieldInitializer();
    private final List<QuerySummary> queries;

    private ListQueriesResponse(BuilderImpl builder) {
        super(builder);
        this.queries = builder.queries;
    }

    public final boolean hasQueries() {
        return this.queries != null && !(this.queries instanceof SdkAutoConstructList);
    }

    public final List<QuerySummary> queries() {
        return this.queries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueries() ? this.queries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueriesResponse)) {
            return false;
        }
        ListQueriesResponse other = (ListQueriesResponse)((Object)obj);
        return this.hasQueries() == other.hasQueries() && Objects.equals(this.queries(), other.queries());
    }

    public final String toString() {
        return ToString.builder((String)"ListQueriesResponse").add("Queries", this.hasQueries() ? this.queries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queries": {
                return Optional.ofNullable(clazz.cast(this.queries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<QuerySummary>>> map = new HashMap<String, SdkField<List<QuerySummary>>>();
        map.put("queries", QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQueriesResponse, T> g) {
        return obj -> g.apply((ListQueriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphResponse.BuilderImpl
    implements Builder {
        private List<QuerySummary> queries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueriesResponse model) {
            super(model);
            this.queries(model.queries);
        }

        public final List<QuerySummary.Builder> getQueries() {
            List<QuerySummary.Builder> result = QuerySummaryListCopier.copyToBuilder(this.queries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueries(Collection<QuerySummary.BuilderImpl> queries) {
            this.queries = QuerySummaryListCopier.copyFromBuilder(queries);
        }

        @Override
        public final Builder queries(Collection<QuerySummary> queries) {
            this.queries = QuerySummaryListCopier.copy(queries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(QuerySummary ... queries) {
            this.queries(Arrays.asList(queries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(Consumer<QuerySummary.Builder> ... queries) {
            this.queries(Stream.of(queries).map(c -> (QuerySummary)((QuerySummary.Builder)QuerySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListQueriesResponse build() {
            return new ListQueriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptuneGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQueriesResponse> {
        public Builder queries(Collection<QuerySummary> var1);

        public Builder queries(QuerySummary ... var1);

        public Builder queries(Consumer<QuerySummary.Builder> ... var1);
    }
}

