/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphClient;
import software.amazon.awssdk.services.neptunegraph.internal.UserAgentUtils;
import software.amazon.awssdk.services.neptunegraph.model.ExportTaskSummary;
import software.amazon.awssdk.services.neptunegraph.model.ListExportTasksRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListExportTasksResponse;

public class ListExportTasksIterable
implements SdkIterable<ListExportTasksResponse> {
    private final NeptuneGraphClient client;
    private final ListExportTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExportTasksIterable(NeptuneGraphClient client, ListExportTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListExportTasksResponseFetcher();
    }

    public Iterator<ListExportTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExportTaskSummary> tasks() {
        Function<ListExportTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tasks() != null) {
                return response.tasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListExportTasksResponseFetcher
    implements SyncPageFetcher<ListExportTasksResponse> {
        private ListExportTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListExportTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExportTasksResponse nextPage(ListExportTasksResponse previousPage) {
            if (previousPage == null) {
                return ListExportTasksIterable.this.client.listExportTasks(ListExportTasksIterable.this.firstRequest);
            }
            return ListExportTasksIterable.this.client.listExportTasks((ListExportTasksRequest)((Object)ListExportTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

