/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphAsyncClient;
import software.amazon.awssdk.services.neptunegraph.internal.UserAgentUtils;
import software.amazon.awssdk.services.neptunegraph.model.ImportTaskSummary;
import software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListImportTasksResponse;

public class ListImportTasksPublisher
implements SdkPublisher<ListImportTasksResponse> {
    private final NeptuneGraphAsyncClient client;
    private final ListImportTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImportTasksPublisher(NeptuneGraphAsyncClient client, ListImportTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImportTasksPublisher(NeptuneGraphAsyncClient client, ListImportTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImportTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImportTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImportTaskSummary> tasks() {
        Function<ListImportTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tasks() != null) {
                return response.tasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListImportTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListImportTasksResponseFetcher
    implements AsyncPageFetcher<ListImportTasksResponse> {
        private ListImportTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListImportTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImportTasksResponse> nextPage(ListImportTasksResponse previousPage) {
            if (previousPage == null) {
                return ListImportTasksPublisher.this.client.listImportTasks(ListImportTasksPublisher.this.firstRequest);
            }
            return ListImportTasksPublisher.this.client.listImportTasks((ListImportTasksRequest)((Object)ListImportTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

