/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunegraph.model.GraphDataSummary;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGraphSummaryResponse
extends NeptuneGraphResponse
implements ToCopyableBuilder<Builder, GetGraphSummaryResponse> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(GetGraphSummaryResponse.getter(GetGraphSummaryResponse::version)).setter(GetGraphSummaryResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<Instant> LAST_STATISTICS_COMPUTATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStatisticsComputationTime").getter(GetGraphSummaryResponse.getter(GetGraphSummaryResponse::lastStatisticsComputationTime)).setter(GetGraphSummaryResponse.setter(Builder::lastStatisticsComputationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatisticsComputationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<GraphDataSummary> GRAPH_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("graphSummary").getter(GetGraphSummaryResponse.getter(GetGraphSummaryResponse::graphSummary)).setter(GetGraphSummaryResponse.setter(Builder::graphSummary)).constructor(GraphDataSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, LAST_STATISTICS_COMPUTATION_TIME_FIELD, GRAPH_SUMMARY_FIELD));
    private final String version;
    private final Instant lastStatisticsComputationTime;
    private final GraphDataSummary graphSummary;

    private GetGraphSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.version = builder.version;
        this.lastStatisticsComputationTime = builder.lastStatisticsComputationTime;
        this.graphSummary = builder.graphSummary;
    }

    public final String version() {
        return this.version;
    }

    public final Instant lastStatisticsComputationTime() {
        return this.lastStatisticsComputationTime;
    }

    public final GraphDataSummary graphSummary() {
        return this.graphSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatisticsComputationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.graphSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGraphSummaryResponse)) {
            return false;
        }
        GetGraphSummaryResponse other = (GetGraphSummaryResponse)((Object)obj);
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.lastStatisticsComputationTime(), other.lastStatisticsComputationTime()) && Objects.equals(this.graphSummary(), other.graphSummary());
    }

    public final String toString() {
        return ToString.builder((String)"GetGraphSummaryResponse").add("Version", (Object)this.version()).add("LastStatisticsComputationTime", (Object)this.lastStatisticsComputationTime()).add("GraphSummary", (Object)this.graphSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "lastStatisticsComputationTime": {
                return Optional.ofNullable(clazz.cast(this.lastStatisticsComputationTime()));
            }
            case "graphSummary": {
                return Optional.ofNullable(clazz.cast(this.graphSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGraphSummaryResponse, T> g) {
        return obj -> g.apply((GetGraphSummaryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphResponse.BuilderImpl
    implements Builder {
        private String version;
        private Instant lastStatisticsComputationTime;
        private GraphDataSummary graphSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGraphSummaryResponse model) {
            super(model);
            this.version(model.version);
            this.lastStatisticsComputationTime(model.lastStatisticsComputationTime);
            this.graphSummary(model.graphSummary);
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getLastStatisticsComputationTime() {
            return this.lastStatisticsComputationTime;
        }

        public final void setLastStatisticsComputationTime(Instant lastStatisticsComputationTime) {
            this.lastStatisticsComputationTime = lastStatisticsComputationTime;
        }

        @Override
        public final Builder lastStatisticsComputationTime(Instant lastStatisticsComputationTime) {
            this.lastStatisticsComputationTime = lastStatisticsComputationTime;
            return this;
        }

        public final GraphDataSummary.Builder getGraphSummary() {
            return this.graphSummary != null ? this.graphSummary.toBuilder() : null;
        }

        public final void setGraphSummary(GraphDataSummary.BuilderImpl graphSummary) {
            this.graphSummary = graphSummary != null ? graphSummary.build() : null;
        }

        @Override
        public final Builder graphSummary(GraphDataSummary graphSummary) {
            this.graphSummary = graphSummary;
            return this;
        }

        @Override
        public GetGraphSummaryResponse build() {
            return new GetGraphSummaryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptuneGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGraphSummaryResponse> {
        public Builder version(String var1);

        public Builder lastStatisticsComputationTime(Instant var1);

        public Builder graphSummary(GraphDataSummary var1);

        default public Builder graphSummary(Consumer<GraphDataSummary.Builder> graphSummary) {
            return this.graphSummary((GraphDataSummary)((GraphDataSummary.Builder)GraphDataSummary.builder().applyMutation(graphSummary)).build());
        }
    }
}

