/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.endpoints;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class NeptuneGraphEndpointParams
implements ToCopyableBuilder<Builder, NeptuneGraphEndpointParams> {
    private final Region region;
    private final Boolean useFIPS;
    private final Boolean useDualStack;
    private final String endpoint;
    private final String apiType;

    private NeptuneGraphEndpointParams(BuilderImpl builder) {
        this.region = builder.region;
        this.useFIPS = builder.useFIPS;
        this.useDualStack = builder.useDualStack;
        this.endpoint = builder.endpoint;
        this.apiType = builder.apiType;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Region region() {
        return this.region;
    }

    public Boolean useFips() {
        return this.useFIPS;
    }

    public Boolean useDualStack() {
        return this.useDualStack;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String apiType() {
        return this.apiType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    private static class BuilderImpl
    implements Builder {
        private Region region;
        private Boolean useFIPS = false;
        private Boolean useDualStack = false;
        private String endpoint;
        private String apiType;

        private BuilderImpl() {
        }

        private BuilderImpl(NeptuneGraphEndpointParams builder) {
            this.region = builder.region;
            this.useFIPS = builder.useFIPS;
            this.useDualStack = builder.useDualStack;
            this.endpoint = builder.endpoint;
            this.apiType = builder.apiType;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder useDualStack(Boolean useDualStack) {
            this.useDualStack = useDualStack;
            if (this.useDualStack == null) {
                this.useDualStack = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder apiType(String apiType) {
            this.apiType = apiType;
            return this;
        }

        @Override
        public NeptuneGraphEndpointParams build() {
            return new NeptuneGraphEndpointParams(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NeptuneGraphEndpointParams> {
        public Builder region(Region var1);

        public Builder useFips(Boolean var1);

        public Builder useDualStack(Boolean var1);

        public Builder endpoint(String var1);

        public Builder apiType(String var1);

        public NeptuneGraphEndpointParams build();
    }
}

