/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.neptunegraph.DefaultNeptuneGraphClientBuilder;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphClientBuilder;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphServiceClientConfiguration;
import software.amazon.awssdk.services.neptunegraph.model.AccessDeniedException;
import software.amazon.awssdk.services.neptunegraph.model.CancelImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.CancelImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.CancelQueryRequest;
import software.amazon.awssdk.services.neptunegraph.model.CancelQueryResponse;
import software.amazon.awssdk.services.neptunegraph.model.ConflictException;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphUsingImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphUsingImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.CreatePrivateGraphEndpointRequest;
import software.amazon.awssdk.services.neptunegraph.model.CreatePrivateGraphEndpointResponse;
import software.amazon.awssdk.services.neptunegraph.model.DeleteGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.DeleteGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.DeleteGraphSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.DeleteGraphSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.DeletePrivateGraphEndpointRequest;
import software.amazon.awssdk.services.neptunegraph.model.DeletePrivateGraphEndpointResponse;
import software.amazon.awssdk.services.neptunegraph.model.ExecuteQueryRequest;
import software.amazon.awssdk.services.neptunegraph.model.ExecuteQueryResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSummaryRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSummaryResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetQueryRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetQueryResponse;
import software.amazon.awssdk.services.neptunegraph.model.InternalServerException;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphsResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListImportTasksResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListQueriesRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListQueriesResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphException;
import software.amazon.awssdk.services.neptunegraph.model.ResetGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.ResetGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.ResourceNotFoundException;
import software.amazon.awssdk.services.neptunegraph.model.RestoreGraphFromSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.RestoreGraphFromSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.neptunegraph.model.StartImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.StartImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.TagResourceRequest;
import software.amazon.awssdk.services.neptunegraph.model.TagResourceResponse;
import software.amazon.awssdk.services.neptunegraph.model.ThrottlingException;
import software.amazon.awssdk.services.neptunegraph.model.UnprocessableException;
import software.amazon.awssdk.services.neptunegraph.model.UntagResourceRequest;
import software.amazon.awssdk.services.neptunegraph.model.UntagResourceResponse;
import software.amazon.awssdk.services.neptunegraph.model.UpdateGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.UpdateGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.ValidationException;
import software.amazon.awssdk.services.neptunegraph.paginators.ListGraphSnapshotsIterable;
import software.amazon.awssdk.services.neptunegraph.paginators.ListGraphsIterable;
import software.amazon.awssdk.services.neptunegraph.paginators.ListImportTasksIterable;
import software.amazon.awssdk.services.neptunegraph.paginators.ListPrivateGraphEndpointsIterable;
import software.amazon.awssdk.services.neptunegraph.waiters.NeptuneGraphWaiter;

@SdkPublicApi
@ThreadSafe
public interface NeptuneGraphClient
extends AwsClient {
    public static final String SERVICE_NAME = "neptune-graph";
    public static final String SERVICE_METADATA_ID = "neptune-graph";

    default public CancelImportTaskResponse cancelImportTask(CancelImportTaskRequest cancelImportTaskRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public CancelImportTaskResponse cancelImportTask(Consumer<CancelImportTaskRequest.Builder> cancelImportTaskRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.cancelImportTask((CancelImportTaskRequest)((Object)((CancelImportTaskRequest.Builder)CancelImportTaskRequest.builder().applyMutation(cancelImportTaskRequest)).build()));
    }

    default public CancelQueryResponse cancelQuery(CancelQueryRequest cancelQueryRequest) throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public CancelQueryResponse cancelQuery(Consumer<CancelQueryRequest.Builder> cancelQueryRequest) throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.cancelQuery((CancelQueryRequest)((Object)((CancelQueryRequest.Builder)CancelQueryRequest.builder().applyMutation(cancelQueryRequest)).build()));
    }

    default public CreateGraphResponse createGraph(CreateGraphRequest createGraphRequest) throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public CreateGraphResponse createGraph(Consumer<CreateGraphRequest.Builder> createGraphRequest) throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.createGraph((CreateGraphRequest)((Object)((CreateGraphRequest.Builder)CreateGraphRequest.builder().applyMutation(createGraphRequest)).build()));
    }

    default public CreateGraphSnapshotResponse createGraphSnapshot(CreateGraphSnapshotRequest createGraphSnapshotRequest) throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public CreateGraphSnapshotResponse createGraphSnapshot(Consumer<CreateGraphSnapshotRequest.Builder> createGraphSnapshotRequest) throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.createGraphSnapshot((CreateGraphSnapshotRequest)((Object)((CreateGraphSnapshotRequest.Builder)CreateGraphSnapshotRequest.builder().applyMutation(createGraphSnapshotRequest)).build()));
    }

    default public CreateGraphUsingImportTaskResponse createGraphUsingImportTask(CreateGraphUsingImportTaskRequest createGraphUsingImportTaskRequest) throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public CreateGraphUsingImportTaskResponse createGraphUsingImportTask(Consumer<CreateGraphUsingImportTaskRequest.Builder> createGraphUsingImportTaskRequest) throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.createGraphUsingImportTask((CreateGraphUsingImportTaskRequest)((Object)((CreateGraphUsingImportTaskRequest.Builder)CreateGraphUsingImportTaskRequest.builder().applyMutation(createGraphUsingImportTaskRequest)).build()));
    }

    default public CreatePrivateGraphEndpointResponse createPrivateGraphEndpoint(CreatePrivateGraphEndpointRequest createPrivateGraphEndpointRequest) throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public CreatePrivateGraphEndpointResponse createPrivateGraphEndpoint(Consumer<CreatePrivateGraphEndpointRequest.Builder> createPrivateGraphEndpointRequest) throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.createPrivateGraphEndpoint((CreatePrivateGraphEndpointRequest)((Object)((CreatePrivateGraphEndpointRequest.Builder)CreatePrivateGraphEndpointRequest.builder().applyMutation(createPrivateGraphEndpointRequest)).build()));
    }

    default public DeleteGraphResponse deleteGraph(DeleteGraphRequest deleteGraphRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public DeleteGraphResponse deleteGraph(Consumer<DeleteGraphRequest.Builder> deleteGraphRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.deleteGraph((DeleteGraphRequest)((Object)((DeleteGraphRequest.Builder)DeleteGraphRequest.builder().applyMutation(deleteGraphRequest)).build()));
    }

    default public DeleteGraphSnapshotResponse deleteGraphSnapshot(DeleteGraphSnapshotRequest deleteGraphSnapshotRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public DeleteGraphSnapshotResponse deleteGraphSnapshot(Consumer<DeleteGraphSnapshotRequest.Builder> deleteGraphSnapshotRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.deleteGraphSnapshot((DeleteGraphSnapshotRequest)((Object)((DeleteGraphSnapshotRequest.Builder)DeleteGraphSnapshotRequest.builder().applyMutation(deleteGraphSnapshotRequest)).build()));
    }

    default public DeletePrivateGraphEndpointResponse deletePrivateGraphEndpoint(DeletePrivateGraphEndpointRequest deletePrivateGraphEndpointRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public DeletePrivateGraphEndpointResponse deletePrivateGraphEndpoint(Consumer<DeletePrivateGraphEndpointRequest.Builder> deletePrivateGraphEndpointRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.deletePrivateGraphEndpoint((DeletePrivateGraphEndpointRequest)((Object)((DeletePrivateGraphEndpointRequest.Builder)DeletePrivateGraphEndpointRequest.builder().applyMutation(deletePrivateGraphEndpointRequest)).build()));
    }

    default public <ReturnT> ReturnT executeQuery(ExecuteQueryRequest executeQueryRequest, ResponseTransformer<ExecuteQueryResponse, ReturnT> responseTransformer) throws UnprocessableException, ThrottlingException, ValidationException, ConflictException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT executeQuery(Consumer<ExecuteQueryRequest.Builder> executeQueryRequest, ResponseTransformer<ExecuteQueryResponse, ReturnT> responseTransformer) throws UnprocessableException, ThrottlingException, ValidationException, ConflictException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.executeQuery((ExecuteQueryRequest)((Object)((ExecuteQueryRequest.Builder)ExecuteQueryRequest.builder().applyMutation(executeQueryRequest)).build()), responseTransformer);
    }

    default public ExecuteQueryResponse executeQuery(ExecuteQueryRequest executeQueryRequest, Path destinationPath) throws UnprocessableException, ThrottlingException, ValidationException, ConflictException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return (ExecuteQueryResponse)((Object)this.executeQuery(executeQueryRequest, ResponseTransformer.toFile((Path)destinationPath)));
    }

    default public ExecuteQueryResponse executeQuery(Consumer<ExecuteQueryRequest.Builder> executeQueryRequest, Path destinationPath) throws UnprocessableException, ThrottlingException, ValidationException, ConflictException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.executeQuery((ExecuteQueryRequest)((Object)((ExecuteQueryRequest.Builder)ExecuteQueryRequest.builder().applyMutation(executeQueryRequest)).build()), destinationPath);
    }

    default public ResponseInputStream<ExecuteQueryResponse> executeQuery(ExecuteQueryRequest executeQueryRequest) throws UnprocessableException, ThrottlingException, ValidationException, ConflictException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return (ResponseInputStream)this.executeQuery(executeQueryRequest, ResponseTransformer.toInputStream());
    }

    default public ResponseInputStream<ExecuteQueryResponse> executeQuery(Consumer<ExecuteQueryRequest.Builder> executeQueryRequest) throws UnprocessableException, ThrottlingException, ValidationException, ConflictException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.executeQuery((ExecuteQueryRequest)((Object)((ExecuteQueryRequest.Builder)ExecuteQueryRequest.builder().applyMutation(executeQueryRequest)).build()));
    }

    default public ResponseBytes<ExecuteQueryResponse> executeQueryAsBytes(ExecuteQueryRequest executeQueryRequest) throws UnprocessableException, ThrottlingException, ValidationException, ConflictException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return (ResponseBytes)this.executeQuery(executeQueryRequest, ResponseTransformer.toBytes());
    }

    default public ResponseBytes<ExecuteQueryResponse> executeQueryAsBytes(Consumer<ExecuteQueryRequest.Builder> executeQueryRequest) throws UnprocessableException, ThrottlingException, ValidationException, ConflictException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.executeQueryAsBytes((ExecuteQueryRequest)((Object)((ExecuteQueryRequest.Builder)ExecuteQueryRequest.builder().applyMutation(executeQueryRequest)).build()));
    }

    default public GetGraphResponse getGraph(GetGraphRequest getGraphRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public GetGraphResponse getGraph(Consumer<GetGraphRequest.Builder> getGraphRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.getGraph((GetGraphRequest)((Object)((GetGraphRequest.Builder)GetGraphRequest.builder().applyMutation(getGraphRequest)).build()));
    }

    default public GetGraphSnapshotResponse getGraphSnapshot(GetGraphSnapshotRequest getGraphSnapshotRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public GetGraphSnapshotResponse getGraphSnapshot(Consumer<GetGraphSnapshotRequest.Builder> getGraphSnapshotRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.getGraphSnapshot((GetGraphSnapshotRequest)((Object)((GetGraphSnapshotRequest.Builder)GetGraphSnapshotRequest.builder().applyMutation(getGraphSnapshotRequest)).build()));
    }

    default public GetGraphSummaryResponse getGraphSummary(GetGraphSummaryRequest getGraphSummaryRequest) throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public GetGraphSummaryResponse getGraphSummary(Consumer<GetGraphSummaryRequest.Builder> getGraphSummaryRequest) throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.getGraphSummary((GetGraphSummaryRequest)((Object)((GetGraphSummaryRequest.Builder)GetGraphSummaryRequest.builder().applyMutation(getGraphSummaryRequest)).build()));
    }

    default public GetImportTaskResponse getImportTask(GetImportTaskRequest getImportTaskRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public GetImportTaskResponse getImportTask(Consumer<GetImportTaskRequest.Builder> getImportTaskRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.getImportTask((GetImportTaskRequest)((Object)((GetImportTaskRequest.Builder)GetImportTaskRequest.builder().applyMutation(getImportTaskRequest)).build()));
    }

    default public GetPrivateGraphEndpointResponse getPrivateGraphEndpoint(GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public GetPrivateGraphEndpointResponse getPrivateGraphEndpoint(Consumer<GetPrivateGraphEndpointRequest.Builder> getPrivateGraphEndpointRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.getPrivateGraphEndpoint((GetPrivateGraphEndpointRequest)((Object)((GetPrivateGraphEndpointRequest.Builder)GetPrivateGraphEndpointRequest.builder().applyMutation(getPrivateGraphEndpointRequest)).build()));
    }

    default public GetQueryResponse getQuery(GetQueryRequest getQueryRequest) throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public GetQueryResponse getQuery(Consumer<GetQueryRequest.Builder> getQueryRequest) throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.getQuery((GetQueryRequest)((Object)((GetQueryRequest.Builder)GetQueryRequest.builder().applyMutation(getQueryRequest)).build()));
    }

    default public ListGraphSnapshotsResponse listGraphSnapshots(ListGraphSnapshotsRequest listGraphSnapshotsRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public ListGraphSnapshotsResponse listGraphSnapshots(Consumer<ListGraphSnapshotsRequest.Builder> listGraphSnapshotsRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.listGraphSnapshots((ListGraphSnapshotsRequest)((Object)((ListGraphSnapshotsRequest.Builder)ListGraphSnapshotsRequest.builder().applyMutation(listGraphSnapshotsRequest)).build()));
    }

    default public ListGraphSnapshotsIterable listGraphSnapshotsPaginator(ListGraphSnapshotsRequest listGraphSnapshotsRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return new ListGraphSnapshotsIterable(this, listGraphSnapshotsRequest);
    }

    default public ListGraphSnapshotsIterable listGraphSnapshotsPaginator(Consumer<ListGraphSnapshotsRequest.Builder> listGraphSnapshotsRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.listGraphSnapshotsPaginator((ListGraphSnapshotsRequest)((Object)((ListGraphSnapshotsRequest.Builder)ListGraphSnapshotsRequest.builder().applyMutation(listGraphSnapshotsRequest)).build()));
    }

    default public ListGraphsResponse listGraphs(ListGraphsRequest listGraphsRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public ListGraphsResponse listGraphs(Consumer<ListGraphsRequest.Builder> listGraphsRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.listGraphs((ListGraphsRequest)((Object)((ListGraphsRequest.Builder)ListGraphsRequest.builder().applyMutation(listGraphsRequest)).build()));
    }

    default public ListGraphsIterable listGraphsPaginator(ListGraphsRequest listGraphsRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return new ListGraphsIterable(this, listGraphsRequest);
    }

    default public ListGraphsIterable listGraphsPaginator(Consumer<ListGraphsRequest.Builder> listGraphsRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.listGraphsPaginator((ListGraphsRequest)((Object)((ListGraphsRequest.Builder)ListGraphsRequest.builder().applyMutation(listGraphsRequest)).build()));
    }

    default public ListImportTasksResponse listImportTasks(ListImportTasksRequest listImportTasksRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public ListImportTasksResponse listImportTasks(Consumer<ListImportTasksRequest.Builder> listImportTasksRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.listImportTasks((ListImportTasksRequest)((Object)((ListImportTasksRequest.Builder)ListImportTasksRequest.builder().applyMutation(listImportTasksRequest)).build()));
    }

    default public ListImportTasksIterable listImportTasksPaginator(ListImportTasksRequest listImportTasksRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return new ListImportTasksIterable(this, listImportTasksRequest);
    }

    default public ListImportTasksIterable listImportTasksPaginator(Consumer<ListImportTasksRequest.Builder> listImportTasksRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.listImportTasksPaginator((ListImportTasksRequest)((Object)((ListImportTasksRequest.Builder)ListImportTasksRequest.builder().applyMutation(listImportTasksRequest)).build()));
    }

    default public ListPrivateGraphEndpointsResponse listPrivateGraphEndpoints(ListPrivateGraphEndpointsRequest listPrivateGraphEndpointsRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public ListPrivateGraphEndpointsResponse listPrivateGraphEndpoints(Consumer<ListPrivateGraphEndpointsRequest.Builder> listPrivateGraphEndpointsRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.listPrivateGraphEndpoints((ListPrivateGraphEndpointsRequest)((Object)((ListPrivateGraphEndpointsRequest.Builder)ListPrivateGraphEndpointsRequest.builder().applyMutation(listPrivateGraphEndpointsRequest)).build()));
    }

    default public ListPrivateGraphEndpointsIterable listPrivateGraphEndpointsPaginator(ListPrivateGraphEndpointsRequest listPrivateGraphEndpointsRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return new ListPrivateGraphEndpointsIterable(this, listPrivateGraphEndpointsRequest);
    }

    default public ListPrivateGraphEndpointsIterable listPrivateGraphEndpointsPaginator(Consumer<ListPrivateGraphEndpointsRequest.Builder> listPrivateGraphEndpointsRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.listPrivateGraphEndpointsPaginator((ListPrivateGraphEndpointsRequest)((Object)((ListPrivateGraphEndpointsRequest.Builder)ListPrivateGraphEndpointsRequest.builder().applyMutation(listPrivateGraphEndpointsRequest)).build()));
    }

    default public ListQueriesResponse listQueries(ListQueriesRequest listQueriesRequest) throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public ListQueriesResponse listQueries(Consumer<ListQueriesRequest.Builder> listQueriesRequest) throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.listQueries((ListQueriesRequest)((Object)((ListQueriesRequest.Builder)ListQueriesRequest.builder().applyMutation(listQueriesRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public ResetGraphResponse resetGraph(ResetGraphRequest resetGraphRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public ResetGraphResponse resetGraph(Consumer<ResetGraphRequest.Builder> resetGraphRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.resetGraph((ResetGraphRequest)((Object)((ResetGraphRequest.Builder)ResetGraphRequest.builder().applyMutation(resetGraphRequest)).build()));
    }

    default public RestoreGraphFromSnapshotResponse restoreGraphFromSnapshot(RestoreGraphFromSnapshotRequest restoreGraphFromSnapshotRequest) throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public RestoreGraphFromSnapshotResponse restoreGraphFromSnapshot(Consumer<RestoreGraphFromSnapshotRequest.Builder> restoreGraphFromSnapshotRequest) throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.restoreGraphFromSnapshot((RestoreGraphFromSnapshotRequest)((Object)((RestoreGraphFromSnapshotRequest.Builder)RestoreGraphFromSnapshotRequest.builder().applyMutation(restoreGraphFromSnapshotRequest)).build()));
    }

    default public StartImportTaskResponse startImportTask(StartImportTaskRequest startImportTaskRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public StartImportTaskResponse startImportTask(Consumer<StartImportTaskRequest.Builder> startImportTaskRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.startImportTask((StartImportTaskRequest)((Object)((StartImportTaskRequest.Builder)StartImportTaskRequest.builder().applyMutation(startImportTaskRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateGraphResponse updateGraph(UpdateGraphRequest updateGraphRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    default public UpdateGraphResponse updateGraph(Consumer<UpdateGraphRequest.Builder> updateGraphRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return this.updateGraph((UpdateGraphRequest)((Object)((UpdateGraphRequest.Builder)UpdateGraphRequest.builder().applyMutation(updateGraphRequest)).build()));
    }

    default public NeptuneGraphWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    public static NeptuneGraphClient create() {
        return (NeptuneGraphClient)NeptuneGraphClient.builder().build();
    }

    public static NeptuneGraphClientBuilder builder() {
        return new DefaultNeptuneGraphClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"neptune-graph");
    }

    default public NeptuneGraphServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

