/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphClient;
import software.amazon.awssdk.services.neptunegraph.internal.UserAgentUtils;
import software.amazon.awssdk.services.neptunegraph.model.GraphSnapshotSummary;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsResponse;

public class ListGraphSnapshotsIterable
implements SdkIterable<ListGraphSnapshotsResponse> {
    private final NeptuneGraphClient client;
    private final ListGraphSnapshotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGraphSnapshotsIterable(NeptuneGraphClient client, ListGraphSnapshotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGraphSnapshotsResponseFetcher();
    }

    public Iterator<ListGraphSnapshotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GraphSnapshotSummary> graphSnapshots() {
        Function<ListGraphSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.graphSnapshots() != null) {
                return response.graphSnapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGraphSnapshotsResponseFetcher
    implements SyncPageFetcher<ListGraphSnapshotsResponse> {
        private ListGraphSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(ListGraphSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGraphSnapshotsResponse nextPage(ListGraphSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return ListGraphSnapshotsIterable.this.client.listGraphSnapshots(ListGraphSnapshotsIterable.this.firstRequest);
            }
            return ListGraphSnapshotsIterable.this.client.listGraphSnapshots((ListGraphSnapshotsRequest)((Object)ListGraphSnapshotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

