/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.EventCategoriesMap;
import software.amazon.awssdk.services.neptune.model.EventCategoriesMapListCopier;
import software.amazon.awssdk.services.neptune.model.NeptuneResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventCategoriesResponse
extends NeptuneResponse
implements ToCopyableBuilder<Builder, DescribeEventCategoriesResponse> {
    private static final SdkField<List<EventCategoriesMap>> EVENT_CATEGORIES_MAP_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeEventCategoriesResponse.getter(DescribeEventCategoriesResponse::eventCategoriesMapList)).setter(DescribeEventCategoriesResponse.setter(Builder::eventCategoriesMapList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategoriesMapList").build(), ListTrait.builder().memberLocationName("EventCategoriesMap").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventCategoriesMap::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategoriesMap").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_CATEGORIES_MAP_LIST_FIELD));
    private final List<EventCategoriesMap> eventCategoriesMapList;

    private DescribeEventCategoriesResponse(BuilderImpl builder) {
        super(builder);
        this.eventCategoriesMapList = builder.eventCategoriesMapList;
    }

    public List<EventCategoriesMap> eventCategoriesMapList() {
        return this.eventCategoriesMapList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCategoriesMapList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventCategoriesResponse)) {
            return false;
        }
        DescribeEventCategoriesResponse other = (DescribeEventCategoriesResponse)((Object)obj);
        return Objects.equals(this.eventCategoriesMapList(), other.eventCategoriesMapList());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEventCategoriesResponse").add("EventCategoriesMapList", this.eventCategoriesMapList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventCategoriesMapList": {
                return Optional.ofNullable(clazz.cast(this.eventCategoriesMapList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventCategoriesResponse, T> g) {
        return obj -> g.apply((DescribeEventCategoriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneResponse.BuilderImpl
    implements Builder {
        private List<EventCategoriesMap> eventCategoriesMapList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventCategoriesResponse model) {
            super(model);
            this.eventCategoriesMapList(model.eventCategoriesMapList);
        }

        public final Collection<EventCategoriesMap.Builder> getEventCategoriesMapList() {
            return this.eventCategoriesMapList != null ? (Collection)this.eventCategoriesMapList.stream().map(EventCategoriesMap::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventCategoriesMapList(Collection<EventCategoriesMap> eventCategoriesMapList) {
            this.eventCategoriesMapList = EventCategoriesMapListCopier.copy(eventCategoriesMapList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategoriesMapList(EventCategoriesMap ... eventCategoriesMapList) {
            this.eventCategoriesMapList(Arrays.asList(eventCategoriesMapList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategoriesMapList(Consumer<EventCategoriesMap.Builder> ... eventCategoriesMapList) {
            this.eventCategoriesMapList(Stream.of(eventCategoriesMapList).map(c -> (EventCategoriesMap)((EventCategoriesMap.Builder)EventCategoriesMap.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventCategoriesMapList(Collection<EventCategoriesMap.BuilderImpl> eventCategoriesMapList) {
            this.eventCategoriesMapList = EventCategoriesMapListCopier.copyFromBuilder(eventCategoriesMapList);
        }

        @Override
        public DescribeEventCategoriesResponse build() {
            return new DescribeEventCategoriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptuneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEventCategoriesResponse> {
        public Builder eventCategoriesMapList(Collection<EventCategoriesMap> var1);

        public Builder eventCategoriesMapList(EventCategoriesMap ... var1);

        public Builder eventCategoriesMapList(Consumer<EventCategoriesMap.Builder> ... var1);
    }
}

