/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.EventCategoriesListCopier;
import software.amazon.awssdk.services.neptune.model.SourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Event
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Event> {
    private static final SdkField<String> SOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Event.getter(Event::sourceIdentifier)).setter(Event.setter(Builder::sourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIdentifier").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Event.getter(Event::sourceTypeAsString)).setter(Event.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Event.getter(Event::message)).setter(Event.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<List<String>> EVENT_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Event.getter(Event::eventCategories)).setter(Event.setter(Builder::eventCategories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategories").build(), ListTrait.builder().memberLocationName("EventCategory").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategory").build()}).build()).build()}).build();
    private static final SdkField<Instant> DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Event.getter(Event::date)).setter(Event.setter(Builder::date)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Date").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Event.getter(Event::sourceArn)).setter(Event.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IDENTIFIER_FIELD, SOURCE_TYPE_FIELD, MESSAGE_FIELD, EVENT_CATEGORIES_FIELD, DATE_FIELD, SOURCE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceIdentifier;
    private final String sourceType;
    private final String message;
    private final List<String> eventCategories;
    private final Instant date;
    private final String sourceArn;

    private Event(BuilderImpl builder) {
        this.sourceIdentifier = builder.sourceIdentifier;
        this.sourceType = builder.sourceType;
        this.message = builder.message;
        this.eventCategories = builder.eventCategories;
        this.date = builder.date;
        this.sourceArn = builder.sourceArn;
    }

    public String sourceIdentifier() {
        return this.sourceIdentifier;
    }

    public SourceType sourceType() {
        return SourceType.fromValue(this.sourceType);
    }

    public String sourceTypeAsString() {
        return this.sourceType;
    }

    public String message() {
        return this.message;
    }

    public List<String> eventCategories() {
        return this.eventCategories;
    }

    public Instant date() {
        return this.date;
    }

    public String sourceArn() {
        return this.sourceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCategories());
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.sourceIdentifier(), other.sourceIdentifier()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.eventCategories(), other.eventCategories()) && Objects.equals(this.date(), other.date()) && Objects.equals(this.sourceArn(), other.sourceArn());
    }

    public String toString() {
        return ToString.builder((String)"Event").add("SourceIdentifier", (Object)this.sourceIdentifier()).add("SourceType", (Object)this.sourceTypeAsString()).add("Message", (Object)this.message()).add("EventCategories", this.eventCategories()).add("Date", (Object)this.date()).add("SourceArn", (Object)this.sourceArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceIdentifier()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "EventCategories": {
                return Optional.ofNullable(clazz.cast(this.eventCategories()));
            }
            case "Date": {
                return Optional.ofNullable(clazz.cast(this.date()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceIdentifier;
        private String sourceType;
        private String message;
        private List<String> eventCategories = DefaultSdkAutoConstructList.getInstance();
        private Instant date;
        private String sourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.sourceIdentifier(model.sourceIdentifier);
            this.sourceType(model.sourceType);
            this.message(model.message);
            this.eventCategories(model.eventCategories);
            this.date(model.date);
            this.sourceArn(model.sourceArn);
        }

        public final String getSourceIdentifier() {
            return this.sourceIdentifier;
        }

        @Override
        public final Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public final void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        public final String getSourceTypeAsString() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Collection<String> getEventCategories() {
            return this.eventCategories;
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        public final Instant getDate() {
            return this.date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public Event build() {
            return new Event(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Event> {
        public Builder sourceIdentifier(String var1);

        public Builder sourceType(String var1);

        public Builder sourceType(SourceType var1);

        public Builder message(String var1);

        public Builder eventCategories(Collection<String> var1);

        public Builder eventCategories(String ... var1);

        public Builder date(Instant var1);

        public Builder sourceArn(String var1);
    }
}

