/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mwaa.model.AirflowConfigurationOptionsCopier;
import software.amazon.awssdk.services.mwaa.model.EndpointManagement;
import software.amazon.awssdk.services.mwaa.model.LoggingConfigurationInput;
import software.amazon.awssdk.services.mwaa.model.MwaaRequest;
import software.amazon.awssdk.services.mwaa.model.NetworkConfiguration;
import software.amazon.awssdk.services.mwaa.model.TagMapCopier;
import software.amazon.awssdk.services.mwaa.model.WebserverAccessMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentRequest
extends MwaaRequest
implements ToCopyableBuilder<Builder, CreateEnvironmentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::name)).setter(CreateEnvironmentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::executionRoleArn)).setter(CreateEnvironmentRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> SOURCE_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceBucketArn").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::sourceBucketArn)).setter(CreateEnvironmentRequest.setter(Builder::sourceBucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBucketArn").build()}).build();
    private static final SdkField<String> DAG_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DagS3Path").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::dagS3Path)).setter(CreateEnvironmentRequest.setter(Builder::dagS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagS3Path").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfiguration").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::networkConfiguration)).setter(CreateEnvironmentRequest.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build()}).build();
    private static final SdkField<String> PLUGINS_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PluginsS3Path").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::pluginsS3Path)).setter(CreateEnvironmentRequest.setter(Builder::pluginsS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginsS3Path").build()}).build();
    private static final SdkField<String> PLUGINS_S3_OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PluginsS3ObjectVersion").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::pluginsS3ObjectVersion)).setter(CreateEnvironmentRequest.setter(Builder::pluginsS3ObjectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginsS3ObjectVersion").build()}).build();
    private static final SdkField<String> REQUIREMENTS_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequirementsS3Path").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::requirementsS3Path)).setter(CreateEnvironmentRequest.setter(Builder::requirementsS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirementsS3Path").build()}).build();
    private static final SdkField<String> REQUIREMENTS_S3_OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequirementsS3ObjectVersion").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::requirementsS3ObjectVersion)).setter(CreateEnvironmentRequest.setter(Builder::requirementsS3ObjectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirementsS3ObjectVersion").build()}).build();
    private static final SdkField<String> STARTUP_SCRIPT_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartupScriptS3Path").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::startupScriptS3Path)).setter(CreateEnvironmentRequest.setter(Builder::startupScriptS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupScriptS3Path").build()}).build();
    private static final SdkField<String> STARTUP_SCRIPT_S3_OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartupScriptS3ObjectVersion").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::startupScriptS3ObjectVersion)).setter(CreateEnvironmentRequest.setter(Builder::startupScriptS3ObjectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupScriptS3ObjectVersion").build()}).build();
    private static final SdkField<Map<String, String>> AIRFLOW_CONFIGURATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AirflowConfigurationOptions").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::airflowConfigurationOptions)).setter(CreateEnvironmentRequest.setter(Builder::airflowConfigurationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowConfigurationOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ENVIRONMENT_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentClass").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::environmentClass)).setter(CreateEnvironmentRequest.setter(Builder::environmentClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentClass").build()}).build();
    private static final SdkField<Integer> MAX_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxWorkers").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::maxWorkers)).setter(CreateEnvironmentRequest.setter(Builder::maxWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWorkers").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKey").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::kmsKey)).setter(CreateEnvironmentRequest.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()}).build();
    private static final SdkField<String> AIRFLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AirflowVersion").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::airflowVersion)).setter(CreateEnvironmentRequest.setter(Builder::airflowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowVersion").build()}).build();
    private static final SdkField<LoggingConfigurationInput> LOGGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingConfiguration").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::loggingConfiguration)).setter(CreateEnvironmentRequest.setter(Builder::loggingConfiguration)).constructor(LoggingConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_WINDOW_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceWindowStart").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::weeklyMaintenanceWindowStart)).setter(CreateEnvironmentRequest.setter(Builder::weeklyMaintenanceWindowStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceWindowStart").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::tags)).setter(CreateEnvironmentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WEBSERVER_ACCESS_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebserverAccessMode").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::webserverAccessModeAsString)).setter(CreateEnvironmentRequest.setter(Builder::webserverAccessMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverAccessMode").build()}).build();
    private static final SdkField<Integer> MIN_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinWorkers").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::minWorkers)).setter(CreateEnvironmentRequest.setter(Builder::minWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinWorkers").build()}).build();
    private static final SdkField<Integer> SCHEDULERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Schedulers").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::schedulers)).setter(CreateEnvironmentRequest.setter(Builder::schedulers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedulers").build()}).build();
    private static final SdkField<String> ENDPOINT_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointManagement").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::endpointManagementAsString)).setter(CreateEnvironmentRequest.setter(Builder::endpointManagement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointManagement").build()}).build();
    private static final SdkField<Integer> MIN_WEBSERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinWebservers").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::minWebservers)).setter(CreateEnvironmentRequest.setter(Builder::minWebservers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinWebservers").build()}).build();
    private static final SdkField<Integer> MAX_WEBSERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxWebservers").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::maxWebservers)).setter(CreateEnvironmentRequest.setter(Builder::maxWebservers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWebservers").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EXECUTION_ROLE_ARN_FIELD, SOURCE_BUCKET_ARN_FIELD, DAG_S3_PATH_FIELD, NETWORK_CONFIGURATION_FIELD, PLUGINS_S3_PATH_FIELD, PLUGINS_S3_OBJECT_VERSION_FIELD, REQUIREMENTS_S3_PATH_FIELD, REQUIREMENTS_S3_OBJECT_VERSION_FIELD, STARTUP_SCRIPT_S3_PATH_FIELD, STARTUP_SCRIPT_S3_OBJECT_VERSION_FIELD, AIRFLOW_CONFIGURATION_OPTIONS_FIELD, ENVIRONMENT_CLASS_FIELD, MAX_WORKERS_FIELD, KMS_KEY_FIELD, AIRFLOW_VERSION_FIELD, LOGGING_CONFIGURATION_FIELD, WEEKLY_MAINTENANCE_WINDOW_START_FIELD, TAGS_FIELD, WEBSERVER_ACCESS_MODE_FIELD, MIN_WORKERS_FIELD, SCHEDULERS_FIELD, ENDPOINT_MANAGEMENT_FIELD, MIN_WEBSERVERS_FIELD, MAX_WEBSERVERS_FIELD));
    private final String name;
    private final String executionRoleArn;
    private final String sourceBucketArn;
    private final String dagS3Path;
    private final NetworkConfiguration networkConfiguration;
    private final String pluginsS3Path;
    private final String pluginsS3ObjectVersion;
    private final String requirementsS3Path;
    private final String requirementsS3ObjectVersion;
    private final String startupScriptS3Path;
    private final String startupScriptS3ObjectVersion;
    private final Map<String, String> airflowConfigurationOptions;
    private final String environmentClass;
    private final Integer maxWorkers;
    private final String kmsKey;
    private final String airflowVersion;
    private final LoggingConfigurationInput loggingConfiguration;
    private final String weeklyMaintenanceWindowStart;
    private final Map<String, String> tags;
    private final String webserverAccessMode;
    private final Integer minWorkers;
    private final Integer schedulers;
    private final String endpointManagement;
    private final Integer minWebservers;
    private final Integer maxWebservers;

    private CreateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.executionRoleArn = builder.executionRoleArn;
        this.sourceBucketArn = builder.sourceBucketArn;
        this.dagS3Path = builder.dagS3Path;
        this.networkConfiguration = builder.networkConfiguration;
        this.pluginsS3Path = builder.pluginsS3Path;
        this.pluginsS3ObjectVersion = builder.pluginsS3ObjectVersion;
        this.requirementsS3Path = builder.requirementsS3Path;
        this.requirementsS3ObjectVersion = builder.requirementsS3ObjectVersion;
        this.startupScriptS3Path = builder.startupScriptS3Path;
        this.startupScriptS3ObjectVersion = builder.startupScriptS3ObjectVersion;
        this.airflowConfigurationOptions = builder.airflowConfigurationOptions;
        this.environmentClass = builder.environmentClass;
        this.maxWorkers = builder.maxWorkers;
        this.kmsKey = builder.kmsKey;
        this.airflowVersion = builder.airflowVersion;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
        this.tags = builder.tags;
        this.webserverAccessMode = builder.webserverAccessMode;
        this.minWorkers = builder.minWorkers;
        this.schedulers = builder.schedulers;
        this.endpointManagement = builder.endpointManagement;
        this.minWebservers = builder.minWebservers;
        this.maxWebservers = builder.maxWebservers;
    }

    public final String name() {
        return this.name;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String sourceBucketArn() {
        return this.sourceBucketArn;
    }

    public final String dagS3Path() {
        return this.dagS3Path;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final String pluginsS3Path() {
        return this.pluginsS3Path;
    }

    public final String pluginsS3ObjectVersion() {
        return this.pluginsS3ObjectVersion;
    }

    public final String requirementsS3Path() {
        return this.requirementsS3Path;
    }

    public final String requirementsS3ObjectVersion() {
        return this.requirementsS3ObjectVersion;
    }

    public final String startupScriptS3Path() {
        return this.startupScriptS3Path;
    }

    public final String startupScriptS3ObjectVersion() {
        return this.startupScriptS3ObjectVersion;
    }

    public final boolean hasAirflowConfigurationOptions() {
        return this.airflowConfigurationOptions != null && !(this.airflowConfigurationOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> airflowConfigurationOptions() {
        return this.airflowConfigurationOptions;
    }

    public final String environmentClass() {
        return this.environmentClass;
    }

    public final Integer maxWorkers() {
        return this.maxWorkers;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final String airflowVersion() {
        return this.airflowVersion;
    }

    public final LoggingConfigurationInput loggingConfiguration() {
        return this.loggingConfiguration;
    }

    public final String weeklyMaintenanceWindowStart() {
        return this.weeklyMaintenanceWindowStart;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final WebserverAccessMode webserverAccessMode() {
        return WebserverAccessMode.fromValue(this.webserverAccessMode);
    }

    public final String webserverAccessModeAsString() {
        return this.webserverAccessMode;
    }

    public final Integer minWorkers() {
        return this.minWorkers;
    }

    public final Integer schedulers() {
        return this.schedulers;
    }

    public final EndpointManagement endpointManagement() {
        return EndpointManagement.fromValue(this.endpointManagement);
    }

    public final String endpointManagementAsString() {
        return this.endpointManagement;
    }

    public final Integer minWebservers() {
        return this.minWebservers;
    }

    public final Integer maxWebservers() {
        return this.maxWebservers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dagS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginsS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.requirementsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.requirementsS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.startupScriptS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.startupScriptS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAirflowConfigurationOptions() ? this.airflowConfigurationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.airflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.webserverAccessModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulers());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointManagementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minWebservers());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWebservers());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentRequest)) {
            return false;
        }
        CreateEnvironmentRequest other = (CreateEnvironmentRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.sourceBucketArn(), other.sourceBucketArn()) && Objects.equals(this.dagS3Path(), other.dagS3Path()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.pluginsS3Path(), other.pluginsS3Path()) && Objects.equals(this.pluginsS3ObjectVersion(), other.pluginsS3ObjectVersion()) && Objects.equals(this.requirementsS3Path(), other.requirementsS3Path()) && Objects.equals(this.requirementsS3ObjectVersion(), other.requirementsS3ObjectVersion()) && Objects.equals(this.startupScriptS3Path(), other.startupScriptS3Path()) && Objects.equals(this.startupScriptS3ObjectVersion(), other.startupScriptS3ObjectVersion()) && this.hasAirflowConfigurationOptions() == other.hasAirflowConfigurationOptions() && Objects.equals(this.airflowConfigurationOptions(), other.airflowConfigurationOptions()) && Objects.equals(this.environmentClass(), other.environmentClass()) && Objects.equals(this.maxWorkers(), other.maxWorkers()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.airflowVersion(), other.airflowVersion()) && Objects.equals(this.loggingConfiguration(), other.loggingConfiguration()) && Objects.equals(this.weeklyMaintenanceWindowStart(), other.weeklyMaintenanceWindowStart()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.webserverAccessModeAsString(), other.webserverAccessModeAsString()) && Objects.equals(this.minWorkers(), other.minWorkers()) && Objects.equals(this.schedulers(), other.schedulers()) && Objects.equals(this.endpointManagementAsString(), other.endpointManagementAsString()) && Objects.equals(this.minWebservers(), other.minWebservers()) && Objects.equals(this.maxWebservers(), other.maxWebservers());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEnvironmentRequest").add("Name", (Object)this.name()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("SourceBucketArn", (Object)this.sourceBucketArn()).add("DagS3Path", (Object)this.dagS3Path()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("PluginsS3Path", (Object)this.pluginsS3Path()).add("PluginsS3ObjectVersion", (Object)this.pluginsS3ObjectVersion()).add("RequirementsS3Path", (Object)this.requirementsS3Path()).add("RequirementsS3ObjectVersion", (Object)this.requirementsS3ObjectVersion()).add("StartupScriptS3Path", (Object)this.startupScriptS3Path()).add("StartupScriptS3ObjectVersion", (Object)this.startupScriptS3ObjectVersion()).add("AirflowConfigurationOptions", (Object)(this.airflowConfigurationOptions() == null ? null : "*** Sensitive Data Redacted ***")).add("EnvironmentClass", (Object)this.environmentClass()).add("MaxWorkers", (Object)this.maxWorkers()).add("KmsKey", (Object)this.kmsKey()).add("AirflowVersion", (Object)this.airflowVersion()).add("LoggingConfiguration", (Object)this.loggingConfiguration()).add("WeeklyMaintenanceWindowStart", (Object)this.weeklyMaintenanceWindowStart()).add("Tags", this.hasTags() ? this.tags() : null).add("WebserverAccessMode", (Object)this.webserverAccessModeAsString()).add("MinWorkers", (Object)this.minWorkers()).add("Schedulers", (Object)this.schedulers()).add("EndpointManagement", (Object)this.endpointManagementAsString()).add("MinWebservers", (Object)this.minWebservers()).add("MaxWebservers", (Object)this.maxWebservers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "SourceBucketArn": {
                return Optional.ofNullable(clazz.cast(this.sourceBucketArn()));
            }
            case "DagS3Path": {
                return Optional.ofNullable(clazz.cast(this.dagS3Path()));
            }
            case "NetworkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "PluginsS3Path": {
                return Optional.ofNullable(clazz.cast(this.pluginsS3Path()));
            }
            case "PluginsS3ObjectVersion": {
                return Optional.ofNullable(clazz.cast(this.pluginsS3ObjectVersion()));
            }
            case "RequirementsS3Path": {
                return Optional.ofNullable(clazz.cast(this.requirementsS3Path()));
            }
            case "RequirementsS3ObjectVersion": {
                return Optional.ofNullable(clazz.cast(this.requirementsS3ObjectVersion()));
            }
            case "StartupScriptS3Path": {
                return Optional.ofNullable(clazz.cast(this.startupScriptS3Path()));
            }
            case "StartupScriptS3ObjectVersion": {
                return Optional.ofNullable(clazz.cast(this.startupScriptS3ObjectVersion()));
            }
            case "AirflowConfigurationOptions": {
                return Optional.ofNullable(clazz.cast(this.airflowConfigurationOptions()));
            }
            case "EnvironmentClass": {
                return Optional.ofNullable(clazz.cast(this.environmentClass()));
            }
            case "MaxWorkers": {
                return Optional.ofNullable(clazz.cast(this.maxWorkers()));
            }
            case "KmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "AirflowVersion": {
                return Optional.ofNullable(clazz.cast(this.airflowVersion()));
            }
            case "LoggingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.loggingConfiguration()));
            }
            case "WeeklyMaintenanceWindowStart": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceWindowStart()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "WebserverAccessMode": {
                return Optional.ofNullable(clazz.cast(this.webserverAccessModeAsString()));
            }
            case "MinWorkers": {
                return Optional.ofNullable(clazz.cast(this.minWorkers()));
            }
            case "Schedulers": {
                return Optional.ofNullable(clazz.cast(this.schedulers()));
            }
            case "EndpointManagement": {
                return Optional.ofNullable(clazz.cast(this.endpointManagementAsString()));
            }
            case "MinWebservers": {
                return Optional.ofNullable(clazz.cast(this.minWebservers()));
            }
            case "MaxWebservers": {
                return Optional.ofNullable(clazz.cast(this.maxWebservers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MwaaRequest.BuilderImpl
    implements Builder {
        private String name;
        private String executionRoleArn;
        private String sourceBucketArn;
        private String dagS3Path;
        private NetworkConfiguration networkConfiguration;
        private String pluginsS3Path;
        private String pluginsS3ObjectVersion;
        private String requirementsS3Path;
        private String requirementsS3ObjectVersion;
        private String startupScriptS3Path;
        private String startupScriptS3ObjectVersion;
        private Map<String, String> airflowConfigurationOptions = DefaultSdkAutoConstructMap.getInstance();
        private String environmentClass;
        private Integer maxWorkers;
        private String kmsKey;
        private String airflowVersion;
        private LoggingConfigurationInput loggingConfiguration;
        private String weeklyMaintenanceWindowStart;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String webserverAccessMode;
        private Integer minWorkers;
        private Integer schedulers;
        private String endpointManagement;
        private Integer minWebservers;
        private Integer maxWebservers;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentRequest model) {
            super(model);
            this.name(model.name);
            this.executionRoleArn(model.executionRoleArn);
            this.sourceBucketArn(model.sourceBucketArn);
            this.dagS3Path(model.dagS3Path);
            this.networkConfiguration(model.networkConfiguration);
            this.pluginsS3Path(model.pluginsS3Path);
            this.pluginsS3ObjectVersion(model.pluginsS3ObjectVersion);
            this.requirementsS3Path(model.requirementsS3Path);
            this.requirementsS3ObjectVersion(model.requirementsS3ObjectVersion);
            this.startupScriptS3Path(model.startupScriptS3Path);
            this.startupScriptS3ObjectVersion(model.startupScriptS3ObjectVersion);
            this.airflowConfigurationOptions(model.airflowConfigurationOptions);
            this.environmentClass(model.environmentClass);
            this.maxWorkers(model.maxWorkers);
            this.kmsKey(model.kmsKey);
            this.airflowVersion(model.airflowVersion);
            this.loggingConfiguration(model.loggingConfiguration);
            this.weeklyMaintenanceWindowStart(model.weeklyMaintenanceWindowStart);
            this.tags(model.tags);
            this.webserverAccessMode(model.webserverAccessMode);
            this.minWorkers(model.minWorkers);
            this.schedulers(model.schedulers);
            this.endpointManagement(model.endpointManagement);
            this.minWebservers(model.minWebservers);
            this.maxWebservers(model.maxWebservers);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getSourceBucketArn() {
            return this.sourceBucketArn;
        }

        public final void setSourceBucketArn(String sourceBucketArn) {
            this.sourceBucketArn = sourceBucketArn;
        }

        @Override
        public final Builder sourceBucketArn(String sourceBucketArn) {
            this.sourceBucketArn = sourceBucketArn;
            return this;
        }

        public final String getDagS3Path() {
            return this.dagS3Path;
        }

        public final void setDagS3Path(String dagS3Path) {
            this.dagS3Path = dagS3Path;
        }

        @Override
        public final Builder dagS3Path(String dagS3Path) {
            this.dagS3Path = dagS3Path;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getPluginsS3Path() {
            return this.pluginsS3Path;
        }

        public final void setPluginsS3Path(String pluginsS3Path) {
            this.pluginsS3Path = pluginsS3Path;
        }

        @Override
        public final Builder pluginsS3Path(String pluginsS3Path) {
            this.pluginsS3Path = pluginsS3Path;
            return this;
        }

        public final String getPluginsS3ObjectVersion() {
            return this.pluginsS3ObjectVersion;
        }

        public final void setPluginsS3ObjectVersion(String pluginsS3ObjectVersion) {
            this.pluginsS3ObjectVersion = pluginsS3ObjectVersion;
        }

        @Override
        public final Builder pluginsS3ObjectVersion(String pluginsS3ObjectVersion) {
            this.pluginsS3ObjectVersion = pluginsS3ObjectVersion;
            return this;
        }

        public final String getRequirementsS3Path() {
            return this.requirementsS3Path;
        }

        public final void setRequirementsS3Path(String requirementsS3Path) {
            this.requirementsS3Path = requirementsS3Path;
        }

        @Override
        public final Builder requirementsS3Path(String requirementsS3Path) {
            this.requirementsS3Path = requirementsS3Path;
            return this;
        }

        public final String getRequirementsS3ObjectVersion() {
            return this.requirementsS3ObjectVersion;
        }

        public final void setRequirementsS3ObjectVersion(String requirementsS3ObjectVersion) {
            this.requirementsS3ObjectVersion = requirementsS3ObjectVersion;
        }

        @Override
        public final Builder requirementsS3ObjectVersion(String requirementsS3ObjectVersion) {
            this.requirementsS3ObjectVersion = requirementsS3ObjectVersion;
            return this;
        }

        public final String getStartupScriptS3Path() {
            return this.startupScriptS3Path;
        }

        public final void setStartupScriptS3Path(String startupScriptS3Path) {
            this.startupScriptS3Path = startupScriptS3Path;
        }

        @Override
        public final Builder startupScriptS3Path(String startupScriptS3Path) {
            this.startupScriptS3Path = startupScriptS3Path;
            return this;
        }

        public final String getStartupScriptS3ObjectVersion() {
            return this.startupScriptS3ObjectVersion;
        }

        public final void setStartupScriptS3ObjectVersion(String startupScriptS3ObjectVersion) {
            this.startupScriptS3ObjectVersion = startupScriptS3ObjectVersion;
        }

        @Override
        public final Builder startupScriptS3ObjectVersion(String startupScriptS3ObjectVersion) {
            this.startupScriptS3ObjectVersion = startupScriptS3ObjectVersion;
            return this;
        }

        public final Map<String, String> getAirflowConfigurationOptions() {
            if (this.airflowConfigurationOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.airflowConfigurationOptions;
        }

        public final void setAirflowConfigurationOptions(Map<String, String> airflowConfigurationOptions) {
            this.airflowConfigurationOptions = AirflowConfigurationOptionsCopier.copy(airflowConfigurationOptions);
        }

        @Override
        public final Builder airflowConfigurationOptions(Map<String, String> airflowConfigurationOptions) {
            this.airflowConfigurationOptions = AirflowConfigurationOptionsCopier.copy(airflowConfigurationOptions);
            return this;
        }

        public final String getEnvironmentClass() {
            return this.environmentClass;
        }

        public final void setEnvironmentClass(String environmentClass) {
            this.environmentClass = environmentClass;
        }

        @Override
        public final Builder environmentClass(String environmentClass) {
            this.environmentClass = environmentClass;
            return this;
        }

        public final Integer getMaxWorkers() {
            return this.maxWorkers;
        }

        public final void setMaxWorkers(Integer maxWorkers) {
            this.maxWorkers = maxWorkers;
        }

        @Override
        public final Builder maxWorkers(Integer maxWorkers) {
            this.maxWorkers = maxWorkers;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getAirflowVersion() {
            return this.airflowVersion;
        }

        public final void setAirflowVersion(String airflowVersion) {
            this.airflowVersion = airflowVersion;
        }

        @Override
        public final Builder airflowVersion(String airflowVersion) {
            this.airflowVersion = airflowVersion;
            return this;
        }

        public final LoggingConfigurationInput.Builder getLoggingConfiguration() {
            return this.loggingConfiguration != null ? this.loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfigurationInput.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfigurationInput loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final String getWeeklyMaintenanceWindowStart() {
            return this.weeklyMaintenanceWindowStart;
        }

        public final void setWeeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
        }

        @Override
        public final Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWebserverAccessMode() {
            return this.webserverAccessMode;
        }

        public final void setWebserverAccessMode(String webserverAccessMode) {
            this.webserverAccessMode = webserverAccessMode;
        }

        @Override
        public final Builder webserverAccessMode(String webserverAccessMode) {
            this.webserverAccessMode = webserverAccessMode;
            return this;
        }

        @Override
        public final Builder webserverAccessMode(WebserverAccessMode webserverAccessMode) {
            this.webserverAccessMode(webserverAccessMode == null ? null : webserverAccessMode.toString());
            return this;
        }

        public final Integer getMinWorkers() {
            return this.minWorkers;
        }

        public final void setMinWorkers(Integer minWorkers) {
            this.minWorkers = minWorkers;
        }

        @Override
        public final Builder minWorkers(Integer minWorkers) {
            this.minWorkers = minWorkers;
            return this;
        }

        public final Integer getSchedulers() {
            return this.schedulers;
        }

        public final void setSchedulers(Integer schedulers) {
            this.schedulers = schedulers;
        }

        @Override
        public final Builder schedulers(Integer schedulers) {
            this.schedulers = schedulers;
            return this;
        }

        public final String getEndpointManagement() {
            return this.endpointManagement;
        }

        public final void setEndpointManagement(String endpointManagement) {
            this.endpointManagement = endpointManagement;
        }

        @Override
        public final Builder endpointManagement(String endpointManagement) {
            this.endpointManagement = endpointManagement;
            return this;
        }

        @Override
        public final Builder endpointManagement(EndpointManagement endpointManagement) {
            this.endpointManagement(endpointManagement == null ? null : endpointManagement.toString());
            return this;
        }

        public final Integer getMinWebservers() {
            return this.minWebservers;
        }

        public final void setMinWebservers(Integer minWebservers) {
            this.minWebservers = minWebservers;
        }

        @Override
        public final Builder minWebservers(Integer minWebservers) {
            this.minWebservers = minWebservers;
            return this;
        }

        public final Integer getMaxWebservers() {
            return this.maxWebservers;
        }

        public final void setMaxWebservers(Integer maxWebservers) {
            this.maxWebservers = maxWebservers;
        }

        @Override
        public final Builder maxWebservers(Integer maxWebservers) {
            this.maxWebservers = maxWebservers;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentRequest build() {
            return new CreateEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MwaaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEnvironmentRequest> {
        public Builder name(String var1);

        public Builder executionRoleArn(String var1);

        public Builder sourceBucketArn(String var1);

        public Builder dagS3Path(String var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder pluginsS3Path(String var1);

        public Builder pluginsS3ObjectVersion(String var1);

        public Builder requirementsS3Path(String var1);

        public Builder requirementsS3ObjectVersion(String var1);

        public Builder startupScriptS3Path(String var1);

        public Builder startupScriptS3ObjectVersion(String var1);

        public Builder airflowConfigurationOptions(Map<String, String> var1);

        public Builder environmentClass(String var1);

        public Builder maxWorkers(Integer var1);

        public Builder kmsKey(String var1);

        public Builder airflowVersion(String var1);

        public Builder loggingConfiguration(LoggingConfigurationInput var1);

        default public Builder loggingConfiguration(Consumer<LoggingConfigurationInput.Builder> loggingConfiguration) {
            return this.loggingConfiguration((LoggingConfigurationInput)((LoggingConfigurationInput.Builder)LoggingConfigurationInput.builder().applyMutation(loggingConfiguration)).build());
        }

        public Builder weeklyMaintenanceWindowStart(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder webserverAccessMode(String var1);

        public Builder webserverAccessMode(WebserverAccessMode var1);

        public Builder minWorkers(Integer var1);

        public Builder schedulers(Integer var1);

        public Builder endpointManagement(String var1);

        public Builder endpointManagement(EndpointManagement var1);

        public Builder minWebservers(Integer var1);

        public Builder maxWebservers(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

