/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mwaa.model.MwaaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWebLoginTokenResponse
extends MwaaResponse
implements ToCopyableBuilder<Builder, CreateWebLoginTokenResponse> {
    private static final SdkField<String> WEB_SERVER_HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebServerHostname").getter(CreateWebLoginTokenResponse.getter(CreateWebLoginTokenResponse::webServerHostname)).setter(CreateWebLoginTokenResponse.setter(Builder::webServerHostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebServerHostname").build()}).build();
    private static final SdkField<String> WEB_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebToken").getter(CreateWebLoginTokenResponse.getter(CreateWebLoginTokenResponse::webToken)).setter(CreateWebLoginTokenResponse.setter(Builder::webToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_SERVER_HOSTNAME_FIELD, WEB_TOKEN_FIELD));
    private final String webServerHostname;
    private final String webToken;

    private CreateWebLoginTokenResponse(BuilderImpl builder) {
        super(builder);
        this.webServerHostname = builder.webServerHostname;
        this.webToken = builder.webToken;
    }

    public final String webServerHostname() {
        return this.webServerHostname;
    }

    public final String webToken() {
        return this.webToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.webServerHostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.webToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebLoginTokenResponse)) {
            return false;
        }
        CreateWebLoginTokenResponse other = (CreateWebLoginTokenResponse)((Object)obj);
        return Objects.equals(this.webServerHostname(), other.webServerHostname()) && Objects.equals(this.webToken(), other.webToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWebLoginTokenResponse").add("WebServerHostname", (Object)this.webServerHostname()).add("WebToken", (Object)(this.webToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebServerHostname": {
                return Optional.ofNullable(clazz.cast(this.webServerHostname()));
            }
            case "WebToken": {
                return Optional.ofNullable(clazz.cast(this.webToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWebLoginTokenResponse, T> g) {
        return obj -> g.apply((CreateWebLoginTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MwaaResponse.BuilderImpl
    implements Builder {
        private String webServerHostname;
        private String webToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWebLoginTokenResponse model) {
            super(model);
            this.webServerHostname(model.webServerHostname);
            this.webToken(model.webToken);
        }

        public final String getWebServerHostname() {
            return this.webServerHostname;
        }

        @Override
        public final Builder webServerHostname(String webServerHostname) {
            this.webServerHostname = webServerHostname;
            return this;
        }

        public final void setWebServerHostname(String webServerHostname) {
            this.webServerHostname = webServerHostname;
        }

        public final String getWebToken() {
            return this.webToken;
        }

        @Override
        public final Builder webToken(String webToken) {
            this.webToken = webToken;
            return this;
        }

        public final void setWebToken(String webToken) {
            this.webToken = webToken;
        }

        @Override
        public CreateWebLoginTokenResponse build() {
            return new CreateWebLoginTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MwaaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWebLoginTokenResponse> {
        public Builder webServerHostname(String var1);

        public Builder webToken(String var1);
    }
}

