/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mwaa.model.AirflowConfigurationOptionsCopier;
import software.amazon.awssdk.services.mwaa.model.EnvironmentStatus;
import software.amazon.awssdk.services.mwaa.model.LastUpdate;
import software.amazon.awssdk.services.mwaa.model.LoggingConfiguration;
import software.amazon.awssdk.services.mwaa.model.NetworkConfiguration;
import software.amazon.awssdk.services.mwaa.model.TagMapCopier;
import software.amazon.awssdk.services.mwaa.model.WebserverAccessMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Environment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Environment> {
    private static final SdkField<Map<String, String>> AIRFLOW_CONFIGURATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AirflowConfigurationOptions").getter(Environment.getter(Environment::airflowConfigurationOptions)).setter(Environment.setter(Builder::airflowConfigurationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowConfigurationOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> AIRFLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AirflowVersion").getter(Environment.getter(Environment::airflowVersion)).setter(Environment.setter(Builder::airflowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowVersion").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Environment.getter(Environment::arn)).setter(Environment.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(Environment.getter(Environment::createdAt)).setter(Environment.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> DAG_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DagS3Path").getter(Environment.getter(Environment::dagS3Path)).setter(Environment.setter(Builder::dagS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagS3Path").build()}).build();
    private static final SdkField<String> ENVIRONMENT_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentClass").getter(Environment.getter(Environment::environmentClass)).setter(Environment.setter(Builder::environmentClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentClass").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(Environment.getter(Environment::executionRoleArn)).setter(Environment.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKey").getter(Environment.getter(Environment::kmsKey)).setter(Environment.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()}).build();
    private static final SdkField<LastUpdate> LAST_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastUpdate").getter(Environment.getter(Environment::lastUpdate)).setter(Environment.setter(Builder::lastUpdate)).constructor(LastUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdate").build()}).build();
    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingConfiguration").getter(Environment.getter(Environment::loggingConfiguration)).setter(Environment.setter(Builder::loggingConfiguration)).constructor(LoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build()}).build();
    private static final SdkField<Integer> MAX_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxWorkers").getter(Environment.getter(Environment::maxWorkers)).setter(Environment.setter(Builder::maxWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWorkers").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Environment.getter(Environment::name)).setter(Environment.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfiguration").getter(Environment.getter(Environment::networkConfiguration)).setter(Environment.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build()}).build();
    private static final SdkField<String> PLUGINS_S3_OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PluginsS3ObjectVersion").getter(Environment.getter(Environment::pluginsS3ObjectVersion)).setter(Environment.setter(Builder::pluginsS3ObjectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginsS3ObjectVersion").build()}).build();
    private static final SdkField<String> PLUGINS_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PluginsS3Path").getter(Environment.getter(Environment::pluginsS3Path)).setter(Environment.setter(Builder::pluginsS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginsS3Path").build()}).build();
    private static final SdkField<String> REQUIREMENTS_S3_OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequirementsS3ObjectVersion").getter(Environment.getter(Environment::requirementsS3ObjectVersion)).setter(Environment.setter(Builder::requirementsS3ObjectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirementsS3ObjectVersion").build()}).build();
    private static final SdkField<String> REQUIREMENTS_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequirementsS3Path").getter(Environment.getter(Environment::requirementsS3Path)).setter(Environment.setter(Builder::requirementsS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirementsS3Path").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRoleArn").getter(Environment.getter(Environment::serviceRoleArn)).setter(Environment.setter(Builder::serviceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()}).build();
    private static final SdkField<String> SOURCE_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceBucketArn").getter(Environment.getter(Environment::sourceBucketArn)).setter(Environment.setter(Builder::sourceBucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBucketArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Environment.getter(Environment::statusAsString)).setter(Environment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Environment.getter(Environment::tags)).setter(Environment.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WEBSERVER_ACCESS_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebserverAccessMode").getter(Environment.getter(Environment::webserverAccessModeAsString)).setter(Environment.setter(Builder::webserverAccessMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverAccessMode").build()}).build();
    private static final SdkField<String> WEBSERVER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebserverUrl").getter(Environment.getter(Environment::webserverUrl)).setter(Environment.setter(Builder::webserverUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverUrl").build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_WINDOW_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceWindowStart").getter(Environment.getter(Environment::weeklyMaintenanceWindowStart)).setter(Environment.setter(Builder::weeklyMaintenanceWindowStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceWindowStart").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AIRFLOW_CONFIGURATION_OPTIONS_FIELD, AIRFLOW_VERSION_FIELD, ARN_FIELD, CREATED_AT_FIELD, DAG_S3_PATH_FIELD, ENVIRONMENT_CLASS_FIELD, EXECUTION_ROLE_ARN_FIELD, KMS_KEY_FIELD, LAST_UPDATE_FIELD, LOGGING_CONFIGURATION_FIELD, MAX_WORKERS_FIELD, NAME_FIELD, NETWORK_CONFIGURATION_FIELD, PLUGINS_S3_OBJECT_VERSION_FIELD, PLUGINS_S3_PATH_FIELD, REQUIREMENTS_S3_OBJECT_VERSION_FIELD, REQUIREMENTS_S3_PATH_FIELD, SERVICE_ROLE_ARN_FIELD, SOURCE_BUCKET_ARN_FIELD, STATUS_FIELD, TAGS_FIELD, WEBSERVER_ACCESS_MODE_FIELD, WEBSERVER_URL_FIELD, WEEKLY_MAINTENANCE_WINDOW_START_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> airflowConfigurationOptions;
    private final String airflowVersion;
    private final String arn;
    private final Instant createdAt;
    private final String dagS3Path;
    private final String environmentClass;
    private final String executionRoleArn;
    private final String kmsKey;
    private final LastUpdate lastUpdate;
    private final LoggingConfiguration loggingConfiguration;
    private final Integer maxWorkers;
    private final String name;
    private final NetworkConfiguration networkConfiguration;
    private final String pluginsS3ObjectVersion;
    private final String pluginsS3Path;
    private final String requirementsS3ObjectVersion;
    private final String requirementsS3Path;
    private final String serviceRoleArn;
    private final String sourceBucketArn;
    private final String status;
    private final Map<String, String> tags;
    private final String webserverAccessMode;
    private final String webserverUrl;
    private final String weeklyMaintenanceWindowStart;

    private Environment(BuilderImpl builder) {
        this.airflowConfigurationOptions = builder.airflowConfigurationOptions;
        this.airflowVersion = builder.airflowVersion;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.dagS3Path = builder.dagS3Path;
        this.environmentClass = builder.environmentClass;
        this.executionRoleArn = builder.executionRoleArn;
        this.kmsKey = builder.kmsKey;
        this.lastUpdate = builder.lastUpdate;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.maxWorkers = builder.maxWorkers;
        this.name = builder.name;
        this.networkConfiguration = builder.networkConfiguration;
        this.pluginsS3ObjectVersion = builder.pluginsS3ObjectVersion;
        this.pluginsS3Path = builder.pluginsS3Path;
        this.requirementsS3ObjectVersion = builder.requirementsS3ObjectVersion;
        this.requirementsS3Path = builder.requirementsS3Path;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.sourceBucketArn = builder.sourceBucketArn;
        this.status = builder.status;
        this.tags = builder.tags;
        this.webserverAccessMode = builder.webserverAccessMode;
        this.webserverUrl = builder.webserverUrl;
        this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
    }

    public final boolean hasAirflowConfigurationOptions() {
        return this.airflowConfigurationOptions != null && !(this.airflowConfigurationOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> airflowConfigurationOptions() {
        return this.airflowConfigurationOptions;
    }

    public final String airflowVersion() {
        return this.airflowVersion;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String dagS3Path() {
        return this.dagS3Path;
    }

    public final String environmentClass() {
        return this.environmentClass;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final LastUpdate lastUpdate() {
        return this.lastUpdate;
    }

    public final LoggingConfiguration loggingConfiguration() {
        return this.loggingConfiguration;
    }

    public final Integer maxWorkers() {
        return this.maxWorkers;
    }

    public final String name() {
        return this.name;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final String pluginsS3ObjectVersion() {
        return this.pluginsS3ObjectVersion;
    }

    public final String pluginsS3Path() {
        return this.pluginsS3Path;
    }

    public final String requirementsS3ObjectVersion() {
        return this.requirementsS3ObjectVersion;
    }

    public final String requirementsS3Path() {
        return this.requirementsS3Path;
    }

    public final String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public final String sourceBucketArn() {
        return this.sourceBucketArn;
    }

    public final EnvironmentStatus status() {
        return EnvironmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final WebserverAccessMode webserverAccessMode() {
        return WebserverAccessMode.fromValue(this.webserverAccessMode);
    }

    public final String webserverAccessModeAsString() {
        return this.webserverAccessMode;
    }

    public final String webserverUrl() {
        return this.webserverUrl;
    }

    public final String weeklyMaintenanceWindowStart() {
        return this.weeklyMaintenanceWindowStart;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAirflowConfigurationOptions() ? this.airflowConfigurationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.airflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dagS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginsS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.requirementsS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.requirementsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.webserverAccessModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.webserverUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceWindowStart());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)obj;
        return this.hasAirflowConfigurationOptions() == other.hasAirflowConfigurationOptions() && Objects.equals(this.airflowConfigurationOptions(), other.airflowConfigurationOptions()) && Objects.equals(this.airflowVersion(), other.airflowVersion()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.dagS3Path(), other.dagS3Path()) && Objects.equals(this.environmentClass(), other.environmentClass()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.lastUpdate(), other.lastUpdate()) && Objects.equals(this.loggingConfiguration(), other.loggingConfiguration()) && Objects.equals(this.maxWorkers(), other.maxWorkers()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.pluginsS3ObjectVersion(), other.pluginsS3ObjectVersion()) && Objects.equals(this.pluginsS3Path(), other.pluginsS3Path()) && Objects.equals(this.requirementsS3ObjectVersion(), other.requirementsS3ObjectVersion()) && Objects.equals(this.requirementsS3Path(), other.requirementsS3Path()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.sourceBucketArn(), other.sourceBucketArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.webserverAccessModeAsString(), other.webserverAccessModeAsString()) && Objects.equals(this.webserverUrl(), other.webserverUrl()) && Objects.equals(this.weeklyMaintenanceWindowStart(), other.weeklyMaintenanceWindowStart());
    }

    public final String toString() {
        return ToString.builder((String)"Environment").add("AirflowConfigurationOptions", this.hasAirflowConfigurationOptions() ? this.airflowConfigurationOptions() : null).add("AirflowVersion", (Object)this.airflowVersion()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("DagS3Path", (Object)this.dagS3Path()).add("EnvironmentClass", (Object)this.environmentClass()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("KmsKey", (Object)this.kmsKey()).add("LastUpdate", (Object)this.lastUpdate()).add("LoggingConfiguration", (Object)this.loggingConfiguration()).add("MaxWorkers", (Object)this.maxWorkers()).add("Name", (Object)this.name()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("PluginsS3ObjectVersion", (Object)this.pluginsS3ObjectVersion()).add("PluginsS3Path", (Object)this.pluginsS3Path()).add("RequirementsS3ObjectVersion", (Object)this.requirementsS3ObjectVersion()).add("RequirementsS3Path", (Object)this.requirementsS3Path()).add("ServiceRoleArn", (Object)this.serviceRoleArn()).add("SourceBucketArn", (Object)this.sourceBucketArn()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("WebserverAccessMode", (Object)this.webserverAccessModeAsString()).add("WebserverUrl", (Object)this.webserverUrl()).add("WeeklyMaintenanceWindowStart", (Object)this.weeklyMaintenanceWindowStart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AirflowConfigurationOptions": {
                return Optional.ofNullable(clazz.cast(this.airflowConfigurationOptions()));
            }
            case "AirflowVersion": {
                return Optional.ofNullable(clazz.cast(this.airflowVersion()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DagS3Path": {
                return Optional.ofNullable(clazz.cast(this.dagS3Path()));
            }
            case "EnvironmentClass": {
                return Optional.ofNullable(clazz.cast(this.environmentClass()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "KmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "LastUpdate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdate()));
            }
            case "LoggingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.loggingConfiguration()));
            }
            case "MaxWorkers": {
                return Optional.ofNullable(clazz.cast(this.maxWorkers()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NetworkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "PluginsS3ObjectVersion": {
                return Optional.ofNullable(clazz.cast(this.pluginsS3ObjectVersion()));
            }
            case "PluginsS3Path": {
                return Optional.ofNullable(clazz.cast(this.pluginsS3Path()));
            }
            case "RequirementsS3ObjectVersion": {
                return Optional.ofNullable(clazz.cast(this.requirementsS3ObjectVersion()));
            }
            case "RequirementsS3Path": {
                return Optional.ofNullable(clazz.cast(this.requirementsS3Path()));
            }
            case "ServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleArn()));
            }
            case "SourceBucketArn": {
                return Optional.ofNullable(clazz.cast(this.sourceBucketArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "WebserverAccessMode": {
                return Optional.ofNullable(clazz.cast(this.webserverAccessModeAsString()));
            }
            case "WebserverUrl": {
                return Optional.ofNullable(clazz.cast(this.webserverUrl()));
            }
            case "WeeklyMaintenanceWindowStart": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceWindowStart()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Environment, T> g) {
        return obj -> g.apply((Environment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> airflowConfigurationOptions = DefaultSdkAutoConstructMap.getInstance();
        private String airflowVersion;
        private String arn;
        private Instant createdAt;
        private String dagS3Path;
        private String environmentClass;
        private String executionRoleArn;
        private String kmsKey;
        private LastUpdate lastUpdate;
        private LoggingConfiguration loggingConfiguration;
        private Integer maxWorkers;
        private String name;
        private NetworkConfiguration networkConfiguration;
        private String pluginsS3ObjectVersion;
        private String pluginsS3Path;
        private String requirementsS3ObjectVersion;
        private String requirementsS3Path;
        private String serviceRoleArn;
        private String sourceBucketArn;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String webserverAccessMode;
        private String webserverUrl;
        private String weeklyMaintenanceWindowStart;

        private BuilderImpl() {
        }

        private BuilderImpl(Environment model) {
            this.airflowConfigurationOptions(model.airflowConfigurationOptions);
            this.airflowVersion(model.airflowVersion);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.dagS3Path(model.dagS3Path);
            this.environmentClass(model.environmentClass);
            this.executionRoleArn(model.executionRoleArn);
            this.kmsKey(model.kmsKey);
            this.lastUpdate(model.lastUpdate);
            this.loggingConfiguration(model.loggingConfiguration);
            this.maxWorkers(model.maxWorkers);
            this.name(model.name);
            this.networkConfiguration(model.networkConfiguration);
            this.pluginsS3ObjectVersion(model.pluginsS3ObjectVersion);
            this.pluginsS3Path(model.pluginsS3Path);
            this.requirementsS3ObjectVersion(model.requirementsS3ObjectVersion);
            this.requirementsS3Path(model.requirementsS3Path);
            this.serviceRoleArn(model.serviceRoleArn);
            this.sourceBucketArn(model.sourceBucketArn);
            this.status(model.status);
            this.tags(model.tags);
            this.webserverAccessMode(model.webserverAccessMode);
            this.webserverUrl(model.webserverUrl);
            this.weeklyMaintenanceWindowStart(model.weeklyMaintenanceWindowStart);
        }

        public final Map<String, String> getAirflowConfigurationOptions() {
            if (this.airflowConfigurationOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.airflowConfigurationOptions;
        }

        @Override
        public final Builder airflowConfigurationOptions(Map<String, String> airflowConfigurationOptions) {
            this.airflowConfigurationOptions = AirflowConfigurationOptionsCopier.copy(airflowConfigurationOptions);
            return this;
        }

        public final void setAirflowConfigurationOptions(Map<String, String> airflowConfigurationOptions) {
            this.airflowConfigurationOptions = AirflowConfigurationOptionsCopier.copy(airflowConfigurationOptions);
        }

        public final String getAirflowVersion() {
            return this.airflowVersion;
        }

        @Override
        public final Builder airflowVersion(String airflowVersion) {
            this.airflowVersion = airflowVersion;
            return this;
        }

        public final void setAirflowVersion(String airflowVersion) {
            this.airflowVersion = airflowVersion;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDagS3Path() {
            return this.dagS3Path;
        }

        @Override
        public final Builder dagS3Path(String dagS3Path) {
            this.dagS3Path = dagS3Path;
            return this;
        }

        public final void setDagS3Path(String dagS3Path) {
            this.dagS3Path = dagS3Path;
        }

        public final String getEnvironmentClass() {
            return this.environmentClass;
        }

        @Override
        public final Builder environmentClass(String environmentClass) {
            this.environmentClass = environmentClass;
            return this;
        }

        public final void setEnvironmentClass(String environmentClass) {
            this.environmentClass = environmentClass;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        public final LastUpdate.Builder getLastUpdate() {
            return this.lastUpdate != null ? this.lastUpdate.toBuilder() : null;
        }

        @Override
        public final Builder lastUpdate(LastUpdate lastUpdate) {
            this.lastUpdate = lastUpdate;
            return this;
        }

        public final void setLastUpdate(LastUpdate.BuilderImpl lastUpdate) {
            this.lastUpdate = lastUpdate != null ? lastUpdate.build() : null;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return this.loggingConfiguration != null ? this.loggingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        public final Integer getMaxWorkers() {
            return this.maxWorkers;
        }

        @Override
        public final Builder maxWorkers(Integer maxWorkers) {
            this.maxWorkers = maxWorkers;
            return this;
        }

        public final void setMaxWorkers(Integer maxWorkers) {
            this.maxWorkers = maxWorkers;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public final String getPluginsS3ObjectVersion() {
            return this.pluginsS3ObjectVersion;
        }

        @Override
        public final Builder pluginsS3ObjectVersion(String pluginsS3ObjectVersion) {
            this.pluginsS3ObjectVersion = pluginsS3ObjectVersion;
            return this;
        }

        public final void setPluginsS3ObjectVersion(String pluginsS3ObjectVersion) {
            this.pluginsS3ObjectVersion = pluginsS3ObjectVersion;
        }

        public final String getPluginsS3Path() {
            return this.pluginsS3Path;
        }

        @Override
        public final Builder pluginsS3Path(String pluginsS3Path) {
            this.pluginsS3Path = pluginsS3Path;
            return this;
        }

        public final void setPluginsS3Path(String pluginsS3Path) {
            this.pluginsS3Path = pluginsS3Path;
        }

        public final String getRequirementsS3ObjectVersion() {
            return this.requirementsS3ObjectVersion;
        }

        @Override
        public final Builder requirementsS3ObjectVersion(String requirementsS3ObjectVersion) {
            this.requirementsS3ObjectVersion = requirementsS3ObjectVersion;
            return this;
        }

        public final void setRequirementsS3ObjectVersion(String requirementsS3ObjectVersion) {
            this.requirementsS3ObjectVersion = requirementsS3ObjectVersion;
        }

        public final String getRequirementsS3Path() {
            return this.requirementsS3Path;
        }

        @Override
        public final Builder requirementsS3Path(String requirementsS3Path) {
            this.requirementsS3Path = requirementsS3Path;
            return this;
        }

        public final void setRequirementsS3Path(String requirementsS3Path) {
            this.requirementsS3Path = requirementsS3Path;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getSourceBucketArn() {
            return this.sourceBucketArn;
        }

        @Override
        public final Builder sourceBucketArn(String sourceBucketArn) {
            this.sourceBucketArn = sourceBucketArn;
            return this;
        }

        public final void setSourceBucketArn(String sourceBucketArn) {
            this.sourceBucketArn = sourceBucketArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getWebserverAccessMode() {
            return this.webserverAccessMode;
        }

        @Override
        public final Builder webserverAccessMode(String webserverAccessMode) {
            this.webserverAccessMode = webserverAccessMode;
            return this;
        }

        @Override
        public final Builder webserverAccessMode(WebserverAccessMode webserverAccessMode) {
            this.webserverAccessMode(webserverAccessMode == null ? null : webserverAccessMode.toString());
            return this;
        }

        public final void setWebserverAccessMode(String webserverAccessMode) {
            this.webserverAccessMode = webserverAccessMode;
        }

        public final String getWebserverUrl() {
            return this.webserverUrl;
        }

        @Override
        public final Builder webserverUrl(String webserverUrl) {
            this.webserverUrl = webserverUrl;
            return this;
        }

        public final void setWebserverUrl(String webserverUrl) {
            this.webserverUrl = webserverUrl;
        }

        public final String getWeeklyMaintenanceWindowStart() {
            return this.weeklyMaintenanceWindowStart;
        }

        @Override
        public final Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        public final void setWeeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
        }

        public Environment build() {
            return new Environment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Environment> {
        public Builder airflowConfigurationOptions(Map<String, String> var1);

        public Builder airflowVersion(String var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder dagS3Path(String var1);

        public Builder environmentClass(String var1);

        public Builder executionRoleArn(String var1);

        public Builder kmsKey(String var1);

        public Builder lastUpdate(LastUpdate var1);

        default public Builder lastUpdate(Consumer<LastUpdate.Builder> lastUpdate) {
            return this.lastUpdate((LastUpdate)((LastUpdate.Builder)LastUpdate.builder().applyMutation(lastUpdate)).build());
        }

        public Builder loggingConfiguration(LoggingConfiguration var1);

        default public Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return this.loggingConfiguration((LoggingConfiguration)((LoggingConfiguration.Builder)LoggingConfiguration.builder().applyMutation(loggingConfiguration)).build());
        }

        public Builder maxWorkers(Integer var1);

        public Builder name(String var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder pluginsS3ObjectVersion(String var1);

        public Builder pluginsS3Path(String var1);

        public Builder requirementsS3ObjectVersion(String var1);

        public Builder requirementsS3Path(String var1);

        public Builder serviceRoleArn(String var1);

        public Builder sourceBucketArn(String var1);

        public Builder status(String var1);

        public Builder status(EnvironmentStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder webserverAccessMode(String var1);

        public Builder webserverAccessMode(WebserverAccessMode var1);

        public Builder webserverUrl(String var1);

        public Builder weeklyMaintenanceWindowStart(String var1);
    }
}

