/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.services.mturk.model.QualificationRequirement;
import software.amazon.awssdk.services.mturk.model.QualificationRequirementListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHitTypeRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, CreateHitTypeRequest> {
    private static final SdkField<Long> AUTO_APPROVAL_DELAY_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(CreateHitTypeRequest.getter(CreateHitTypeRequest::autoApprovalDelayInSeconds)).setter(CreateHitTypeRequest.setter(Builder::autoApprovalDelayInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoApprovalDelayInSeconds").build()}).build();
    private static final SdkField<Long> ASSIGNMENT_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(CreateHitTypeRequest.getter(CreateHitTypeRequest::assignmentDurationInSeconds)).setter(CreateHitTypeRequest.setter(Builder::assignmentDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentDurationInSeconds").build()}).build();
    private static final SdkField<String> REWARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateHitTypeRequest.getter(CreateHitTypeRequest::reward)).setter(CreateHitTypeRequest.setter(Builder::reward)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reward").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateHitTypeRequest.getter(CreateHitTypeRequest::title)).setter(CreateHitTypeRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateHitTypeRequest.getter(CreateHitTypeRequest::keywords)).setter(CreateHitTypeRequest.setter(Builder::keywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keywords").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateHitTypeRequest.getter(CreateHitTypeRequest::description)).setter(CreateHitTypeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<QualificationRequirement>> QUALIFICATION_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateHitTypeRequest.getter(CreateHitTypeRequest::qualificationRequirements)).setter(CreateHitTypeRequest.setter(Builder::qualificationRequirements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationRequirements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QualificationRequirement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_APPROVAL_DELAY_IN_SECONDS_FIELD, ASSIGNMENT_DURATION_IN_SECONDS_FIELD, REWARD_FIELD, TITLE_FIELD, KEYWORDS_FIELD, DESCRIPTION_FIELD, QUALIFICATION_REQUIREMENTS_FIELD));
    private final Long autoApprovalDelayInSeconds;
    private final Long assignmentDurationInSeconds;
    private final String reward;
    private final String title;
    private final String keywords;
    private final String description;
    private final List<QualificationRequirement> qualificationRequirements;

    private CreateHitTypeRequest(BuilderImpl builder) {
        super(builder);
        this.autoApprovalDelayInSeconds = builder.autoApprovalDelayInSeconds;
        this.assignmentDurationInSeconds = builder.assignmentDurationInSeconds;
        this.reward = builder.reward;
        this.title = builder.title;
        this.keywords = builder.keywords;
        this.description = builder.description;
        this.qualificationRequirements = builder.qualificationRequirements;
    }

    public Long autoApprovalDelayInSeconds() {
        return this.autoApprovalDelayInSeconds;
    }

    public Long assignmentDurationInSeconds() {
        return this.assignmentDurationInSeconds;
    }

    public String reward() {
        return this.reward;
    }

    public String title() {
        return this.title;
    }

    public String keywords() {
        return this.keywords;
    }

    public String description() {
        return this.description;
    }

    public List<QualificationRequirement> qualificationRequirements() {
        return this.qualificationRequirements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoApprovalDelayInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.reward());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.keywords());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualificationRequirements());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHitTypeRequest)) {
            return false;
        }
        CreateHitTypeRequest other = (CreateHitTypeRequest)((Object)obj);
        return Objects.equals(this.autoApprovalDelayInSeconds(), other.autoApprovalDelayInSeconds()) && Objects.equals(this.assignmentDurationInSeconds(), other.assignmentDurationInSeconds()) && Objects.equals(this.reward(), other.reward()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.keywords(), other.keywords()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.qualificationRequirements(), other.qualificationRequirements());
    }

    public String toString() {
        return ToString.builder((String)"CreateHitTypeRequest").add("AutoApprovalDelayInSeconds", (Object)this.autoApprovalDelayInSeconds()).add("AssignmentDurationInSeconds", (Object)this.assignmentDurationInSeconds()).add("Reward", (Object)this.reward()).add("Title", (Object)this.title()).add("Keywords", (Object)this.keywords()).add("Description", (Object)this.description()).add("QualificationRequirements", this.qualificationRequirements()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoApprovalDelayInSeconds": {
                return Optional.ofNullable(clazz.cast(this.autoApprovalDelayInSeconds()));
            }
            case "AssignmentDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.assignmentDurationInSeconds()));
            }
            case "Reward": {
                return Optional.ofNullable(clazz.cast(this.reward()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Keywords": {
                return Optional.ofNullable(clazz.cast(this.keywords()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "QualificationRequirements": {
                return Optional.ofNullable(clazz.cast(this.qualificationRequirements()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHitTypeRequest, T> g) {
        return obj -> g.apply((CreateHitTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private Long autoApprovalDelayInSeconds;
        private Long assignmentDurationInSeconds;
        private String reward;
        private String title;
        private String keywords;
        private String description;
        private List<QualificationRequirement> qualificationRequirements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHitTypeRequest model) {
            super(model);
            this.autoApprovalDelayInSeconds(model.autoApprovalDelayInSeconds);
            this.assignmentDurationInSeconds(model.assignmentDurationInSeconds);
            this.reward(model.reward);
            this.title(model.title);
            this.keywords(model.keywords);
            this.description(model.description);
            this.qualificationRequirements(model.qualificationRequirements);
        }

        public final Long getAutoApprovalDelayInSeconds() {
            return this.autoApprovalDelayInSeconds;
        }

        @Override
        public final Builder autoApprovalDelayInSeconds(Long autoApprovalDelayInSeconds) {
            this.autoApprovalDelayInSeconds = autoApprovalDelayInSeconds;
            return this;
        }

        public final void setAutoApprovalDelayInSeconds(Long autoApprovalDelayInSeconds) {
            this.autoApprovalDelayInSeconds = autoApprovalDelayInSeconds;
        }

        public final Long getAssignmentDurationInSeconds() {
            return this.assignmentDurationInSeconds;
        }

        @Override
        public final Builder assignmentDurationInSeconds(Long assignmentDurationInSeconds) {
            this.assignmentDurationInSeconds = assignmentDurationInSeconds;
            return this;
        }

        public final void setAssignmentDurationInSeconds(Long assignmentDurationInSeconds) {
            this.assignmentDurationInSeconds = assignmentDurationInSeconds;
        }

        public final String getReward() {
            return this.reward;
        }

        @Override
        public final Builder reward(String reward) {
            this.reward = reward;
            return this;
        }

        public final void setReward(String reward) {
            this.reward = reward;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getKeywords() {
            return this.keywords;
        }

        @Override
        public final Builder keywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        public final void setKeywords(String keywords) {
            this.keywords = keywords;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<QualificationRequirement.Builder> getQualificationRequirements() {
            return this.qualificationRequirements != null ? (Collection)this.qualificationRequirements.stream().map(QualificationRequirement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder qualificationRequirements(Collection<QualificationRequirement> qualificationRequirements) {
            this.qualificationRequirements = QualificationRequirementListCopier.copy(qualificationRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationRequirements(QualificationRequirement ... qualificationRequirements) {
            this.qualificationRequirements(Arrays.asList(qualificationRequirements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationRequirements(Consumer<QualificationRequirement.Builder> ... qualificationRequirements) {
            this.qualificationRequirements(Stream.of(qualificationRequirements).map(c -> (QualificationRequirement)((QualificationRequirement.Builder)QualificationRequirement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQualificationRequirements(Collection<QualificationRequirement.BuilderImpl> qualificationRequirements) {
            this.qualificationRequirements = QualificationRequirementListCopier.copyFromBuilder(qualificationRequirements);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHitTypeRequest build() {
            return new CreateHitTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHitTypeRequest> {
        public Builder autoApprovalDelayInSeconds(Long var1);

        public Builder assignmentDurationInSeconds(Long var1);

        public Builder reward(String var1);

        public Builder title(String var1);

        public Builder keywords(String var1);

        public Builder description(String var1);

        public Builder qualificationRequirements(Collection<QualificationRequirement> var1);

        public Builder qualificationRequirements(QualificationRequirement ... var1);

        public Builder qualificationRequirements(Consumer<QualificationRequirement.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

