/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkClient;
import software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest;
import software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse;

public class ListQualificationRequestsIterable
implements SdkIterable<ListQualificationRequestsResponse> {
    private final MTurkClient client;
    private final ListQualificationRequestsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQualificationRequestsIterable(MTurkClient client, ListQualificationRequestsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListQualificationRequestsResponseFetcher();
    }

    public Iterator<ListQualificationRequestsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListQualificationRequestsIterable resume(ListQualificationRequestsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListQualificationRequestsIterable(this.client, (ListQualificationRequestsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListQualificationRequestsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListQualificationRequestsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListQualificationRequestsResponseFetcher
    implements SyncPageFetcher<ListQualificationRequestsResponse> {
        private ListQualificationRequestsResponseFetcher() {
        }

        public boolean hasNextPage(ListQualificationRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListQualificationRequestsResponse nextPage(ListQualificationRequestsResponse previousPage) {
            if (previousPage == null) {
                return ListQualificationRequestsIterable.this.client.listQualificationRequests(ListQualificationRequestsIterable.this.firstRequest);
            }
            return ListQualificationRequestsIterable.this.client.listQualificationRequests((ListQualificationRequestsRequest)((Object)ListQualificationRequestsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

