/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkAsyncClient;
import software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeResponse;

public class ListHITsForQualificationTypePublisher
implements SdkPublisher<ListHiTsForQualificationTypeResponse> {
    private final MTurkAsyncClient client;
    private final ListHiTsForQualificationTypeRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListHITsForQualificationTypePublisher(MTurkAsyncClient client, ListHiTsForQualificationTypeRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListHITsForQualificationTypePublisher(MTurkAsyncClient client, ListHiTsForQualificationTypeRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListHiTsForQualificationTypeResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListHiTsForQualificationTypeResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListHITsForQualificationTypePublisher resume(ListHiTsForQualificationTypeResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListHITsForQualificationTypePublisher(this.client, (ListHiTsForQualificationTypeRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListHITsForQualificationTypePublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListHiTsForQualificationTypeResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListHiTsForQualificationTypeResponseFetcher
    implements AsyncPageFetcher<ListHiTsForQualificationTypeResponse> {
        private ListHiTsForQualificationTypeResponseFetcher() {
        }

        public boolean hasNextPage(ListHiTsForQualificationTypeResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListHiTsForQualificationTypeResponse> nextPage(ListHiTsForQualificationTypeResponse previousPage) {
            if (previousPage == null) {
                return ListHITsForQualificationTypePublisher.this.client.listHITsForQualificationType(ListHITsForQualificationTypePublisher.this.firstRequest);
            }
            return ListHITsForQualificationTypePublisher.this.client.listHITsForQualificationType((ListHiTsForQualificationTypeRequest)((Object)ListHITsForQualificationTypePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

