/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.AvailabilityZone;
import software.amazon.awssdk.services.mq.model.EngineType;
import software.amazon.awssdk.services.mq.model.___listOfAvailabilityZoneCopier;
import software.amazon.awssdk.services.mq.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrokerInstanceOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrokerInstanceOption> {
    private static final SdkField<List<AvailabilityZone>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BrokerInstanceOption.getter(BrokerInstanceOption::availabilityZones)).setter(BrokerInstanceOption.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailabilityZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BrokerInstanceOption.getter(BrokerInstanceOption::engineTypeAsString)).setter(BrokerInstanceOption.setter(Builder::engineType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()}).build();
    private static final SdkField<String> HOST_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BrokerInstanceOption.getter(BrokerInstanceOption::hostInstanceType)).setter(BrokerInstanceOption.setter(Builder::hostInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostInstanceType").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_ENGINE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BrokerInstanceOption.getter(BrokerInstanceOption::supportedEngineVersions)).setter(BrokerInstanceOption.setter(Builder::supportedEngineVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedEngineVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD, ENGINE_TYPE_FIELD, HOST_INSTANCE_TYPE_FIELD, SUPPORTED_ENGINE_VERSIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AvailabilityZone> availabilityZones;
    private final String engineType;
    private final String hostInstanceType;
    private final List<String> supportedEngineVersions;

    private BrokerInstanceOption(BuilderImpl builder) {
        this.availabilityZones = builder.availabilityZones;
        this.engineType = builder.engineType;
        this.hostInstanceType = builder.hostInstanceType;
        this.supportedEngineVersions = builder.supportedEngineVersions;
    }

    public List<AvailabilityZone> availabilityZones() {
        return this.availabilityZones;
    }

    public EngineType engineType() {
        return EngineType.fromValue(this.engineType);
    }

    public String engineTypeAsString() {
        return this.engineType;
    }

    public String hostInstanceType() {
        return this.hostInstanceType;
    }

    public List<String> supportedEngineVersions() {
        return this.supportedEngineVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedEngineVersions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerInstanceOption)) {
            return false;
        }
        BrokerInstanceOption other = (BrokerInstanceOption)obj;
        return Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.engineTypeAsString(), other.engineTypeAsString()) && Objects.equals(this.hostInstanceType(), other.hostInstanceType()) && Objects.equals(this.supportedEngineVersions(), other.supportedEngineVersions());
    }

    public String toString() {
        return ToString.builder((String)"BrokerInstanceOption").add("AvailabilityZones", this.availabilityZones()).add("EngineType", (Object)this.engineTypeAsString()).add("HostInstanceType", (Object)this.hostInstanceType()).add("SupportedEngineVersions", this.supportedEngineVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "EngineType": {
                return Optional.ofNullable(clazz.cast(this.engineTypeAsString()));
            }
            case "HostInstanceType": {
                return Optional.ofNullable(clazz.cast(this.hostInstanceType()));
            }
            case "SupportedEngineVersions": {
                return Optional.ofNullable(clazz.cast(this.supportedEngineVersions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BrokerInstanceOption, T> g) {
        return obj -> g.apply((BrokerInstanceOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AvailabilityZone> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private String engineType;
        private String hostInstanceType;
        private List<String> supportedEngineVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerInstanceOption model) {
            this.availabilityZones(model.availabilityZones);
            this.engineType(model.engineType);
            this.hostInstanceType(model.hostInstanceType);
            this.supportedEngineVersions(model.supportedEngineVersions);
        }

        public final Collection<AvailabilityZone.Builder> getAvailabilityZones() {
            return this.availabilityZones != null ? (Collection)this.availabilityZones.stream().map(AvailabilityZone::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = ___listOfAvailabilityZoneCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... availabilityZones) {
            this.availabilityZones(Stream.of(availabilityZones).map(c -> (AvailabilityZone)((AvailabilityZone.Builder)AvailabilityZone.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = ___listOfAvailabilityZoneCopier.copyFromBuilder(availabilityZones);
        }

        public final String getEngineTypeAsString() {
            return this.engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        public final String getHostInstanceType() {
            return this.hostInstanceType;
        }

        @Override
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        public final Collection<String> getSupportedEngineVersions() {
            return this.supportedEngineVersions;
        }

        @Override
        public final Builder supportedEngineVersions(Collection<String> supportedEngineVersions) {
            this.supportedEngineVersions = ___listOf__stringCopier.copy(supportedEngineVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEngineVersions(String ... supportedEngineVersions) {
            this.supportedEngineVersions(Arrays.asList(supportedEngineVersions));
            return this;
        }

        public final void setSupportedEngineVersions(Collection<String> supportedEngineVersions) {
            this.supportedEngineVersions = ___listOf__stringCopier.copy(supportedEngineVersions);
        }

        public BrokerInstanceOption build() {
            return new BrokerInstanceOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrokerInstanceOption> {
        public Builder availabilityZones(Collection<AvailabilityZone> var1);

        public Builder availabilityZones(AvailabilityZone ... var1);

        public Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... var1);

        public Builder engineType(String var1);

        public Builder engineType(EngineType var1);

        public Builder hostInstanceType(String var1);

        public Builder supportedEngineVersions(Collection<String> var1);

        public Builder supportedEngineVersions(String ... var1);
    }
}

