/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mq.model.MqRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteUserRequest
extends MqRequest
implements ToCopyableBuilder<Builder, DeleteUserRequest> {
    private static final SdkField<String> BROKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteUserRequest.getter(DeleteUserRequest::brokerId)).setter(DeleteUserRequest.setter(Builder::brokerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("broker-id").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteUserRequest.getter(DeleteUserRequest::username)).setter(DeleteUserRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("username").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_ID_FIELD, USERNAME_FIELD));
    private final String brokerId;
    private final String username;

    private DeleteUserRequest(BuilderImpl builder) {
        super(builder);
        this.brokerId = builder.brokerId;
        this.username = builder.username;
    }

    public String brokerId() {
        return this.brokerId;
    }

    public String username() {
        return this.username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteUserRequest)) {
            return false;
        }
        DeleteUserRequest other = (DeleteUserRequest)((Object)obj);
        return Objects.equals(this.brokerId(), other.brokerId()) && Objects.equals(this.username(), other.username());
    }

    public String toString() {
        return ToString.builder((String)"DeleteUserRequest").add("BrokerId", (Object)this.brokerId()).add("Username", (Object)this.username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerId": {
                return Optional.ofNullable(clazz.cast(this.brokerId()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteUserRequest, T> g) {
        return obj -> g.apply((DeleteUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MqRequest.BuilderImpl
    implements Builder {
        private String brokerId;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteUserRequest model) {
            super(model);
            this.brokerId(model.brokerId);
            this.username(model.username);
        }

        public final String getBrokerId() {
            return this.brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteUserRequest build() {
            return new DeleteUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MqRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteUserRequest> {
        public Builder brokerId(String var1);

        public Builder username(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

