/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mq.model.ChangeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserSummary> {
    private static final SdkField<String> PENDING_CHANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UserSummary.getter(UserSummary::pendingChangeAsString)).setter(UserSummary.setter(Builder::pendingChange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingChange").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UserSummary.getter(UserSummary::username)).setter(UserSummary.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PENDING_CHANGE_FIELD, USERNAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pendingChange;
    private final String username;

    private UserSummary(BuilderImpl builder) {
        this.pendingChange = builder.pendingChange;
        this.username = builder.username;
    }

    public ChangeType pendingChange() {
        return ChangeType.fromValue(this.pendingChange);
    }

    public String pendingChangeAsString() {
        return this.pendingChange;
    }

    public String username() {
        return this.username;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingChangeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSummary)) {
            return false;
        }
        UserSummary other = (UserSummary)obj;
        return Objects.equals(this.pendingChangeAsString(), other.pendingChangeAsString()) && Objects.equals(this.username(), other.username());
    }

    public String toString() {
        return ToString.builder((String)"UserSummary").add("PendingChange", (Object)this.pendingChangeAsString()).add("Username", (Object)this.username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PendingChange": {
                return Optional.ofNullable(clazz.cast(this.pendingChangeAsString()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserSummary, T> g) {
        return obj -> g.apply((UserSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pendingChange;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSummary model) {
            this.pendingChange(model.pendingChange);
            this.username(model.username);
        }

        public final String getPendingChange() {
            return this.pendingChange;
        }

        @Override
        public final Builder pendingChange(String pendingChange) {
            this.pendingChange = pendingChange;
            return this;
        }

        @Override
        public final Builder pendingChange(ChangeType pendingChange) {
            this.pendingChange(pendingChange == null ? null : pendingChange.toString());
            return this;
        }

        public final void setPendingChange(String pendingChange) {
            this.pendingChange = pendingChange;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public UserSummary build() {
            return new UserSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserSummary> {
        public Builder pendingChange(String var1);

        public Builder pendingChange(ChangeType var1);

        public Builder username(String var1);
    }
}

