/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mpa.model.ApprovalStrategyResponse;
import software.amazon.awssdk.services.mpa.model.ApprovalTeamStatus;
import software.amazon.awssdk.services.mpa.model.ApprovalTeamStatusCode;
import software.amazon.awssdk.services.mpa.model.GetApprovalTeamResponseApprover;
import software.amazon.awssdk.services.mpa.model.GetApprovalTeamResponseApproversCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PendingUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PendingUpdate> {
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionId").getter(PendingUpdate.getter(PendingUpdate::versionId)).setter(PendingUpdate.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(PendingUpdate.getter(PendingUpdate::description)).setter(PendingUpdate.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ApprovalStrategyResponse> APPROVAL_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApprovalStrategy").getter(PendingUpdate.getter(PendingUpdate::approvalStrategy)).setter(PendingUpdate.setter(Builder::approvalStrategy)).constructor(ApprovalStrategyResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalStrategy").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_APPROVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfApprovers").getter(PendingUpdate.getter(PendingUpdate::numberOfApprovers)).setter(PendingUpdate.setter(Builder::numberOfApprovers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfApprovers").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(PendingUpdate.getter(PendingUpdate::statusAsString)).setter(PendingUpdate.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusCode").getter(PendingUpdate.getter(PendingUpdate::statusCodeAsString)).setter(PendingUpdate.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(PendingUpdate.getter(PendingUpdate::statusMessage)).setter(PendingUpdate.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<List<GetApprovalTeamResponseApprover>> APPROVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Approvers").getter(PendingUpdate.getter(PendingUpdate::approvers)).setter(PendingUpdate.setter(Builder::approvers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Approvers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetApprovalTeamResponseApprover::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATE_INITIATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateInitiationTime").getter(PendingUpdate.getter(PendingUpdate::updateInitiationTime)).setter(PendingUpdate.setter(Builder::updateInitiationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateInitiationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_ID_FIELD, DESCRIPTION_FIELD, APPROVAL_STRATEGY_FIELD, NUMBER_OF_APPROVERS_FIELD, STATUS_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, APPROVERS_FIELD, UPDATE_INITIATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PendingUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String versionId;
    private final String description;
    private final ApprovalStrategyResponse approvalStrategy;
    private final Integer numberOfApprovers;
    private final String status;
    private final String statusCode;
    private final String statusMessage;
    private final List<GetApprovalTeamResponseApprover> approvers;
    private final Instant updateInitiationTime;

    private PendingUpdate(BuilderImpl builder) {
        this.versionId = builder.versionId;
        this.description = builder.description;
        this.approvalStrategy = builder.approvalStrategy;
        this.numberOfApprovers = builder.numberOfApprovers;
        this.status = builder.status;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.approvers = builder.approvers;
        this.updateInitiationTime = builder.updateInitiationTime;
    }

    public final String versionId() {
        return this.versionId;
    }

    public final String description() {
        return this.description;
    }

    public final ApprovalStrategyResponse approvalStrategy() {
        return this.approvalStrategy;
    }

    public final Integer numberOfApprovers() {
        return this.numberOfApprovers;
    }

    public final ApprovalTeamStatus status() {
        return ApprovalTeamStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ApprovalTeamStatusCode statusCode() {
        return ApprovalTeamStatusCode.fromValue(this.statusCode);
    }

    public final String statusCodeAsString() {
        return this.statusCode;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final boolean hasApprovers() {
        return this.approvers != null && !(this.approvers instanceof SdkAutoConstructList);
    }

    public final List<GetApprovalTeamResponseApprover> approvers() {
        return this.approvers;
    }

    public final Instant updateInitiationTime() {
        return this.updateInitiationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfApprovers());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApprovers() ? this.approvers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateInitiationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingUpdate)) {
            return false;
        }
        PendingUpdate other = (PendingUpdate)obj;
        return Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.approvalStrategy(), other.approvalStrategy()) && Objects.equals(this.numberOfApprovers(), other.numberOfApprovers()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && this.hasApprovers() == other.hasApprovers() && Objects.equals(this.approvers(), other.approvers()) && Objects.equals(this.updateInitiationTime(), other.updateInitiationTime());
    }

    public final String toString() {
        return ToString.builder((String)"PendingUpdate").add("VersionId", (Object)this.versionId()).add("Description", (Object)this.description()).add("ApprovalStrategy", (Object)this.approvalStrategy()).add("NumberOfApprovers", (Object)this.numberOfApprovers()).add("Status", (Object)this.statusAsString()).add("StatusCode", (Object)this.statusCodeAsString()).add("StatusMessage", (Object)this.statusMessage()).add("Approvers", this.hasApprovers() ? this.approvers() : null).add("UpdateInitiationTime", (Object)this.updateInitiationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ApprovalStrategy": {
                return Optional.ofNullable(clazz.cast(this.approvalStrategy()));
            }
            case "NumberOfApprovers": {
                return Optional.ofNullable(clazz.cast(this.numberOfApprovers()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "Approvers": {
                return Optional.ofNullable(clazz.cast(this.approvers()));
            }
            case "UpdateInitiationTime": {
                return Optional.ofNullable(clazz.cast(this.updateInitiationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VersionId", VERSION_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ApprovalStrategy", APPROVAL_STRATEGY_FIELD);
        map.put("NumberOfApprovers", NUMBER_OF_APPROVERS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("Approvers", APPROVERS_FIELD);
        map.put("UpdateInitiationTime", UPDATE_INITIATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PendingUpdate, T> g) {
        return obj -> g.apply((PendingUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String versionId;
        private String description;
        private ApprovalStrategyResponse approvalStrategy;
        private Integer numberOfApprovers;
        private String status;
        private String statusCode;
        private String statusMessage;
        private List<GetApprovalTeamResponseApprover> approvers = DefaultSdkAutoConstructList.getInstance();
        private Instant updateInitiationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingUpdate model) {
            this.versionId(model.versionId);
            this.description(model.description);
            this.approvalStrategy(model.approvalStrategy);
            this.numberOfApprovers(model.numberOfApprovers);
            this.status(model.status);
            this.statusCode(model.statusCode);
            this.statusMessage(model.statusMessage);
            this.approvers(model.approvers);
            this.updateInitiationTime(model.updateInitiationTime);
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ApprovalStrategyResponse.Builder getApprovalStrategy() {
            return this.approvalStrategy != null ? this.approvalStrategy.toBuilder() : null;
        }

        public final void setApprovalStrategy(ApprovalStrategyResponse.BuilderImpl approvalStrategy) {
            this.approvalStrategy = approvalStrategy != null ? approvalStrategy.build() : null;
        }

        @Override
        public final Builder approvalStrategy(ApprovalStrategyResponse approvalStrategy) {
            this.approvalStrategy = approvalStrategy;
            return this;
        }

        public final Integer getNumberOfApprovers() {
            return this.numberOfApprovers;
        }

        public final void setNumberOfApprovers(Integer numberOfApprovers) {
            this.numberOfApprovers = numberOfApprovers;
        }

        @Override
        public final Builder numberOfApprovers(Integer numberOfApprovers) {
            this.numberOfApprovers = numberOfApprovers;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApprovalTeamStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(ApprovalTeamStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final List<GetApprovalTeamResponseApprover.Builder> getApprovers() {
            List<GetApprovalTeamResponseApprover.Builder> result = GetApprovalTeamResponseApproversCopier.copyToBuilder(this.approvers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApprovers(Collection<GetApprovalTeamResponseApprover.BuilderImpl> approvers) {
            this.approvers = GetApprovalTeamResponseApproversCopier.copyFromBuilder(approvers);
        }

        @Override
        public final Builder approvers(Collection<GetApprovalTeamResponseApprover> approvers) {
            this.approvers = GetApprovalTeamResponseApproversCopier.copy(approvers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvers(GetApprovalTeamResponseApprover ... approvers) {
            this.approvers(Arrays.asList(approvers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvers(Consumer<GetApprovalTeamResponseApprover.Builder> ... approvers) {
            this.approvers(Stream.of(approvers).map(c -> (GetApprovalTeamResponseApprover)((GetApprovalTeamResponseApprover.Builder)GetApprovalTeamResponseApprover.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getUpdateInitiationTime() {
            return this.updateInitiationTime;
        }

        public final void setUpdateInitiationTime(Instant updateInitiationTime) {
            this.updateInitiationTime = updateInitiationTime;
        }

        @Override
        public final Builder updateInitiationTime(Instant updateInitiationTime) {
            this.updateInitiationTime = updateInitiationTime;
            return this;
        }

        public PendingUpdate build() {
            return new PendingUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PendingUpdate> {
        public Builder versionId(String var1);

        public Builder description(String var1);

        public Builder approvalStrategy(ApprovalStrategyResponse var1);

        default public Builder approvalStrategy(Consumer<ApprovalStrategyResponse.Builder> approvalStrategy) {
            return this.approvalStrategy((ApprovalStrategyResponse)((ApprovalStrategyResponse.Builder)ApprovalStrategyResponse.builder().applyMutation(approvalStrategy)).build());
        }

        public Builder numberOfApprovers(Integer var1);

        public Builder status(String var1);

        public Builder status(ApprovalTeamStatus var1);

        public Builder statusCode(String var1);

        public Builder statusCode(ApprovalTeamStatusCode var1);

        public Builder statusMessage(String var1);

        public Builder approvers(Collection<GetApprovalTeamResponseApprover> var1);

        public Builder approvers(GetApprovalTeamResponseApprover ... var1);

        public Builder approvers(Consumer<GetApprovalTeamResponseApprover.Builder> ... var1);

        public Builder updateInitiationTime(Instant var1);
    }
}

