/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for an approval session. For more information, see <a
 * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-health.html">Session</a> in the <i>Multi-party approval
 * User Guide</i>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSessionsResponseSession implements SdkPojo, Serializable,
        ToCopyableBuilder<ListSessionsResponseSession.Builder, ListSessionsResponseSession> {
    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionArn").getter(getter(ListSessionsResponseSession::sessionArn)).setter(setter(Builder::sessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionArn").build()).build();

    private static final SdkField<String> APPROVAL_TEAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApprovalTeamName").getter(getter(ListSessionsResponseSession::approvalTeamName))
            .setter(setter(Builder::approvalTeamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalTeamName").build()).build();

    private static final SdkField<String> APPROVAL_TEAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApprovalTeamArn").getter(getter(ListSessionsResponseSession::approvalTeamArn))
            .setter(setter(Builder::approvalTeamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalTeamArn").build()).build();

    private static final SdkField<Instant> INITIATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("InitiationTime")
            .getter(getter(ListSessionsResponseSession::initiationTime))
            .setter(setter(Builder::initiationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationTime")
            .getter(getter(ListSessionsResponseSession::expirationTime))
            .setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTime")
            .getter(getter(ListSessionsResponseSession::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ListSessionsResponseSession::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionName").getter(getter(ListSessionsResponseSession::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build()).build();

    private static final SdkField<String> PROTECTED_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectedResourceArn").getter(getter(ListSessionsResponseSession::protectedResourceArn))
            .setter(setter(Builder::protectedResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceArn").build())
            .build();

    private static final SdkField<String> REQUESTER_SERVICE_PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequesterServicePrincipal").getter(getter(ListSessionsResponseSession::requesterServicePrincipal))
            .setter(setter(Builder::requesterServicePrincipal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterServicePrincipal").build())
            .build();

    private static final SdkField<String> REQUESTER_PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequesterPrincipalArn").getter(getter(ListSessionsResponseSession::requesterPrincipalArn))
            .setter(setter(Builder::requesterPrincipalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPrincipalArn").build())
            .build();

    private static final SdkField<String> REQUESTER_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequesterRegion").getter(getter(ListSessionsResponseSession::requesterRegion))
            .setter(setter(Builder::requesterRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterRegion").build()).build();

    private static final SdkField<String> REQUESTER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequesterAccountId").getter(getter(ListSessionsResponseSession::requesterAccountId))
            .setter(setter(Builder::requesterAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterAccountId").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListSessionsResponseSession::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusCode").getter(getter(ListSessionsResponseSession::statusCodeAsString))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ListSessionsResponseSession::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> ACTION_COMPLETION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionCompletionStrategy").getter(getter(ListSessionsResponseSession::actionCompletionStrategyAsString))
            .setter(setter(Builder::actionCompletionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionCompletionStrategy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ARN_FIELD,
            APPROVAL_TEAM_NAME_FIELD, APPROVAL_TEAM_ARN_FIELD, INITIATION_TIME_FIELD, EXPIRATION_TIME_FIELD,
            COMPLETION_TIME_FIELD, DESCRIPTION_FIELD, ACTION_NAME_FIELD, PROTECTED_RESOURCE_ARN_FIELD,
            REQUESTER_SERVICE_PRINCIPAL_FIELD, REQUESTER_PRINCIPAL_ARN_FIELD, REQUESTER_REGION_FIELD, REQUESTER_ACCOUNT_ID_FIELD,
            STATUS_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, ACTION_COMPLETION_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sessionArn;

    private final String approvalTeamName;

    private final String approvalTeamArn;

    private final Instant initiationTime;

    private final Instant expirationTime;

    private final Instant completionTime;

    private final String description;

    private final String actionName;

    private final String protectedResourceArn;

    private final String requesterServicePrincipal;

    private final String requesterPrincipalArn;

    private final String requesterRegion;

    private final String requesterAccountId;

    private final String status;

    private final String statusCode;

    private final String statusMessage;

    private final String actionCompletionStrategy;

    private ListSessionsResponseSession(BuilderImpl builder) {
        this.sessionArn = builder.sessionArn;
        this.approvalTeamName = builder.approvalTeamName;
        this.approvalTeamArn = builder.approvalTeamArn;
        this.initiationTime = builder.initiationTime;
        this.expirationTime = builder.expirationTime;
        this.completionTime = builder.completionTime;
        this.description = builder.description;
        this.actionName = builder.actionName;
        this.protectedResourceArn = builder.protectedResourceArn;
        this.requesterServicePrincipal = builder.requesterServicePrincipal;
        this.requesterPrincipalArn = builder.requesterPrincipalArn;
        this.requesterRegion = builder.requesterRegion;
        this.requesterAccountId = builder.requesterAccountId;
        this.status = builder.status;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.actionCompletionStrategy = builder.actionCompletionStrategy;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the session.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the session.
     */
    public final String sessionArn() {
        return sessionArn;
    }

    /**
     * <p>
     * Name of the approval team.
     * </p>
     * 
     * @return Name of the approval team.
     */
    public final String approvalTeamName() {
        return approvalTeamName;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the approval team.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the approval team.
     */
    public final String approvalTeamArn() {
        return approvalTeamArn;
    }

    /**
     * <p>
     * Timestamp when the session was initiated.
     * </p>
     * 
     * @return Timestamp when the session was initiated.
     */
    public final Instant initiationTime() {
        return initiationTime;
    }

    /**
     * <p>
     * Timestamp when the session was expire.
     * </p>
     * 
     * @return Timestamp when the session was expire.
     */
    public final Instant expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * Timestamp when the session was completed.
     * </p>
     * 
     * @return Timestamp when the session was completed.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * Description for the team.
     * </p>
     * 
     * @return Description for the team.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Name of the protected operation.
     * </p>
     * 
     * @return Name of the protected operation.
     */
    public final String actionName() {
        return actionName;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the protected operation.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the protected operation.
     */
    public final String protectedResourceArn() {
        return protectedResourceArn;
    }

    /**
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services"
     * >Service principal</a> for the service associated with the protected operation.
     * </p>
     * 
     * @return <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services"
     *         >Service principal</a> for the service associated with the protected operation.
     */
    public final String requesterServicePrincipal() {
        return requesterServicePrincipal;
    }

    /**
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/intro-structure.html#intro-structure-request">IAM
     * principal</a> that made the operation request.
     * </p>
     * 
     * @return <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/intro-structure.html#intro-structure-request">IAM
     *         principal</a> that made the operation request.
     */
    public final String requesterPrincipalArn() {
        return requesterPrincipalArn;
    }

    /**
     * <p>
     * Amazon Web Services Region where the operation request originated.
     * </p>
     * 
     * @return Amazon Web Services Region where the operation request originated.
     */
    public final String requesterRegion() {
        return requesterRegion;
    }

    /**
     * <p>
     * ID for the account that made the operation request.
     * </p>
     * 
     * @return ID for the account that made the operation request.
     */
    public final String requesterAccountId() {
        return requesterAccountId;
    }

    /**
     * <p>
     * Status for the protected operation. For example, if the operation is <code>PENDING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status for the protected operation. For example, if the operation is <code>PENDING</code>.
     * @see SessionStatus
     */
    public final SessionStatus status() {
        return SessionStatus.fromValue(status);
    }

    /**
     * <p>
     * Status for the protected operation. For example, if the operation is <code>PENDING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status for the protected operation. For example, if the operation is <code>PENDING</code>.
     * @see SessionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Status code of the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link SessionStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusCodeAsString}.
     * </p>
     * 
     * @return Status code of the session.
     * @see SessionStatusCode
     */
    public final SessionStatusCode statusCode() {
        return SessionStatusCode.fromValue(statusCode);
    }

    /**
     * <p>
     * Status code of the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link SessionStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusCodeAsString}.
     * </p>
     * 
     * @return Status code of the session.
     * @see SessionStatusCode
     */
    public final String statusCodeAsString() {
        return statusCode;
    }

    /**
     * <p>
     * Message describing the status for session.
     * </p>
     * 
     * @return Message describing the status for session.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Strategy for executing the protected operation. <code>AUTO_COMPLETION_UPON_APPROVAL</code> means the operation is
     * executed automatically using the requester's permissions, if approved.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionCompletionStrategy} will return {@link ActionCompletionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #actionCompletionStrategyAsString}.
     * </p>
     * 
     * @return Strategy for executing the protected operation. <code>AUTO_COMPLETION_UPON_APPROVAL</code> means the
     *         operation is executed automatically using the requester's permissions, if approved.
     * @see ActionCompletionStrategy
     */
    public final ActionCompletionStrategy actionCompletionStrategy() {
        return ActionCompletionStrategy.fromValue(actionCompletionStrategy);
    }

    /**
     * <p>
     * Strategy for executing the protected operation. <code>AUTO_COMPLETION_UPON_APPROVAL</code> means the operation is
     * executed automatically using the requester's permissions, if approved.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionCompletionStrategy} will return {@link ActionCompletionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #actionCompletionStrategyAsString}.
     * </p>
     * 
     * @return Strategy for executing the protected operation. <code>AUTO_COMPLETION_UPON_APPROVAL</code> means the
     *         operation is executed automatically using the requester's permissions, if approved.
     * @see ActionCompletionStrategy
     */
    public final String actionCompletionStrategyAsString() {
        return actionCompletionStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(approvalTeamName());
        hashCode = 31 * hashCode + Objects.hashCode(approvalTeamArn());
        hashCode = 31 * hashCode + Objects.hashCode(initiationTime());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(protectedResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(requesterServicePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(requesterPrincipalArn());
        hashCode = 31 * hashCode + Objects.hashCode(requesterRegion());
        hashCode = 31 * hashCode + Objects.hashCode(requesterAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(actionCompletionStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSessionsResponseSession)) {
            return false;
        }
        ListSessionsResponseSession other = (ListSessionsResponseSession) obj;
        return Objects.equals(sessionArn(), other.sessionArn()) && Objects.equals(approvalTeamName(), other.approvalTeamName())
                && Objects.equals(approvalTeamArn(), other.approvalTeamArn())
                && Objects.equals(initiationTime(), other.initiationTime())
                && Objects.equals(expirationTime(), other.expirationTime())
                && Objects.equals(completionTime(), other.completionTime()) && Objects.equals(description(), other.description())
                && Objects.equals(actionName(), other.actionName())
                && Objects.equals(protectedResourceArn(), other.protectedResourceArn())
                && Objects.equals(requesterServicePrincipal(), other.requesterServicePrincipal())
                && Objects.equals(requesterPrincipalArn(), other.requesterPrincipalArn())
                && Objects.equals(requesterRegion(), other.requesterRegion())
                && Objects.equals(requesterAccountId(), other.requesterAccountId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(actionCompletionStrategyAsString(), other.actionCompletionStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSessionsResponseSession").add("SessionArn", sessionArn())
                .add("ApprovalTeamName", approvalTeamName()).add("ApprovalTeamArn", approvalTeamArn())
                .add("InitiationTime", initiationTime()).add("ExpirationTime", expirationTime())
                .add("CompletionTime", completionTime())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ActionName", actionName()).add("ProtectedResourceArn", protectedResourceArn())
                .add("RequesterServicePrincipal", requesterServicePrincipal())
                .add("RequesterPrincipalArn", requesterPrincipalArn()).add("RequesterRegion", requesterRegion())
                .add("RequesterAccountId", requesterAccountId()).add("Status", statusAsString())
                .add("StatusCode", statusCodeAsString()).add("StatusMessage", statusMessage())
                .add("ActionCompletionStrategy", actionCompletionStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionArn":
            return Optional.ofNullable(clazz.cast(sessionArn()));
        case "ApprovalTeamName":
            return Optional.ofNullable(clazz.cast(approvalTeamName()));
        case "ApprovalTeamArn":
            return Optional.ofNullable(clazz.cast(approvalTeamArn()));
        case "InitiationTime":
            return Optional.ofNullable(clazz.cast(initiationTime()));
        case "ExpirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ActionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "ProtectedResourceArn":
            return Optional.ofNullable(clazz.cast(protectedResourceArn()));
        case "RequesterServicePrincipal":
            return Optional.ofNullable(clazz.cast(requesterServicePrincipal()));
        case "RequesterPrincipalArn":
            return Optional.ofNullable(clazz.cast(requesterPrincipalArn()));
        case "RequesterRegion":
            return Optional.ofNullable(clazz.cast(requesterRegion()));
        case "RequesterAccountId":
            return Optional.ofNullable(clazz.cast(requesterAccountId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "ActionCompletionStrategy":
            return Optional.ofNullable(clazz.cast(actionCompletionStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SessionArn", SESSION_ARN_FIELD);
        map.put("ApprovalTeamName", APPROVAL_TEAM_NAME_FIELD);
        map.put("ApprovalTeamArn", APPROVAL_TEAM_ARN_FIELD);
        map.put("InitiationTime", INITIATION_TIME_FIELD);
        map.put("ExpirationTime", EXPIRATION_TIME_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ActionName", ACTION_NAME_FIELD);
        map.put("ProtectedResourceArn", PROTECTED_RESOURCE_ARN_FIELD);
        map.put("RequesterServicePrincipal", REQUESTER_SERVICE_PRINCIPAL_FIELD);
        map.put("RequesterPrincipalArn", REQUESTER_PRINCIPAL_ARN_FIELD);
        map.put("RequesterRegion", REQUESTER_REGION_FIELD);
        map.put("RequesterAccountId", REQUESTER_ACCOUNT_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("ActionCompletionStrategy", ACTION_COMPLETION_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSessionsResponseSession, T> g) {
        return obj -> g.apply((ListSessionsResponseSession) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListSessionsResponseSession> {
        /**
         * <p>
         * Amazon Resource Name (ARN) for the session.
         * </p>
         * 
         * @param sessionArn
         *        Amazon Resource Name (ARN) for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionArn(String sessionArn);

        /**
         * <p>
         * Name of the approval team.
         * </p>
         * 
         * @param approvalTeamName
         *        Name of the approval team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalTeamName(String approvalTeamName);

        /**
         * <p>
         * Amazon Resource Name (ARN) for the approval team.
         * </p>
         * 
         * @param approvalTeamArn
         *        Amazon Resource Name (ARN) for the approval team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalTeamArn(String approvalTeamArn);

        /**
         * <p>
         * Timestamp when the session was initiated.
         * </p>
         * 
         * @param initiationTime
         *        Timestamp when the session was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiationTime(Instant initiationTime);

        /**
         * <p>
         * Timestamp when the session was expire.
         * </p>
         * 
         * @param expirationTime
         *        Timestamp when the session was expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);

        /**
         * <p>
         * Timestamp when the session was completed.
         * </p>
         * 
         * @param completionTime
         *        Timestamp when the session was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * Description for the team.
         * </p>
         * 
         * @param description
         *        Description for the team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Name of the protected operation.
         * </p>
         * 
         * @param actionName
         *        Name of the protected operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * Amazon Resource Name (ARN) for the protected operation.
         * </p>
         * 
         * @param protectedResourceArn
         *        Amazon Resource Name (ARN) for the protected operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedResourceArn(String protectedResourceArn);

        /**
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services"
         * >Service principal</a> for the service associated with the protected operation.
         * </p>
         * 
         * @param requesterServicePrincipal
         *        <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services"
         *        >Service principal</a> for the service associated with the protected operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterServicePrincipal(String requesterServicePrincipal);

        /**
         * <p>
         * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/intro-structure.html#intro-structure-request">IAM
         * principal</a> that made the operation request.
         * </p>
         * 
         * @param requesterPrincipalArn
         *        <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/intro-structure.html#intro-structure-request"
         *        >IAM principal</a> that made the operation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterPrincipalArn(String requesterPrincipalArn);

        /**
         * <p>
         * Amazon Web Services Region where the operation request originated.
         * </p>
         * 
         * @param requesterRegion
         *        Amazon Web Services Region where the operation request originated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterRegion(String requesterRegion);

        /**
         * <p>
         * ID for the account that made the operation request.
         * </p>
         * 
         * @param requesterAccountId
         *        ID for the account that made the operation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterAccountId(String requesterAccountId);

        /**
         * <p>
         * Status for the protected operation. For example, if the operation is <code>PENDING</code>.
         * </p>
         * 
         * @param status
         *        Status for the protected operation. For example, if the operation is <code>PENDING</code>.
         * @see SessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status for the protected operation. For example, if the operation is <code>PENDING</code>.
         * </p>
         * 
         * @param status
         *        Status for the protected operation. For example, if the operation is <code>PENDING</code>.
         * @see SessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatus
         */
        Builder status(SessionStatus status);

        /**
         * <p>
         * Status code of the session.
         * </p>
         * 
         * @param statusCode
         *        Status code of the session.
         * @see SessionStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatusCode
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * Status code of the session.
         * </p>
         * 
         * @param statusCode
         *        Status code of the session.
         * @see SessionStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatusCode
         */
        Builder statusCode(SessionStatusCode statusCode);

        /**
         * <p>
         * Message describing the status for session.
         * </p>
         * 
         * @param statusMessage
         *        Message describing the status for session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Strategy for executing the protected operation. <code>AUTO_COMPLETION_UPON_APPROVAL</code> means the
         * operation is executed automatically using the requester's permissions, if approved.
         * </p>
         * 
         * @param actionCompletionStrategy
         *        Strategy for executing the protected operation. <code>AUTO_COMPLETION_UPON_APPROVAL</code> means the
         *        operation is executed automatically using the requester's permissions, if approved.
         * @see ActionCompletionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionCompletionStrategy
         */
        Builder actionCompletionStrategy(String actionCompletionStrategy);

        /**
         * <p>
         * Strategy for executing the protected operation. <code>AUTO_COMPLETION_UPON_APPROVAL</code> means the
         * operation is executed automatically using the requester's permissions, if approved.
         * </p>
         * 
         * @param actionCompletionStrategy
         *        Strategy for executing the protected operation. <code>AUTO_COMPLETION_UPON_APPROVAL</code> means the
         *        operation is executed automatically using the requester's permissions, if approved.
         * @see ActionCompletionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionCompletionStrategy
         */
        Builder actionCompletionStrategy(ActionCompletionStrategy actionCompletionStrategy);
    }

    static final class BuilderImpl implements Builder {
        private String sessionArn;

        private String approvalTeamName;

        private String approvalTeamArn;

        private Instant initiationTime;

        private Instant expirationTime;

        private Instant completionTime;

        private String description;

        private String actionName;

        private String protectedResourceArn;

        private String requesterServicePrincipal;

        private String requesterPrincipalArn;

        private String requesterRegion;

        private String requesterAccountId;

        private String status;

        private String statusCode;

        private String statusMessage;

        private String actionCompletionStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSessionsResponseSession model) {
            sessionArn(model.sessionArn);
            approvalTeamName(model.approvalTeamName);
            approvalTeamArn(model.approvalTeamArn);
            initiationTime(model.initiationTime);
            expirationTime(model.expirationTime);
            completionTime(model.completionTime);
            description(model.description);
            actionName(model.actionName);
            protectedResourceArn(model.protectedResourceArn);
            requesterServicePrincipal(model.requesterServicePrincipal);
            requesterPrincipalArn(model.requesterPrincipalArn);
            requesterRegion(model.requesterRegion);
            requesterAccountId(model.requesterAccountId);
            status(model.status);
            statusCode(model.statusCode);
            statusMessage(model.statusMessage);
            actionCompletionStrategy(model.actionCompletionStrategy);
        }

        public final String getSessionArn() {
            return sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getApprovalTeamName() {
            return approvalTeamName;
        }

        public final void setApprovalTeamName(String approvalTeamName) {
            this.approvalTeamName = approvalTeamName;
        }

        @Override
        public final Builder approvalTeamName(String approvalTeamName) {
            this.approvalTeamName = approvalTeamName;
            return this;
        }

        public final String getApprovalTeamArn() {
            return approvalTeamArn;
        }

        public final void setApprovalTeamArn(String approvalTeamArn) {
            this.approvalTeamArn = approvalTeamArn;
        }

        @Override
        public final Builder approvalTeamArn(String approvalTeamArn) {
            this.approvalTeamArn = approvalTeamArn;
            return this;
        }

        public final Instant getInitiationTime() {
            return initiationTime;
        }

        public final void setInitiationTime(Instant initiationTime) {
            this.initiationTime = initiationTime;
        }

        @Override
        public final Builder initiationTime(Instant initiationTime) {
            this.initiationTime = initiationTime;
            return this;
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getActionName() {
            return actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final String getProtectedResourceArn() {
            return protectedResourceArn;
        }

        public final void setProtectedResourceArn(String protectedResourceArn) {
            this.protectedResourceArn = protectedResourceArn;
        }

        @Override
        public final Builder protectedResourceArn(String protectedResourceArn) {
            this.protectedResourceArn = protectedResourceArn;
            return this;
        }

        public final String getRequesterServicePrincipal() {
            return requesterServicePrincipal;
        }

        public final void setRequesterServicePrincipal(String requesterServicePrincipal) {
            this.requesterServicePrincipal = requesterServicePrincipal;
        }

        @Override
        public final Builder requesterServicePrincipal(String requesterServicePrincipal) {
            this.requesterServicePrincipal = requesterServicePrincipal;
            return this;
        }

        public final String getRequesterPrincipalArn() {
            return requesterPrincipalArn;
        }

        public final void setRequesterPrincipalArn(String requesterPrincipalArn) {
            this.requesterPrincipalArn = requesterPrincipalArn;
        }

        @Override
        public final Builder requesterPrincipalArn(String requesterPrincipalArn) {
            this.requesterPrincipalArn = requesterPrincipalArn;
            return this;
        }

        public final String getRequesterRegion() {
            return requesterRegion;
        }

        public final void setRequesterRegion(String requesterRegion) {
            this.requesterRegion = requesterRegion;
        }

        @Override
        public final Builder requesterRegion(String requesterRegion) {
            this.requesterRegion = requesterRegion;
            return this;
        }

        public final String getRequesterAccountId() {
            return requesterAccountId;
        }

        public final void setRequesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
        }

        @Override
        public final Builder requesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(SessionStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getActionCompletionStrategy() {
            return actionCompletionStrategy;
        }

        public final void setActionCompletionStrategy(String actionCompletionStrategy) {
            this.actionCompletionStrategy = actionCompletionStrategy;
        }

        @Override
        public final Builder actionCompletionStrategy(String actionCompletionStrategy) {
            this.actionCompletionStrategy = actionCompletionStrategy;
            return this;
        }

        @Override
        public final Builder actionCompletionStrategy(ActionCompletionStrategy actionCompletionStrategy) {
            this.actionCompletionStrategy(actionCompletionStrategy == null ? null : actionCompletionStrategy.toString());
            return this;
        }

        @Override
        public ListSessionsResponseSession build() {
            return new ListSessionsResponseSession(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
