/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActionCompletionStrategy {
    AUTO_COMPLETION_UPON_APPROVAL("AUTO_COMPLETION_UPON_APPROVAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionCompletionStrategy> VALUE_MAP;
    private final String value;

    private ActionCompletionStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionCompletionStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionCompletionStrategy> knownValues() {
        EnumSet<ActionCompletionStrategy> knownValues = EnumSet.allOf(ActionCompletionStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActionCompletionStrategy.class, ActionCompletionStrategy::toString);
    }
}

