/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mpa.model.ApprovalStrategyResponse;
import software.amazon.awssdk.services.mpa.model.ApprovalTeamStatus;
import software.amazon.awssdk.services.mpa.model.ApprovalTeamStatusCode;
import software.amazon.awssdk.services.mpa.model.GetApprovalTeamResponseApprover;
import software.amazon.awssdk.services.mpa.model.GetApprovalTeamResponseApproversCopier;
import software.amazon.awssdk.services.mpa.model.MpaResponse;
import software.amazon.awssdk.services.mpa.model.PendingUpdate;
import software.amazon.awssdk.services.mpa.model.PoliciesReferencesCopier;
import software.amazon.awssdk.services.mpa.model.PolicyReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApprovalTeamResponse
extends MpaResponse
implements ToCopyableBuilder<Builder, GetApprovalTeamResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(GetApprovalTeamResponse.getter(GetApprovalTeamResponse::creationTime)).setter(GetApprovalTeamResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ApprovalStrategyResponse> APPROVAL_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApprovalStrategy").getter(GetApprovalTeamResponse.getter(GetApprovalTeamResponse::approvalStrategy)).setter(GetApprovalTeamResponse.setter(Builder::approvalStrategy)).constructor(ApprovalStrategyResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalStrategy").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_APPROVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfApprovers").getter(GetApprovalTeamResponse.getter(GetApprovalTeamResponse::numberOfApprovers)).setter(GetApprovalTeamResponse.setter(Builder::numberOfApprovers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfApprovers").build()}).build();
    private static final SdkField<List<GetApprovalTeamResponseApprover>> APPROVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Approvers").getter(GetApprovalTeamResponse.getter(GetApprovalTeamResponse::approvers)).setter(GetApprovalTeamResponse.setter(Builder::approvers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Approvers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetApprovalTeamResponseApprover::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetApprovalTeamResponse.getter(GetApprovalTeamResponse::arn)).setter(GetApprovalTeamResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetApprovalTeamResponse.getter(GetApprovalTeamResponse::description)).setter(GetApprovalTeamResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetApprovalTeamResponse.getter(GetApprovalTeamResponse::name)).setter(GetApprovalTeamResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetApprovalTeamResponse.getter(GetApprovalTeamResponse::statusAsString)).setter(GetApprovalTeamResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusCode").getter(GetApprovalTeamResponse.getter(GetApprovalTeamResponse::statusCodeAsString)).setter(GetApprovalTeamResponse.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(GetApprovalTeamResponse.getter(GetApprovalTeamResponse::statusMessage)).setter(GetApprovalTeamResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> UPDATE_SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateSessionArn").getter(GetApprovalTeamResponse.getter(GetApprovalTeamResponse::updateSessionArn)).setter(GetApprovalTeamResponse.setter(Builder::updateSessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateSessionArn").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionId").getter(GetApprovalTeamResponse.getter(GetApprovalTeamResponse::versionId)).setter(GetApprovalTeamResponse.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final SdkField<List<PolicyReference>> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Policies").getter(GetApprovalTeamResponse.getter(GetApprovalTeamResponse::policies)).setter(GetApprovalTeamResponse.setter(Builder::policies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTime").getter(GetApprovalTeamResponse.getter(GetApprovalTeamResponse::lastUpdateTime)).setter(GetApprovalTeamResponse.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<PendingUpdate> PENDING_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PendingUpdate").getter(GetApprovalTeamResponse.getter(GetApprovalTeamResponse::pendingUpdate)).setter(GetApprovalTeamResponse.setter(Builder::pendingUpdate)).constructor(PendingUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, APPROVAL_STRATEGY_FIELD, NUMBER_OF_APPROVERS_FIELD, APPROVERS_FIELD, ARN_FIELD, DESCRIPTION_FIELD, NAME_FIELD, STATUS_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, UPDATE_SESSION_ARN_FIELD, VERSION_ID_FIELD, POLICIES_FIELD, LAST_UPDATE_TIME_FIELD, PENDING_UPDATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetApprovalTeamResponse.memberNameToFieldInitializer();
    private final Instant creationTime;
    private final ApprovalStrategyResponse approvalStrategy;
    private final Integer numberOfApprovers;
    private final List<GetApprovalTeamResponseApprover> approvers;
    private final String arn;
    private final String description;
    private final String name;
    private final String status;
    private final String statusCode;
    private final String statusMessage;
    private final String updateSessionArn;
    private final String versionId;
    private final List<PolicyReference> policies;
    private final Instant lastUpdateTime;
    private final PendingUpdate pendingUpdate;

    private GetApprovalTeamResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.approvalStrategy = builder.approvalStrategy;
        this.numberOfApprovers = builder.numberOfApprovers;
        this.approvers = builder.approvers;
        this.arn = builder.arn;
        this.description = builder.description;
        this.name = builder.name;
        this.status = builder.status;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.updateSessionArn = builder.updateSessionArn;
        this.versionId = builder.versionId;
        this.policies = builder.policies;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.pendingUpdate = builder.pendingUpdate;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ApprovalStrategyResponse approvalStrategy() {
        return this.approvalStrategy;
    }

    public final Integer numberOfApprovers() {
        return this.numberOfApprovers;
    }

    public final boolean hasApprovers() {
        return this.approvers != null && !(this.approvers instanceof SdkAutoConstructList);
    }

    public final List<GetApprovalTeamResponseApprover> approvers() {
        return this.approvers;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final ApprovalTeamStatus status() {
        return ApprovalTeamStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ApprovalTeamStatusCode statusCode() {
        return ApprovalTeamStatusCode.fromValue(this.statusCode);
    }

    public final String statusCodeAsString() {
        return this.statusCode;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String updateSessionArn() {
        return this.updateSessionArn;
    }

    public final String versionId() {
        return this.versionId;
    }

    public final boolean hasPolicies() {
        return this.policies != null && !(this.policies instanceof SdkAutoConstructList);
    }

    public final List<PolicyReference> policies() {
        return this.policies;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final PendingUpdate pendingUpdate() {
        return this.pendingUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfApprovers());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApprovers() ? this.approvers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicies() ? this.policies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApprovalTeamResponse)) {
            return false;
        }
        GetApprovalTeamResponse other = (GetApprovalTeamResponse)((Object)obj);
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.approvalStrategy(), other.approvalStrategy()) && Objects.equals(this.numberOfApprovers(), other.numberOfApprovers()) && this.hasApprovers() == other.hasApprovers() && Objects.equals(this.approvers(), other.approvers()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.updateSessionArn(), other.updateSessionArn()) && Objects.equals(this.versionId(), other.versionId()) && this.hasPolicies() == other.hasPolicies() && Objects.equals(this.policies(), other.policies()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.pendingUpdate(), other.pendingUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"GetApprovalTeamResponse").add("CreationTime", (Object)this.creationTime()).add("ApprovalStrategy", (Object)this.approvalStrategy()).add("NumberOfApprovers", (Object)this.numberOfApprovers()).add("Approvers", this.hasApprovers() ? this.approvers() : null).add("Arn", (Object)this.arn()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("StatusCode", (Object)this.statusCodeAsString()).add("StatusMessage", (Object)this.statusMessage()).add("UpdateSessionArn", (Object)this.updateSessionArn()).add("VersionId", (Object)this.versionId()).add("Policies", this.hasPolicies() ? this.policies() : null).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("PendingUpdate", (Object)this.pendingUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ApprovalStrategy": {
                return Optional.ofNullable(clazz.cast(this.approvalStrategy()));
            }
            case "NumberOfApprovers": {
                return Optional.ofNullable(clazz.cast(this.numberOfApprovers()));
            }
            case "Approvers": {
                return Optional.ofNullable(clazz.cast(this.approvers()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "UpdateSessionArn": {
                return Optional.ofNullable(clazz.cast(this.updateSessionArn()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "Policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "PendingUpdate": {
                return Optional.ofNullable(clazz.cast(this.pendingUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ApprovalStrategy", APPROVAL_STRATEGY_FIELD);
        map.put("NumberOfApprovers", NUMBER_OF_APPROVERS_FIELD);
        map.put("Approvers", APPROVERS_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("UpdateSessionArn", UPDATE_SESSION_ARN_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        map.put("Policies", POLICIES_FIELD);
        map.put("LastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("PendingUpdate", PENDING_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApprovalTeamResponse, T> g) {
        return obj -> g.apply((GetApprovalTeamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MpaResponse.BuilderImpl
    implements Builder {
        private Instant creationTime;
        private ApprovalStrategyResponse approvalStrategy;
        private Integer numberOfApprovers;
        private List<GetApprovalTeamResponseApprover> approvers = DefaultSdkAutoConstructList.getInstance();
        private String arn;
        private String description;
        private String name;
        private String status;
        private String statusCode;
        private String statusMessage;
        private String updateSessionArn;
        private String versionId;
        private List<PolicyReference> policies = DefaultSdkAutoConstructList.getInstance();
        private Instant lastUpdateTime;
        private PendingUpdate pendingUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApprovalTeamResponse model) {
            super(model);
            this.creationTime(model.creationTime);
            this.approvalStrategy(model.approvalStrategy);
            this.numberOfApprovers(model.numberOfApprovers);
            this.approvers(model.approvers);
            this.arn(model.arn);
            this.description(model.description);
            this.name(model.name);
            this.status(model.status);
            this.statusCode(model.statusCode);
            this.statusMessage(model.statusMessage);
            this.updateSessionArn(model.updateSessionArn);
            this.versionId(model.versionId);
            this.policies(model.policies);
            this.lastUpdateTime(model.lastUpdateTime);
            this.pendingUpdate(model.pendingUpdate);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ApprovalStrategyResponse.Builder getApprovalStrategy() {
            return this.approvalStrategy != null ? this.approvalStrategy.toBuilder() : null;
        }

        public final void setApprovalStrategy(ApprovalStrategyResponse.BuilderImpl approvalStrategy) {
            this.approvalStrategy = approvalStrategy != null ? approvalStrategy.build() : null;
        }

        @Override
        public final Builder approvalStrategy(ApprovalStrategyResponse approvalStrategy) {
            this.approvalStrategy = approvalStrategy;
            return this;
        }

        public final Integer getNumberOfApprovers() {
            return this.numberOfApprovers;
        }

        public final void setNumberOfApprovers(Integer numberOfApprovers) {
            this.numberOfApprovers = numberOfApprovers;
        }

        @Override
        public final Builder numberOfApprovers(Integer numberOfApprovers) {
            this.numberOfApprovers = numberOfApprovers;
            return this;
        }

        public final List<GetApprovalTeamResponseApprover.Builder> getApprovers() {
            List<GetApprovalTeamResponseApprover.Builder> result = GetApprovalTeamResponseApproversCopier.copyToBuilder(this.approvers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApprovers(Collection<GetApprovalTeamResponseApprover.BuilderImpl> approvers) {
            this.approvers = GetApprovalTeamResponseApproversCopier.copyFromBuilder(approvers);
        }

        @Override
        public final Builder approvers(Collection<GetApprovalTeamResponseApprover> approvers) {
            this.approvers = GetApprovalTeamResponseApproversCopier.copy(approvers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvers(GetApprovalTeamResponseApprover ... approvers) {
            this.approvers(Arrays.asList(approvers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvers(Consumer<GetApprovalTeamResponseApprover.Builder> ... approvers) {
            this.approvers(Stream.of(approvers).map(c -> (GetApprovalTeamResponseApprover)((GetApprovalTeamResponseApprover.Builder)GetApprovalTeamResponseApprover.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApprovalTeamStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(ApprovalTeamStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getUpdateSessionArn() {
            return this.updateSessionArn;
        }

        public final void setUpdateSessionArn(String updateSessionArn) {
            this.updateSessionArn = updateSessionArn;
        }

        @Override
        public final Builder updateSessionArn(String updateSessionArn) {
            this.updateSessionArn = updateSessionArn;
            return this;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final List<PolicyReference.Builder> getPolicies() {
            List<PolicyReference.Builder> result = PoliciesReferencesCopier.copyToBuilder(this.policies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicies(Collection<PolicyReference.BuilderImpl> policies) {
            this.policies = PoliciesReferencesCopier.copyFromBuilder(policies);
        }

        @Override
        public final Builder policies(Collection<PolicyReference> policies) {
            this.policies = PoliciesReferencesCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(PolicyReference ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<PolicyReference.Builder> ... policies) {
            this.policies(Stream.of(policies).map(c -> (PolicyReference)((PolicyReference.Builder)PolicyReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final PendingUpdate.Builder getPendingUpdate() {
            return this.pendingUpdate != null ? this.pendingUpdate.toBuilder() : null;
        }

        public final void setPendingUpdate(PendingUpdate.BuilderImpl pendingUpdate) {
            this.pendingUpdate = pendingUpdate != null ? pendingUpdate.build() : null;
        }

        @Override
        public final Builder pendingUpdate(PendingUpdate pendingUpdate) {
            this.pendingUpdate = pendingUpdate;
            return this;
        }

        @Override
        public GetApprovalTeamResponse build() {
            return new GetApprovalTeamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MpaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApprovalTeamResponse> {
        public Builder creationTime(Instant var1);

        public Builder approvalStrategy(ApprovalStrategyResponse var1);

        default public Builder approvalStrategy(Consumer<ApprovalStrategyResponse.Builder> approvalStrategy) {
            return this.approvalStrategy((ApprovalStrategyResponse)((ApprovalStrategyResponse.Builder)ApprovalStrategyResponse.builder().applyMutation(approvalStrategy)).build());
        }

        public Builder numberOfApprovers(Integer var1);

        public Builder approvers(Collection<GetApprovalTeamResponseApprover> var1);

        public Builder approvers(GetApprovalTeamResponseApprover ... var1);

        public Builder approvers(Consumer<GetApprovalTeamResponseApprover.Builder> ... var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(ApprovalTeamStatus var1);

        public Builder statusCode(String var1);

        public Builder statusCode(ApprovalTeamStatusCode var1);

        public Builder statusMessage(String var1);

        public Builder updateSessionArn(String var1);

        public Builder versionId(String var1);

        public Builder policies(Collection<PolicyReference> var1);

        public Builder policies(PolicyReference ... var1);

        public Builder policies(Consumer<PolicyReference.Builder> ... var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder pendingUpdate(PendingUpdate var1);

        default public Builder pendingUpdate(Consumer<PendingUpdate.Builder> pendingUpdate) {
            return this.pendingUpdate((PendingUpdate)((PendingUpdate.Builder)PendingUpdate.builder().applyMutation(pendingUpdate)).build());
        }
    }
}

