/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mpa.model.ActionCompletionStrategy;
import software.amazon.awssdk.services.mpa.model.ApprovalStrategyResponse;
import software.amazon.awssdk.services.mpa.model.GetSessionResponseApproverResponse;
import software.amazon.awssdk.services.mpa.model.GetSessionResponseApproverResponsesCopier;
import software.amazon.awssdk.services.mpa.model.MpaResponse;
import software.amazon.awssdk.services.mpa.model.SessionExecutionStatus;
import software.amazon.awssdk.services.mpa.model.SessionMetadataCopier;
import software.amazon.awssdk.services.mpa.model.SessionStatus;
import software.amazon.awssdk.services.mpa.model.SessionStatusCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSessionResponse
extends MpaResponse
implements ToCopyableBuilder<Builder, GetSessionResponse> {
    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionArn").getter(GetSessionResponse.getter(GetSessionResponse::sessionArn)).setter(GetSessionResponse.setter(Builder::sessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionArn").build()}).build();
    private static final SdkField<String> APPROVAL_TEAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApprovalTeamArn").getter(GetSessionResponse.getter(GetSessionResponse::approvalTeamArn)).setter(GetSessionResponse.setter(Builder::approvalTeamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalTeamArn").build()}).build();
    private static final SdkField<String> APPROVAL_TEAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApprovalTeamName").getter(GetSessionResponse.getter(GetSessionResponse::approvalTeamName)).setter(GetSessionResponse.setter(Builder::approvalTeamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalTeamName").build()}).build();
    private static final SdkField<String> PROTECTED_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectedResourceArn").getter(GetSessionResponse.getter(GetSessionResponse::protectedResourceArn)).setter(GetSessionResponse.setter(Builder::protectedResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceArn").build()}).build();
    private static final SdkField<ApprovalStrategyResponse> APPROVAL_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApprovalStrategy").getter(GetSessionResponse.getter(GetSessionResponse::approvalStrategy)).setter(GetSessionResponse.setter(Builder::approvalStrategy)).constructor(ApprovalStrategyResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalStrategy").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_APPROVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfApprovers").getter(GetSessionResponse.getter(GetSessionResponse::numberOfApprovers)).setter(GetSessionResponse.setter(Builder::numberOfApprovers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfApprovers").build()}).build();
    private static final SdkField<Instant> INITIATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InitiationTime").getter(GetSessionResponse.getter(GetSessionResponse::initiationTime)).setter(GetSessionResponse.setter(Builder::initiationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationTime").getter(GetSessionResponse.getter(GetSessionResponse::expirationTime)).setter(GetSessionResponse.setter(Builder::expirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(GetSessionResponse.getter(GetSessionResponse::completionTime)).setter(GetSessionResponse.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetSessionResponse.getter(GetSessionResponse::description)).setter(GetSessionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Metadata").getter(GetSessionResponse.getter(GetSessionResponse::metadata)).setter(GetSessionResponse.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetSessionResponse.getter(GetSessionResponse::statusAsString)).setter(GetSessionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusCode").getter(GetSessionResponse.getter(GetSessionResponse::statusCodeAsString)).setter(GetSessionResponse.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(GetSessionResponse.getter(GetSessionResponse::statusMessage)).setter(GetSessionResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionStatus").getter(GetSessionResponse.getter(GetSessionResponse::executionStatusAsString)).setter(GetSessionResponse.setter(Builder::executionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStatus").build()}).build();
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionName").getter(GetSessionResponse.getter(GetSessionResponse::actionName)).setter(GetSessionResponse.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build()}).build();
    private static final SdkField<String> REQUESTER_SERVICE_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequesterServicePrincipal").getter(GetSessionResponse.getter(GetSessionResponse::requesterServicePrincipal)).setter(GetSessionResponse.setter(Builder::requesterServicePrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterServicePrincipal").build()}).build();
    private static final SdkField<String> REQUESTER_PRINCIPAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequesterPrincipalArn").getter(GetSessionResponse.getter(GetSessionResponse::requesterPrincipalArn)).setter(GetSessionResponse.setter(Builder::requesterPrincipalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPrincipalArn").build()}).build();
    private static final SdkField<String> REQUESTER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequesterAccountId").getter(GetSessionResponse.getter(GetSessionResponse::requesterAccountId)).setter(GetSessionResponse.setter(Builder::requesterAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterAccountId").build()}).build();
    private static final SdkField<String> REQUESTER_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequesterRegion").getter(GetSessionResponse.getter(GetSessionResponse::requesterRegion)).setter(GetSessionResponse.setter(Builder::requesterRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterRegion").build()}).build();
    private static final SdkField<String> REQUESTER_COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequesterComment").getter(GetSessionResponse.getter(GetSessionResponse::requesterComment)).setter(GetSessionResponse.setter(Builder::requesterComment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterComment").build()}).build();
    private static final SdkField<String> ACTION_COMPLETION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionCompletionStrategy").getter(GetSessionResponse.getter(GetSessionResponse::actionCompletionStrategyAsString)).setter(GetSessionResponse.setter(Builder::actionCompletionStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionCompletionStrategy").build()}).build();
    private static final SdkField<List<GetSessionResponseApproverResponse>> APPROVER_RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApproverResponses").getter(GetSessionResponse.getter(GetSessionResponse::approverResponses)).setter(GetSessionResponse.setter(Builder::approverResponses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproverResponses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetSessionResponseApproverResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ARN_FIELD, APPROVAL_TEAM_ARN_FIELD, APPROVAL_TEAM_NAME_FIELD, PROTECTED_RESOURCE_ARN_FIELD, APPROVAL_STRATEGY_FIELD, NUMBER_OF_APPROVERS_FIELD, INITIATION_TIME_FIELD, EXPIRATION_TIME_FIELD, COMPLETION_TIME_FIELD, DESCRIPTION_FIELD, METADATA_FIELD, STATUS_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, EXECUTION_STATUS_FIELD, ACTION_NAME_FIELD, REQUESTER_SERVICE_PRINCIPAL_FIELD, REQUESTER_PRINCIPAL_ARN_FIELD, REQUESTER_ACCOUNT_ID_FIELD, REQUESTER_REGION_FIELD, REQUESTER_COMMENT_FIELD, ACTION_COMPLETION_STRATEGY_FIELD, APPROVER_RESPONSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSessionResponse.memberNameToFieldInitializer();
    private final String sessionArn;
    private final String approvalTeamArn;
    private final String approvalTeamName;
    private final String protectedResourceArn;
    private final ApprovalStrategyResponse approvalStrategy;
    private final Integer numberOfApprovers;
    private final Instant initiationTime;
    private final Instant expirationTime;
    private final Instant completionTime;
    private final String description;
    private final Map<String, String> metadata;
    private final String status;
    private final String statusCode;
    private final String statusMessage;
    private final String executionStatus;
    private final String actionName;
    private final String requesterServicePrincipal;
    private final String requesterPrincipalArn;
    private final String requesterAccountId;
    private final String requesterRegion;
    private final String requesterComment;
    private final String actionCompletionStrategy;
    private final List<GetSessionResponseApproverResponse> approverResponses;

    private GetSessionResponse(BuilderImpl builder) {
        super(builder);
        this.sessionArn = builder.sessionArn;
        this.approvalTeamArn = builder.approvalTeamArn;
        this.approvalTeamName = builder.approvalTeamName;
        this.protectedResourceArn = builder.protectedResourceArn;
        this.approvalStrategy = builder.approvalStrategy;
        this.numberOfApprovers = builder.numberOfApprovers;
        this.initiationTime = builder.initiationTime;
        this.expirationTime = builder.expirationTime;
        this.completionTime = builder.completionTime;
        this.description = builder.description;
        this.metadata = builder.metadata;
        this.status = builder.status;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.executionStatus = builder.executionStatus;
        this.actionName = builder.actionName;
        this.requesterServicePrincipal = builder.requesterServicePrincipal;
        this.requesterPrincipalArn = builder.requesterPrincipalArn;
        this.requesterAccountId = builder.requesterAccountId;
        this.requesterRegion = builder.requesterRegion;
        this.requesterComment = builder.requesterComment;
        this.actionCompletionStrategy = builder.actionCompletionStrategy;
        this.approverResponses = builder.approverResponses;
    }

    public final String sessionArn() {
        return this.sessionArn;
    }

    public final String approvalTeamArn() {
        return this.approvalTeamArn;
    }

    public final String approvalTeamName() {
        return this.approvalTeamName;
    }

    public final String protectedResourceArn() {
        return this.protectedResourceArn;
    }

    public final ApprovalStrategyResponse approvalStrategy() {
        return this.approvalStrategy;
    }

    public final Integer numberOfApprovers() {
        return this.numberOfApprovers;
    }

    public final Instant initiationTime() {
        return this.initiationTime;
    }

    public final Instant expirationTime() {
        return this.expirationTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metadata() {
        return this.metadata;
    }

    public final SessionStatus status() {
        return SessionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final SessionStatusCode statusCode() {
        return SessionStatusCode.fromValue(this.statusCode);
    }

    public final String statusCodeAsString() {
        return this.statusCode;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final SessionExecutionStatus executionStatus() {
        return SessionExecutionStatus.fromValue(this.executionStatus);
    }

    public final String executionStatusAsString() {
        return this.executionStatus;
    }

    public final String actionName() {
        return this.actionName;
    }

    public final String requesterServicePrincipal() {
        return this.requesterServicePrincipal;
    }

    public final String requesterPrincipalArn() {
        return this.requesterPrincipalArn;
    }

    public final String requesterAccountId() {
        return this.requesterAccountId;
    }

    public final String requesterRegion() {
        return this.requesterRegion;
    }

    public final String requesterComment() {
        return this.requesterComment;
    }

    public final ActionCompletionStrategy actionCompletionStrategy() {
        return ActionCompletionStrategy.fromValue(this.actionCompletionStrategy);
    }

    public final String actionCompletionStrategyAsString() {
        return this.actionCompletionStrategy;
    }

    public final boolean hasApproverResponses() {
        return this.approverResponses != null && !(this.approverResponses instanceof SdkAutoConstructList);
    }

    public final List<GetSessionResponseApproverResponse> approverResponses() {
        return this.approverResponses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalTeamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalTeamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectedResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfApprovers());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterServicePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterPrincipalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterComment());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionCompletionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApproverResponses() ? this.approverResponses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionResponse)) {
            return false;
        }
        GetSessionResponse other = (GetSessionResponse)((Object)obj);
        return Objects.equals(this.sessionArn(), other.sessionArn()) && Objects.equals(this.approvalTeamArn(), other.approvalTeamArn()) && Objects.equals(this.approvalTeamName(), other.approvalTeamName()) && Objects.equals(this.protectedResourceArn(), other.protectedResourceArn()) && Objects.equals(this.approvalStrategy(), other.approvalStrategy()) && Objects.equals(this.numberOfApprovers(), other.numberOfApprovers()) && Objects.equals(this.initiationTime(), other.initiationTime()) && Objects.equals(this.expirationTime(), other.expirationTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.description(), other.description()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.executionStatusAsString(), other.executionStatusAsString()) && Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.requesterServicePrincipal(), other.requesterServicePrincipal()) && Objects.equals(this.requesterPrincipalArn(), other.requesterPrincipalArn()) && Objects.equals(this.requesterAccountId(), other.requesterAccountId()) && Objects.equals(this.requesterRegion(), other.requesterRegion()) && Objects.equals(this.requesterComment(), other.requesterComment()) && Objects.equals(this.actionCompletionStrategyAsString(), other.actionCompletionStrategyAsString()) && this.hasApproverResponses() == other.hasApproverResponses() && Objects.equals(this.approverResponses(), other.approverResponses());
    }

    public final String toString() {
        return ToString.builder((String)"GetSessionResponse").add("SessionArn", (Object)this.sessionArn()).add("ApprovalTeamArn", (Object)this.approvalTeamArn()).add("ApprovalTeamName", (Object)this.approvalTeamName()).add("ProtectedResourceArn", (Object)this.protectedResourceArn()).add("ApprovalStrategy", (Object)this.approvalStrategy()).add("NumberOfApprovers", (Object)this.numberOfApprovers()).add("InitiationTime", (Object)this.initiationTime()).add("ExpirationTime", (Object)this.expirationTime()).add("CompletionTime", (Object)this.completionTime()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Metadata", (Object)(this.metadata() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("StatusCode", (Object)this.statusCodeAsString()).add("StatusMessage", (Object)this.statusMessage()).add("ExecutionStatus", (Object)this.executionStatusAsString()).add("ActionName", (Object)this.actionName()).add("RequesterServicePrincipal", (Object)this.requesterServicePrincipal()).add("RequesterPrincipalArn", (Object)this.requesterPrincipalArn()).add("RequesterAccountId", (Object)this.requesterAccountId()).add("RequesterRegion", (Object)this.requesterRegion()).add("RequesterComment", (Object)(this.requesterComment() == null ? null : "*** Sensitive Data Redacted ***")).add("ActionCompletionStrategy", (Object)this.actionCompletionStrategyAsString()).add("ApproverResponses", this.hasApproverResponses() ? this.approverResponses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionArn": {
                return Optional.ofNullable(clazz.cast(this.sessionArn()));
            }
            case "ApprovalTeamArn": {
                return Optional.ofNullable(clazz.cast(this.approvalTeamArn()));
            }
            case "ApprovalTeamName": {
                return Optional.ofNullable(clazz.cast(this.approvalTeamName()));
            }
            case "ProtectedResourceArn": {
                return Optional.ofNullable(clazz.cast(this.protectedResourceArn()));
            }
            case "ApprovalStrategy": {
                return Optional.ofNullable(clazz.cast(this.approvalStrategy()));
            }
            case "NumberOfApprovers": {
                return Optional.ofNullable(clazz.cast(this.numberOfApprovers()));
            }
            case "InitiationTime": {
                return Optional.ofNullable(clazz.cast(this.initiationTime()));
            }
            case "ExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.expirationTime()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "ExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.executionStatusAsString()));
            }
            case "ActionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "RequesterServicePrincipal": {
                return Optional.ofNullable(clazz.cast(this.requesterServicePrincipal()));
            }
            case "RequesterPrincipalArn": {
                return Optional.ofNullable(clazz.cast(this.requesterPrincipalArn()));
            }
            case "RequesterAccountId": {
                return Optional.ofNullable(clazz.cast(this.requesterAccountId()));
            }
            case "RequesterRegion": {
                return Optional.ofNullable(clazz.cast(this.requesterRegion()));
            }
            case "RequesterComment": {
                return Optional.ofNullable(clazz.cast(this.requesterComment()));
            }
            case "ActionCompletionStrategy": {
                return Optional.ofNullable(clazz.cast(this.actionCompletionStrategyAsString()));
            }
            case "ApproverResponses": {
                return Optional.ofNullable(clazz.cast(this.approverResponses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SessionArn", SESSION_ARN_FIELD);
        map.put("ApprovalTeamArn", APPROVAL_TEAM_ARN_FIELD);
        map.put("ApprovalTeamName", APPROVAL_TEAM_NAME_FIELD);
        map.put("ProtectedResourceArn", PROTECTED_RESOURCE_ARN_FIELD);
        map.put("ApprovalStrategy", APPROVAL_STRATEGY_FIELD);
        map.put("NumberOfApprovers", NUMBER_OF_APPROVERS_FIELD);
        map.put("InitiationTime", INITIATION_TIME_FIELD);
        map.put("ExpirationTime", EXPIRATION_TIME_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Metadata", METADATA_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("ExecutionStatus", EXECUTION_STATUS_FIELD);
        map.put("ActionName", ACTION_NAME_FIELD);
        map.put("RequesterServicePrincipal", REQUESTER_SERVICE_PRINCIPAL_FIELD);
        map.put("RequesterPrincipalArn", REQUESTER_PRINCIPAL_ARN_FIELD);
        map.put("RequesterAccountId", REQUESTER_ACCOUNT_ID_FIELD);
        map.put("RequesterRegion", REQUESTER_REGION_FIELD);
        map.put("RequesterComment", REQUESTER_COMMENT_FIELD);
        map.put("ActionCompletionStrategy", ACTION_COMPLETION_STRATEGY_FIELD);
        map.put("ApproverResponses", APPROVER_RESPONSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSessionResponse, T> g) {
        return obj -> g.apply((GetSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MpaResponse.BuilderImpl
    implements Builder {
        private String sessionArn;
        private String approvalTeamArn;
        private String approvalTeamName;
        private String protectedResourceArn;
        private ApprovalStrategyResponse approvalStrategy;
        private Integer numberOfApprovers;
        private Instant initiationTime;
        private Instant expirationTime;
        private Instant completionTime;
        private String description;
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();
        private String status;
        private String statusCode;
        private String statusMessage;
        private String executionStatus;
        private String actionName;
        private String requesterServicePrincipal;
        private String requesterPrincipalArn;
        private String requesterAccountId;
        private String requesterRegion;
        private String requesterComment;
        private String actionCompletionStrategy;
        private List<GetSessionResponseApproverResponse> approverResponses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionResponse model) {
            super(model);
            this.sessionArn(model.sessionArn);
            this.approvalTeamArn(model.approvalTeamArn);
            this.approvalTeamName(model.approvalTeamName);
            this.protectedResourceArn(model.protectedResourceArn);
            this.approvalStrategy(model.approvalStrategy);
            this.numberOfApprovers(model.numberOfApprovers);
            this.initiationTime(model.initiationTime);
            this.expirationTime(model.expirationTime);
            this.completionTime(model.completionTime);
            this.description(model.description);
            this.metadata(model.metadata);
            this.status(model.status);
            this.statusCode(model.statusCode);
            this.statusMessage(model.statusMessage);
            this.executionStatus(model.executionStatus);
            this.actionName(model.actionName);
            this.requesterServicePrincipal(model.requesterServicePrincipal);
            this.requesterPrincipalArn(model.requesterPrincipalArn);
            this.requesterAccountId(model.requesterAccountId);
            this.requesterRegion(model.requesterRegion);
            this.requesterComment(model.requesterComment);
            this.actionCompletionStrategy(model.actionCompletionStrategy);
            this.approverResponses(model.approverResponses);
        }

        public final String getSessionArn() {
            return this.sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getApprovalTeamArn() {
            return this.approvalTeamArn;
        }

        public final void setApprovalTeamArn(String approvalTeamArn) {
            this.approvalTeamArn = approvalTeamArn;
        }

        @Override
        public final Builder approvalTeamArn(String approvalTeamArn) {
            this.approvalTeamArn = approvalTeamArn;
            return this;
        }

        public final String getApprovalTeamName() {
            return this.approvalTeamName;
        }

        public final void setApprovalTeamName(String approvalTeamName) {
            this.approvalTeamName = approvalTeamName;
        }

        @Override
        public final Builder approvalTeamName(String approvalTeamName) {
            this.approvalTeamName = approvalTeamName;
            return this;
        }

        public final String getProtectedResourceArn() {
            return this.protectedResourceArn;
        }

        public final void setProtectedResourceArn(String protectedResourceArn) {
            this.protectedResourceArn = protectedResourceArn;
        }

        @Override
        public final Builder protectedResourceArn(String protectedResourceArn) {
            this.protectedResourceArn = protectedResourceArn;
            return this;
        }

        public final ApprovalStrategyResponse.Builder getApprovalStrategy() {
            return this.approvalStrategy != null ? this.approvalStrategy.toBuilder() : null;
        }

        public final void setApprovalStrategy(ApprovalStrategyResponse.BuilderImpl approvalStrategy) {
            this.approvalStrategy = approvalStrategy != null ? approvalStrategy.build() : null;
        }

        @Override
        public final Builder approvalStrategy(ApprovalStrategyResponse approvalStrategy) {
            this.approvalStrategy = approvalStrategy;
            return this;
        }

        public final Integer getNumberOfApprovers() {
            return this.numberOfApprovers;
        }

        public final void setNumberOfApprovers(Integer numberOfApprovers) {
            this.numberOfApprovers = numberOfApprovers;
        }

        @Override
        public final Builder numberOfApprovers(Integer numberOfApprovers) {
            this.numberOfApprovers = numberOfApprovers;
            return this;
        }

        public final Instant getInitiationTime() {
            return this.initiationTime;
        }

        public final void setInitiationTime(Instant initiationTime) {
            this.initiationTime = initiationTime;
        }

        @Override
        public final Builder initiationTime(Instant initiationTime) {
            this.initiationTime = initiationTime;
            return this;
        }

        public final Instant getExpirationTime() {
            return this.expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = SessionMetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = SessionMetadataCopier.copy(metadata);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(SessionStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getExecutionStatus() {
            return this.executionStatus;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(SessionExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        public final String getActionName() {
            return this.actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final String getRequesterServicePrincipal() {
            return this.requesterServicePrincipal;
        }

        public final void setRequesterServicePrincipal(String requesterServicePrincipal) {
            this.requesterServicePrincipal = requesterServicePrincipal;
        }

        @Override
        public final Builder requesterServicePrincipal(String requesterServicePrincipal) {
            this.requesterServicePrincipal = requesterServicePrincipal;
            return this;
        }

        public final String getRequesterPrincipalArn() {
            return this.requesterPrincipalArn;
        }

        public final void setRequesterPrincipalArn(String requesterPrincipalArn) {
            this.requesterPrincipalArn = requesterPrincipalArn;
        }

        @Override
        public final Builder requesterPrincipalArn(String requesterPrincipalArn) {
            this.requesterPrincipalArn = requesterPrincipalArn;
            return this;
        }

        public final String getRequesterAccountId() {
            return this.requesterAccountId;
        }

        public final void setRequesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
        }

        @Override
        public final Builder requesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
            return this;
        }

        public final String getRequesterRegion() {
            return this.requesterRegion;
        }

        public final void setRequesterRegion(String requesterRegion) {
            this.requesterRegion = requesterRegion;
        }

        @Override
        public final Builder requesterRegion(String requesterRegion) {
            this.requesterRegion = requesterRegion;
            return this;
        }

        public final String getRequesterComment() {
            return this.requesterComment;
        }

        public final void setRequesterComment(String requesterComment) {
            this.requesterComment = requesterComment;
        }

        @Override
        public final Builder requesterComment(String requesterComment) {
            this.requesterComment = requesterComment;
            return this;
        }

        public final String getActionCompletionStrategy() {
            return this.actionCompletionStrategy;
        }

        public final void setActionCompletionStrategy(String actionCompletionStrategy) {
            this.actionCompletionStrategy = actionCompletionStrategy;
        }

        @Override
        public final Builder actionCompletionStrategy(String actionCompletionStrategy) {
            this.actionCompletionStrategy = actionCompletionStrategy;
            return this;
        }

        @Override
        public final Builder actionCompletionStrategy(ActionCompletionStrategy actionCompletionStrategy) {
            this.actionCompletionStrategy(actionCompletionStrategy == null ? null : actionCompletionStrategy.toString());
            return this;
        }

        public final List<GetSessionResponseApproverResponse.Builder> getApproverResponses() {
            List<GetSessionResponseApproverResponse.Builder> result = GetSessionResponseApproverResponsesCopier.copyToBuilder(this.approverResponses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApproverResponses(Collection<GetSessionResponseApproverResponse.BuilderImpl> approverResponses) {
            this.approverResponses = GetSessionResponseApproverResponsesCopier.copyFromBuilder(approverResponses);
        }

        @Override
        public final Builder approverResponses(Collection<GetSessionResponseApproverResponse> approverResponses) {
            this.approverResponses = GetSessionResponseApproverResponsesCopier.copy(approverResponses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approverResponses(GetSessionResponseApproverResponse ... approverResponses) {
            this.approverResponses(Arrays.asList(approverResponses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approverResponses(Consumer<GetSessionResponseApproverResponse.Builder> ... approverResponses) {
            this.approverResponses(Stream.of(approverResponses).map(c -> (GetSessionResponseApproverResponse)((GetSessionResponseApproverResponse.Builder)GetSessionResponseApproverResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetSessionResponse build() {
            return new GetSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MpaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSessionResponse> {
        public Builder sessionArn(String var1);

        public Builder approvalTeamArn(String var1);

        public Builder approvalTeamName(String var1);

        public Builder protectedResourceArn(String var1);

        public Builder approvalStrategy(ApprovalStrategyResponse var1);

        default public Builder approvalStrategy(Consumer<ApprovalStrategyResponse.Builder> approvalStrategy) {
            return this.approvalStrategy((ApprovalStrategyResponse)((ApprovalStrategyResponse.Builder)ApprovalStrategyResponse.builder().applyMutation(approvalStrategy)).build());
        }

        public Builder numberOfApprovers(Integer var1);

        public Builder initiationTime(Instant var1);

        public Builder expirationTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder description(String var1);

        public Builder metadata(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(SessionStatus var1);

        public Builder statusCode(String var1);

        public Builder statusCode(SessionStatusCode var1);

        public Builder statusMessage(String var1);

        public Builder executionStatus(String var1);

        public Builder executionStatus(SessionExecutionStatus var1);

        public Builder actionName(String var1);

        public Builder requesterServicePrincipal(String var1);

        public Builder requesterPrincipalArn(String var1);

        public Builder requesterAccountId(String var1);

        public Builder requesterRegion(String var1);

        public Builder requesterComment(String var1);

        public Builder actionCompletionStrategy(String var1);

        public Builder actionCompletionStrategy(ActionCompletionStrategy var1);

        public Builder approverResponses(Collection<GetSessionResponseApproverResponse> var1);

        public Builder approverResponses(GetSessionResponseApproverResponse ... var1);

        public Builder approverResponses(Consumer<GetSessionResponseApproverResponse.Builder> ... var1);
    }
}

