/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mpa.MpaClient;
import software.amazon.awssdk.services.mpa.internal.UserAgentUtils;
import software.amazon.awssdk.services.mpa.model.IdentitySourceForList;
import software.amazon.awssdk.services.mpa.model.ListIdentitySourcesRequest;
import software.amazon.awssdk.services.mpa.model.ListIdentitySourcesResponse;

public class ListIdentitySourcesIterable
implements SdkIterable<ListIdentitySourcesResponse> {
    private final MpaClient client;
    private final ListIdentitySourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIdentitySourcesIterable(MpaClient client, ListIdentitySourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIdentitySourcesResponseFetcher();
    }

    public Iterator<ListIdentitySourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IdentitySourceForList> identitySources() {
        Function<ListIdentitySourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.identitySources() != null) {
                return response.identitySources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIdentitySourcesResponseFetcher
    implements SyncPageFetcher<ListIdentitySourcesResponse> {
        private ListIdentitySourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListIdentitySourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIdentitySourcesResponse nextPage(ListIdentitySourcesResponse previousPage) {
            if (previousPage == null) {
                return ListIdentitySourcesIterable.this.client.listIdentitySources(ListIdentitySourcesIterable.this.firstRequest);
            }
            return ListIdentitySourcesIterable.this.client.listIdentitySources((ListIdentitySourcesRequest)((Object)ListIdentitySourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

