/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for an identity source. For more information, see <a
 * href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Identity source</a> in the <i>Multi-party
 * approval User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentitySourceForList implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentitySourceForList.Builder, IdentitySourceForList> {
    private static final SdkField<String> IDENTITY_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentitySourceType").getter(getter(IdentitySourceForList::identitySourceTypeAsString))
            .setter(setter(Builder::identitySourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentitySourceType").build())
            .build();

    private static final SdkField<IdentitySourceParametersForList> IDENTITY_SOURCE_PARAMETERS_FIELD = SdkField
            .<IdentitySourceParametersForList> builder(MarshallingType.SDK_POJO).memberName("IdentitySourceParameters")
            .getter(getter(IdentitySourceForList::identitySourceParameters)).setter(setter(Builder::identitySourceParameters))
            .constructor(IdentitySourceParametersForList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentitySourceParameters").build())
            .build();

    private static final SdkField<String> IDENTITY_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentitySourceArn").getter(getter(IdentitySourceForList::identitySourceArn))
            .setter(setter(Builder::identitySourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentitySourceArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(IdentitySourceForList::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(IdentitySourceForList::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusCode").getter(getter(IdentitySourceForList::statusCodeAsString))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(IdentitySourceForList::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_SOURCE_TYPE_FIELD,
            IDENTITY_SOURCE_PARAMETERS_FIELD, IDENTITY_SOURCE_ARN_FIELD, CREATION_TIME_FIELD, STATUS_FIELD, STATUS_CODE_FIELD,
            STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String identitySourceType;

    private final IdentitySourceParametersForList identitySourceParameters;

    private final String identitySourceArn;

    private final Instant creationTime;

    private final String status;

    private final String statusCode;

    private final String statusMessage;

    private IdentitySourceForList(BuilderImpl builder) {
        this.identitySourceType = builder.identitySourceType;
        this.identitySourceParameters = builder.identitySourceParameters;
        this.identitySourceArn = builder.identitySourceArn;
        this.creationTime = builder.creationTime;
        this.status = builder.status;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The type of resource that provided identities to the identity source. For example, an IAM Identity Center
     * instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identitySourceType} will return {@link IdentitySourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #identitySourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource that provided identities to the identity source. For example, an IAM Identity Center
     *         instance.
     * @see IdentitySourceType
     */
    public final IdentitySourceType identitySourceType() {
        return IdentitySourceType.fromValue(identitySourceType);
    }

    /**
     * <p>
     * The type of resource that provided identities to the identity source. For example, an IAM Identity Center
     * instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identitySourceType} will return {@link IdentitySourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #identitySourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource that provided identities to the identity source. For example, an IAM Identity Center
     *         instance.
     * @see IdentitySourceType
     */
    public final String identitySourceTypeAsString() {
        return identitySourceType;
    }

    /**
     * <p>
     * A <code>IdentitySourceParametersForList</code> object. Contains details for the resource that provides identities
     * to the identity source. For example, an IAM Identity Center instance.
     * </p>
     * 
     * @return A <code>IdentitySourceParametersForList</code> object. Contains details for the resource that provides
     *         identities to the identity source. For example, an IAM Identity Center instance.
     */
    public final IdentitySourceParametersForList identitySourceParameters() {
        return identitySourceParameters;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the identity source.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the identity source.
     */
    public final String identitySourceArn() {
        return identitySourceArn;
    }

    /**
     * <p>
     * Timestamp when the identity source was created.
     * </p>
     * 
     * @return Timestamp when the identity source was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Status for the identity source. For example, if the identity source is <code>ACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IdentitySourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Status for the identity source. For example, if the identity source is <code>ACTIVE</code>.
     * @see IdentitySourceStatus
     */
    public final IdentitySourceStatus status() {
        return IdentitySourceStatus.fromValue(status);
    }

    /**
     * <p>
     * Status for the identity source. For example, if the identity source is <code>ACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IdentitySourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Status for the identity source. For example, if the identity source is <code>ACTIVE</code>.
     * @see IdentitySourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Status code of the identity source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link IdentitySourceStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return Status code of the identity source.
     * @see IdentitySourceStatusCode
     */
    public final IdentitySourceStatusCode statusCode() {
        return IdentitySourceStatusCode.fromValue(statusCode);
    }

    /**
     * <p>
     * Status code of the identity source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link IdentitySourceStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return Status code of the identity source.
     * @see IdentitySourceStatusCode
     */
    public final String statusCodeAsString() {
        return statusCode;
    }

    /**
     * <p>
     * Message describing the status for the identity source.
     * </p>
     * 
     * @return Message describing the status for the identity source.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identitySourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identitySourceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(identitySourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentitySourceForList)) {
            return false;
        }
        IdentitySourceForList other = (IdentitySourceForList) obj;
        return Objects.equals(identitySourceTypeAsString(), other.identitySourceTypeAsString())
                && Objects.equals(identitySourceParameters(), other.identitySourceParameters())
                && Objects.equals(identitySourceArn(), other.identitySourceArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentitySourceForList").add("IdentitySourceType", identitySourceTypeAsString())
                .add("IdentitySourceParameters", identitySourceParameters()).add("IdentitySourceArn", identitySourceArn())
                .add("CreationTime", creationTime()).add("Status", statusAsString()).add("StatusCode", statusCodeAsString())
                .add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentitySourceType":
            return Optional.ofNullable(clazz.cast(identitySourceTypeAsString()));
        case "IdentitySourceParameters":
            return Optional.ofNullable(clazz.cast(identitySourceParameters()));
        case "IdentitySourceArn":
            return Optional.ofNullable(clazz.cast(identitySourceArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentitySourceType", IDENTITY_SOURCE_TYPE_FIELD);
        map.put("IdentitySourceParameters", IDENTITY_SOURCE_PARAMETERS_FIELD);
        map.put("IdentitySourceArn", IDENTITY_SOURCE_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentitySourceForList, T> g) {
        return obj -> g.apply((IdentitySourceForList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentitySourceForList> {
        /**
         * <p>
         * The type of resource that provided identities to the identity source. For example, an IAM Identity Center
         * instance.
         * </p>
         * 
         * @param identitySourceType
         *        The type of resource that provided identities to the identity source. For example, an IAM Identity
         *        Center instance.
         * @see IdentitySourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentitySourceType
         */
        Builder identitySourceType(String identitySourceType);

        /**
         * <p>
         * The type of resource that provided identities to the identity source. For example, an IAM Identity Center
         * instance.
         * </p>
         * 
         * @param identitySourceType
         *        The type of resource that provided identities to the identity source. For example, an IAM Identity
         *        Center instance.
         * @see IdentitySourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentitySourceType
         */
        Builder identitySourceType(IdentitySourceType identitySourceType);

        /**
         * <p>
         * A <code>IdentitySourceParametersForList</code> object. Contains details for the resource that provides
         * identities to the identity source. For example, an IAM Identity Center instance.
         * </p>
         * 
         * @param identitySourceParameters
         *        A <code>IdentitySourceParametersForList</code> object. Contains details for the resource that provides
         *        identities to the identity source. For example, an IAM Identity Center instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identitySourceParameters(IdentitySourceParametersForList identitySourceParameters);

        /**
         * <p>
         * A <code>IdentitySourceParametersForList</code> object. Contains details for the resource that provides
         * identities to the identity source. For example, an IAM Identity Center instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentitySourceParametersForList.Builder}
         * avoiding the need to create one manually via {@link IdentitySourceParametersForList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentitySourceParametersForList.Builder#build()} is called
         * immediately and its result is passed to {@link #identitySourceParameters(IdentitySourceParametersForList)}.
         * 
         * @param identitySourceParameters
         *        a consumer that will call methods on {@link IdentitySourceParametersForList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identitySourceParameters(IdentitySourceParametersForList)
         */
        default Builder identitySourceParameters(Consumer<IdentitySourceParametersForList.Builder> identitySourceParameters) {
            return identitySourceParameters(IdentitySourceParametersForList.builder().applyMutation(identitySourceParameters)
                    .build());
        }

        /**
         * <p>
         * Amazon Resource Name (ARN) for the identity source.
         * </p>
         * 
         * @param identitySourceArn
         *        Amazon Resource Name (ARN) for the identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identitySourceArn(String identitySourceArn);

        /**
         * <p>
         * Timestamp when the identity source was created.
         * </p>
         * 
         * @param creationTime
         *        Timestamp when the identity source was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Status for the identity source. For example, if the identity source is <code>ACTIVE</code>.
         * </p>
         * 
         * @param status
         *        Status for the identity source. For example, if the identity source is <code>ACTIVE</code>.
         * @see IdentitySourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentitySourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status for the identity source. For example, if the identity source is <code>ACTIVE</code>.
         * </p>
         * 
         * @param status
         *        Status for the identity source. For example, if the identity source is <code>ACTIVE</code>.
         * @see IdentitySourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentitySourceStatus
         */
        Builder status(IdentitySourceStatus status);

        /**
         * <p>
         * Status code of the identity source.
         * </p>
         * 
         * @param statusCode
         *        Status code of the identity source.
         * @see IdentitySourceStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentitySourceStatusCode
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * Status code of the identity source.
         * </p>
         * 
         * @param statusCode
         *        Status code of the identity source.
         * @see IdentitySourceStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentitySourceStatusCode
         */
        Builder statusCode(IdentitySourceStatusCode statusCode);

        /**
         * <p>
         * Message describing the status for the identity source.
         * </p>
         * 
         * @param statusMessage
         *        Message describing the status for the identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String identitySourceType;

        private IdentitySourceParametersForList identitySourceParameters;

        private String identitySourceArn;

        private Instant creationTime;

        private String status;

        private String statusCode;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentitySourceForList model) {
            identitySourceType(model.identitySourceType);
            identitySourceParameters(model.identitySourceParameters);
            identitySourceArn(model.identitySourceArn);
            creationTime(model.creationTime);
            status(model.status);
            statusCode(model.statusCode);
            statusMessage(model.statusMessage);
        }

        public final String getIdentitySourceType() {
            return identitySourceType;
        }

        public final void setIdentitySourceType(String identitySourceType) {
            this.identitySourceType = identitySourceType;
        }

        @Override
        public final Builder identitySourceType(String identitySourceType) {
            this.identitySourceType = identitySourceType;
            return this;
        }

        @Override
        public final Builder identitySourceType(IdentitySourceType identitySourceType) {
            this.identitySourceType(identitySourceType == null ? null : identitySourceType.toString());
            return this;
        }

        public final IdentitySourceParametersForList.Builder getIdentitySourceParameters() {
            return identitySourceParameters != null ? identitySourceParameters.toBuilder() : null;
        }

        public final void setIdentitySourceParameters(IdentitySourceParametersForList.BuilderImpl identitySourceParameters) {
            this.identitySourceParameters = identitySourceParameters != null ? identitySourceParameters.build() : null;
        }

        @Override
        public final Builder identitySourceParameters(IdentitySourceParametersForList identitySourceParameters) {
            this.identitySourceParameters = identitySourceParameters;
            return this;
        }

        public final String getIdentitySourceArn() {
            return identitySourceArn;
        }

        public final void setIdentitySourceArn(String identitySourceArn) {
            this.identitySourceArn = identitySourceArn;
        }

        @Override
        public final Builder identitySourceArn(String identitySourceArn) {
            this.identitySourceArn = identitySourceArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IdentitySourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(IdentitySourceStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public IdentitySourceForList build() {
            return new IdentitySourceForList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
