/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPolicyVersionRequest extends MpaRequest implements
        ToCopyableBuilder<GetPolicyVersionRequest.Builder, GetPolicyVersionRequest> {
    private static final SdkField<String> POLICY_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyVersionArn").getter(getter(GetPolicyVersionRequest::policyVersionArn))
            .setter(setter(Builder::policyVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PolicyVersionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_VERSION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyVersionArn;

    private GetPolicyVersionRequest(BuilderImpl builder) {
        super(builder);
        this.policyVersionArn = builder.policyVersionArn;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the policy.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the policy.
     */
    public final String policyVersionArn() {
        return policyVersionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyVersionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyVersionRequest)) {
            return false;
        }
        GetPolicyVersionRequest other = (GetPolicyVersionRequest) obj;
        return Objects.equals(policyVersionArn(), other.policyVersionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPolicyVersionRequest").add("PolicyVersionArn", policyVersionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyVersionArn":
            return Optional.ofNullable(clazz.cast(policyVersionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyVersionArn", POLICY_VERSION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPolicyVersionRequest, T> g) {
        return obj -> g.apply((GetPolicyVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MpaRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetPolicyVersionRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) for the policy.
         * </p>
         * 
         * @param policyVersionArn
         *        Amazon Resource Name (ARN) for the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersionArn(String policyVersionArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MpaRequest.BuilderImpl implements Builder {
        private String policyVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyVersionRequest model) {
            super(model);
            policyVersionArn(model.policyVersionArn);
        }

        public final String getPolicyVersionArn() {
            return policyVersionArn;
        }

        public final void setPolicyVersionArn(String policyVersionArn) {
            this.policyVersionArn = policyVersionArn;
        }

        @Override
        public final Builder policyVersionArn(String policyVersionArn) {
            this.policyVersionArn = policyVersionArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPolicyVersionRequest build() {
            return new GetPolicyVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
