/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mobile.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mobile.MobileClient;
import software.amazon.awssdk.services.mobile.internal.UserAgentUtils;
import software.amazon.awssdk.services.mobile.model.ListBundlesRequest;
import software.amazon.awssdk.services.mobile.model.ListBundlesResponse;

public class ListBundlesIterable
implements SdkIterable<ListBundlesResponse> {
    private final MobileClient client;
    private final ListBundlesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBundlesIterable(MobileClient client, ListBundlesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBundlesResponseFetcher();
    }

    public Iterator<ListBundlesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListBundlesResponseFetcher
    implements SyncPageFetcher<ListBundlesResponse> {
        private ListBundlesResponseFetcher() {
        }

        public boolean hasNextPage(ListBundlesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBundlesResponse nextPage(ListBundlesResponse previousPage) {
            if (previousPage == null) {
                return ListBundlesIterable.this.client.listBundles(ListBundlesIterable.this.firstRequest);
            }
            return ListBundlesIterable.this.client.listBundles((ListBundlesRequest)((Object)ListBundlesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

